/*! @azure/msal-browser v3.10.0 2024-02-17 */
"use strict";!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports):"function"==typeof define&&define.amd?define(["exports"],t):t((e="undefined"!=typeof globalThis?globalThis:e||self).msal={})}(this,(function(e){
/*! @azure/msal-common v14.7.1 2024-02-17 */
const t={LIBRARY_NAME:"MSAL.JS",SKU:"msal.js.common",CACHE_PREFIX:"msal",DEFAULT_AUTHORITY:"https://login.microsoftonline.com/common/",DEFAULT_AUTHORITY_HOST:"login.microsoftonline.com",DEFAULT_COMMON_TENANT:"common",ADFS:"adfs",DSTS:"dstsv2",AAD_INSTANCE_DISCOVERY_ENDPT:"https://login.microsoftonline.com/common/discovery/instance?api-version=1.1&authorization_endpoint=",CIAM_AUTH_URL:".ciamlogin.com",AAD_TENANT_DOMAIN_SUFFIX:".onmicrosoft.com",RESOURCE_DELIM:"|",NO_ACCOUNT:"NO_ACCOUNT",CLAIMS:"claims",CONSUMER_UTID:"9188040d-6c67-4c5b-b112-36a304b66dad",OPENID_SCOPE:"openid",PROFILE_SCOPE:"profile",OFFLINE_ACCESS_SCOPE:"offline_access",EMAIL_SCOPE:"email",CODE_RESPONSE_TYPE:"code",CODE_GRANT_TYPE:"authorization_code",RT_GRANT_TYPE:"refresh_token",FRAGMENT_RESPONSE_MODE:"fragment",S256_CODE_CHALLENGE_METHOD:"S256",URL_FORM_CONTENT_TYPE:"application/x-www-form-urlencoded;charset=utf-8",AUTHORIZATION_PENDING:"authorization_pending",NOT_DEFINED:"not_defined",EMPTY_STRING:"",NOT_APPLICABLE:"N/A",FORWARD_SLASH:"/",IMDS_ENDPOINT:"http://169.254.169.254/metadata/instance/compute/location",IMDS_VERSION:"2020-06-01",IMDS_TIMEOUT:2e3,AZURE_REGION_AUTO_DISCOVER_FLAG:"TryAutoDetect",REGIONAL_AUTH_PUBLIC_CLOUD_SUFFIX:"login.microsoft.com",KNOWN_PUBLIC_CLOUDS:["login.microsoftonline.com","login.windows.net","login.microsoft.com","sts.windows.net"],TOKEN_RESPONSE_TYPE:"token",ID_TOKEN_RESPONSE_TYPE:"id_token",SHR_NONCE_VALIDITY:240,INVALID_INSTANCE:"invalid_instance"},r=400,n=499,o=500,i=599,s=[t.OPENID_SCOPE,t.PROFILE_SCOPE,t.OFFLINE_ACCESS_SCOPE],a=[...s,t.EMAIL_SCOPE],c="Content-Type",l="Retry-After",h="X-AnchorMailbox",d="WWW-Authenticate",u="Authentication-Info",g="x-ms-request-id",p="x-ms-httpver",m="idtoken",f="client.info",C="adal.idtoken",y="error",v="error.description",I="active-account",T="active-account-filters",w="common",A="organizations",k="consumers",S="access_token",E="xms_cc",R={LOGIN:"login",SELECT_ACCOUNT:"select_account",CONSENT:"consent",NONE:"none",CREATE:"create",NO_SESSION:"no_session"},b={PLAIN:"plain",S256:"S256"},_={QUERY:"query",FRAGMENT:"fragment"},P={..._,FORM_POST:"form_post"},M="authorization_code",N="refresh_token",O="MSSTS",q="ADFS",L="Generic",U={CACHE_KEY_SEPARATOR:"-",CLIENT_INFO_SEPARATOR:"."},H={ID_TOKEN:"IdToken",ACCESS_TOKEN:"AccessToken",ACCESS_TOKEN_WITH_AUTH_SCHEME:"AccessToken_With_AuthScheme",REFRESH_TOKEN:"RefreshToken"},B="appmetadata",D="1",x="authority-metadata",F=86400,K="config",z="cache",$="network",G="hardcoded_values",Q={SCHEMA_VERSION:5,MAX_CUR_HEADER_BYTES:80,MAX_LAST_HEADER_BYTES:330,MAX_CACHED_ERRORS:50,CACHE_KEY:"server-telemetry",CATEGORY_SEPARATOR:"|",VALUE_SEPARATOR:",",OVERFLOW_TRUE:"1",OVERFLOW_FALSE:"0",UNKNOWN_ERROR:"unknown_error"},j={BEARER:"Bearer",POP:"pop",SSH:"ssh-cert"},W=60,Y=3600,V="throttling",J="retry-after, h429",X="invalid_grant",Z="client_mismatch",ee="username",te="password",re=200,ne=400,oe="1",ie="3",se="4",ae="2",ce="4",le="5",he="0",de="1",ue="2",ge="3",pe="4",me={Jwt:"JWT",Jwk:"JWK",Pop:"pop"},fe="unexpected_error",Ce="post_request_failed";var ye=Object.freeze({__proto__:null,postRequestFailed:Ce,unexpectedError:fe});
/*! @azure/msal-common v14.7.1 2024-02-17 */const ve={[fe]:"Unexpected error in authentication.",[Ce]:"Post request failed from the network, could be a 4xx/5xx or a network unavailability. Please check the exact error code for details."},Ie={unexpectedError:{code:fe,desc:ve[fe]},postRequestFailed:{code:Ce,desc:ve[Ce]}};class Te extends Error{constructor(e,r,n){super(r?`${e}: ${r}`:e),Object.setPrototypeOf(this,Te.prototype),this.errorCode=e||t.EMPTY_STRING,this.errorMessage=r||t.EMPTY_STRING,this.subError=n||t.EMPTY_STRING,this.name="AuthError"}setCorrelationId(e){this.correlationId=e}}function we(e,t){return new Te(e,t?`${ve[e]} ${t}`:ve[e])}
/*! @azure/msal-common v14.7.1 2024-02-17 */const Ae="client_info_decoding_error",ke="client_info_empty_error",Se="token_parsing_error",Ee="null_or_empty_token",Re="endpoints_resolution_error",be="network_error",_e="openid_config_error",Pe="hash_not_deserialized",Me="invalid_state",Ne="state_mismatch",Oe="state_not_found",qe="nonce_mismatch",Le="auth_time_not_found",Ue="max_age_transpired",He="multiple_matching_tokens",Be="multiple_matching_accounts",De="multiple_matching_appMetadata",xe="request_cannot_be_made",Fe="cannot_remove_empty_scope",Ke="cannot_append_scopeset",ze="empty_input_scopeset",$e="device_code_polling_cancelled",Ge="device_code_expired",Qe="device_code_unknown_error",je="no_account_in_silent_request",We="invalid_cache_record",Ye="invalid_cache_environment",Ve="no_account_found",Je="no_crypto_object",Xe="unexpected_credential_type",Ze="invalid_assertion",et="invalid_client_credential",tt="token_refresh_required",rt="user_timeout_reached",nt="token_claims_cnf_required_for_signedjwt",ot="authorization_code_missing_from_server_response",it="binding_key_not_removed",st="end_session_endpoint_not_supported",at="key_id_missing",ct="no_network_connectivity",lt="user_canceled",ht="missing_tenant_id_error",dt="method_not_implemented",ut="nested_app_auth_bridge_disabled";var gt=Object.freeze({__proto__:null,authTimeNotFound:Le,authorizationCodeMissingFromServerResponse:ot,bindingKeyNotRemoved:it,cannotAppendScopeSet:Ke,cannotRemoveEmptyScope:Fe,clientInfoDecodingError:Ae,clientInfoEmptyError:ke,deviceCodeExpired:Ge,deviceCodePollingCancelled:$e,deviceCodeUnknownError:Qe,emptyInputScopeSet:ze,endSessionEndpointNotSupported:st,endpointResolutionError:Re,hashNotDeserialized:Pe,invalidAssertion:Ze,invalidCacheEnvironment:Ye,invalidCacheRecord:We,invalidClientCredential:et,invalidState:Me,keyIdMissing:at,maxAgeTranspired:Ue,methodNotImplemented:dt,missingTenantIdError:ht,multipleMatchingAccounts:Be,multipleMatchingAppMetadata:De,multipleMatchingTokens:He,nestedAppAuthBridgeDisabled:ut,networkError:be,noAccountFound:Ve,noAccountInSilentRequest:je,noCryptoObject:Je,noNetworkConnectivity:ct,nonceMismatch:qe,nullOrEmptyToken:Ee,openIdConfigError:_e,requestCannotBeMade:xe,stateMismatch:Ne,stateNotFound:Oe,tokenClaimsCnfRequiredForSignedJwt:nt,tokenParsingError:Se,tokenRefreshRequired:tt,unexpectedCredentialType:Xe,userCanceled:lt,userTimeoutReached:rt});
/*! @azure/msal-common v14.7.1 2024-02-17 */const pt={[Ae]:"The client info could not be parsed/decoded correctly",[ke]:"The client info was empty",[Se]:"Token cannot be parsed",[Ee]:"The token is null or empty",[Re]:"Endpoints cannot be resolved",[be]:"Network request failed",[_e]:"Could not retrieve endpoints. Check your authority and verify the .well-known/openid-configuration endpoint returns the required endpoints.",[Pe]:"The hash parameters could not be deserialized",[Me]:"State was not the expected format",[Ne]:"State mismatch error",[Oe]:"State not found",[qe]:"Nonce mismatch error",[Le]:"Max Age was requested and the ID token is missing the auth_time variable. auth_time is an optional claim and is not enabled by default - it must be enabled. See https://aka.ms/msaljs/optional-claims for more information.",[Ue]:"Max Age is set to 0, or too much time has elapsed since the last end-user authentication.",[He]:"The cache contains multiple tokens satisfying the requirements. Call AcquireToken again providing more requirements such as authority or account.",[Be]:"The cache contains multiple accounts satisfying the given parameters. Please pass more info to obtain the correct account",[De]:"The cache contains multiple appMetadata satisfying the given parameters. Please pass more info to obtain the correct appMetadata",[xe]:"Token request cannot be made without authorization code or refresh token.",[Fe]:"Cannot remove null or empty scope from ScopeSet",[Ke]:"Cannot append ScopeSet",[ze]:"Empty input ScopeSet cannot be processed",[$e]:"Caller has cancelled token endpoint polling during device code flow by setting DeviceCodeRequest.cancel = true.",[Ge]:"Device code is expired.",[Qe]:"Device code stopped polling for unknown reasons.",[je]:"Please pass an account object, silent flow is not supported without account information",[We]:"Cache record object was null or undefined.",[Ye]:"Invalid environment when attempting to create cache entry",[Ve]:"No account found in cache for given key.",[Je]:"No crypto object detected.",[Xe]:"Unexpected credential type.",[Ze]:"Client assertion must meet requirements described in https://tools.ietf.org/html/rfc7515",[et]:"Client credential (secret, certificate, or assertion) must not be empty when creating a confidential client. An application should at most have one credential",[tt]:"Cannot return token from cache because it must be refreshed. This may be due to one of the following reasons: forceRefresh parameter is set to true, claims have been requested, there is no cached access token or it is expired.",[rt]:"User defined timeout for device code polling reached",[nt]:"Cannot generate a POP jwt if the token_claims are not populated",[ot]:"Server response does not contain an authorization code to proceed",[it]:"Could not remove the credential's binding key from storage.",[st]:"The provided authority does not support logout",[at]:"A keyId value is missing from the requested bound token's cache record and is required to match the token to it's stored binding key.",[ct]:"No network connectivity. Check your internet connection.",[lt]:"User cancelled the flow.",[ht]:"A tenant id - not common, organizations, or consumers - must be specified when using the client_credentials flow.",[dt]:"This method has not been implemented",[ut]:"The nested app auth bridge is disabled"},mt={clientInfoDecodingError:{code:Ae,desc:pt[Ae]},clientInfoEmptyError:{code:ke,desc:pt[ke]},tokenParsingError:{code:Se,desc:pt[Se]},nullOrEmptyToken:{code:Ee,desc:pt[Ee]},endpointResolutionError:{code:Re,desc:pt[Re]},networkError:{code:be,desc:pt[be]},unableToGetOpenidConfigError:{code:_e,desc:pt[_e]},hashNotDeserialized:{code:Pe,desc:pt[Pe]},invalidStateError:{code:Me,desc:pt[Me]},stateMismatchError:{code:Ne,desc:pt[Ne]},stateNotFoundError:{code:Oe,desc:pt[Oe]},nonceMismatchError:{code:qe,desc:pt[qe]},authTimeNotFoundError:{code:Le,desc:pt[Le]},maxAgeTranspired:{code:Ue,desc:pt[Ue]},multipleMatchingTokens:{code:He,desc:pt[He]},multipleMatchingAccounts:{code:Be,desc:pt[Be]},multipleMatchingAppMetadata:{code:De,desc:pt[De]},tokenRequestCannotBeMade:{code:xe,desc:pt[xe]},removeEmptyScopeError:{code:Fe,desc:pt[Fe]},appendScopeSetError:{code:Ke,desc:pt[Ke]},emptyInputScopeSetError:{code:ze,desc:pt[ze]},DeviceCodePollingCancelled:{code:$e,desc:pt[$e]},DeviceCodeExpired:{code:Ge,desc:pt[Ge]},DeviceCodeUnknownError:{code:Qe,desc:pt[Qe]},NoAccountInSilentRequest:{code:je,desc:pt[je]},invalidCacheRecord:{code:We,desc:pt[We]},invalidCacheEnvironment:{code:Ye,desc:pt[Ye]},noAccountFound:{code:Ve,desc:pt[Ve]},noCryptoObj:{code:Je,desc:pt[Je]},unexpectedCredentialType:{code:Xe,desc:pt[Xe]},invalidAssertion:{code:Ze,desc:pt[Ze]},invalidClientCredential:{code:et,desc:pt[et]},tokenRefreshRequired:{code:tt,desc:pt[tt]},userTimeoutReached:{code:rt,desc:pt[rt]},tokenClaimsRequired:{code:nt,desc:pt[nt]},noAuthorizationCodeFromServer:{code:ot,desc:pt[ot]},bindingKeyNotRemovedError:{code:it,desc:pt[it]},logoutNotSupported:{code:st,desc:pt[st]},keyIdMissing:{code:at,desc:pt[at]},noNetworkConnectivity:{code:ct,desc:pt[ct]},userCanceledError:{code:lt,desc:pt[lt]},missingTenantIdError:{code:ht,desc:pt[ht]},nestedAppAuthBridgeDisabled:{code:ut,desc:pt[ut]}};class ft extends Te{constructor(e,t){super(e,t?`${pt[e]}: ${t}`:pt[e]),this.name="ClientAuthError",Object.setPrototypeOf(this,ft.prototype)}}function Ct(e,t){return new ft(e,t)}
/*! @azure/msal-common v14.7.1 2024-02-17 */const yt={createNewGuid:()=>{throw Ct(dt)},base64Decode:()=>{throw Ct(dt)},base64Encode:()=>{throw Ct(dt)},async getPublicKeyThumbprint(){throw Ct(dt)},async removeTokenBindingKey(){throw Ct(dt)},async clearKeystore(){throw Ct(dt)},async signJwt(){throw Ct(dt)},async hashString(){throw Ct(dt)}};
/*! @azure/msal-common v14.7.1 2024-02-17 */var vt;e.LogLevel=void 0,(vt=e.LogLevel||(e.LogLevel={}))[vt.Error=0]="Error",vt[vt.Warning=1]="Warning",vt[vt.Info=2]="Info",vt[vt.Verbose=3]="Verbose",vt[vt.Trace=4]="Trace";class It{constructor(r,n,o){this.level=e.LogLevel.Info;const i=r||It.createDefaultLoggerOptions();this.localCallback=i.loggerCallback||(()=>{}),this.piiLoggingEnabled=i.piiLoggingEnabled||!1,this.level="number"==typeof i.logLevel?i.logLevel:e.LogLevel.Info,this.correlationId=i.correlationId||t.EMPTY_STRING,this.packageName=n||t.EMPTY_STRING,this.packageVersion=o||t.EMPTY_STRING}static createDefaultLoggerOptions(){return{loggerCallback:()=>{},piiLoggingEnabled:!1,logLevel:e.LogLevel.Info}}clone(e,t,r){return new It({loggerCallback:this.localCallback,piiLoggingEnabled:this.piiLoggingEnabled,logLevel:this.level,correlationId:r||this.correlationId},e,t)}logMessage(t,r){if(r.logLevel>this.level||!this.piiLoggingEnabled&&r.containsPii)return;const n=`${`[${(new Date).toUTCString()}] : [${r.correlationId||this.correlationId||""}]`} : ${this.packageName}@${this.packageVersion} : ${e.LogLevel[r.logLevel]} - ${t}`;this.executeCallback(r.logLevel,n,r.containsPii||!1)}executeCallback(e,t,r){this.localCallback&&this.localCallback(e,t,r)}error(r,n){this.logMessage(r,{logLevel:e.LogLevel.Error,containsPii:!1,correlationId:n||t.EMPTY_STRING})}errorPii(r,n){this.logMessage(r,{logLevel:e.LogLevel.Error,containsPii:!0,correlationId:n||t.EMPTY_STRING})}warning(r,n){this.logMessage(r,{logLevel:e.LogLevel.Warning,containsPii:!1,correlationId:n||t.EMPTY_STRING})}warningPii(r,n){this.logMessage(r,{logLevel:e.LogLevel.Warning,containsPii:!0,correlationId:n||t.EMPTY_STRING})}info(r,n){this.logMessage(r,{logLevel:e.LogLevel.Info,containsPii:!1,correlationId:n||t.EMPTY_STRING})}infoPii(r,n){this.logMessage(r,{logLevel:e.LogLevel.Info,containsPii:!0,correlationId:n||t.EMPTY_STRING})}verbose(r,n){this.logMessage(r,{logLevel:e.LogLevel.Verbose,containsPii:!1,correlationId:n||t.EMPTY_STRING})}verbosePii(r,n){this.logMessage(r,{logLevel:e.LogLevel.Verbose,containsPii:!0,correlationId:n||t.EMPTY_STRING})}trace(r,n){this.logMessage(r,{logLevel:e.LogLevel.Trace,containsPii:!1,correlationId:n||t.EMPTY_STRING})}tracePii(r,n){this.logMessage(r,{logLevel:e.LogLevel.Trace,containsPii:!0,correlationId:n||t.EMPTY_STRING})}isPiiLoggingEnabled(){return this.piiLoggingEnabled||!1}}
/*! @azure/msal-common v14.7.1 2024-02-17 */const Tt="@azure/msal-common",wt="14.7.1",At={None:"none",AzurePublic:"https://login.microsoftonline.com",AzurePpe:"https://login.windows-ppe.net",AzureChina:"https://login.chinacloudapi.cn",AzureGermany:"https://login.microsoftonline.de",AzureUsGovernment:"https://login.microsoftonline.us"};
/*! @azure/msal-common v14.7.1 2024-02-17 */
function kt(e,t){const r=function(e){if(!e)throw Ct(Ee);const t=/^([^\.\s]*)\.([^\.\s]+)\.([^\.\s]*)$/.exec(e);if(!t||t.length<4)throw Ct(Se);return t[2]}(e);try{const e=t(r);return JSON.parse(e)}catch(e){throw Ct(Se)}}function St(e,t){if(0===t||Date.now()-3e5>e+t)throw Ct(Ue)}
/*! @azure/msal-common v14.7.1 2024-02-17 */function Et(){return Math.round((new Date).getTime()/1e3)}function Rt(e,t){const r=Number(e)||0;return Et()+t>r}
/*! @azure/msal-common v14.7.1 2024-02-17 */
function bt(e){return[Ut(e),Ht(e),Bt(e),Dt(e),xt(e)].join(U.CACHE_KEY_SEPARATOR).toLowerCase()}function _t(e,t,r,n,o){return{credentialType:H.ID_TOKEN,homeAccountId:e,environment:t,clientId:n,secret:r,realm:o}}function Pt(e,t,r,n,o,i,s,a,c,l,h,d,u,g,p){const m={homeAccountId:e,credentialType:H.ACCESS_TOKEN,secret:r,cachedAt:Et().toString(),expiresOn:s.toString(),extendedExpiresOn:a.toString(),environment:t,clientId:n,realm:o,target:i,tokenType:h||j.BEARER};if(d&&(m.userAssertionHash=d),l&&(m.refreshOn=l.toString()),g&&(m.requestedClaims=g,m.requestedClaimsHash=p),m.tokenType?.toLowerCase()!==j.BEARER.toLowerCase())switch(m.credentialType=H.ACCESS_TOKEN_WITH_AUTH_SCHEME,m.tokenType){case j.POP:const e=kt(r,c);if(!e?.cnf?.kid)throw Ct(nt);m.keyId=e.cnf.kid;break;case j.SSH:m.keyId=u}return m}function Mt(e,t,r,n,o,i,s){const a={credentialType:H.REFRESH_TOKEN,homeAccountId:e,environment:t,clientId:n,secret:r};return i&&(a.userAssertionHash=i),o&&(a.familyId=o),s&&(a.expiresOn=s.toString()),a}function Nt(e){return e.hasOwnProperty("homeAccountId")&&e.hasOwnProperty("environment")&&e.hasOwnProperty("credentialType")&&e.hasOwnProperty("clientId")&&e.hasOwnProperty("secret")}function Ot(e){return!!e&&(Nt(e)&&e.hasOwnProperty("realm")&&e.hasOwnProperty("target")&&(e.credentialType===H.ACCESS_TOKEN||e.credentialType===H.ACCESS_TOKEN_WITH_AUTH_SCHEME))}function qt(e){return!!e&&(Nt(e)&&e.hasOwnProperty("realm")&&e.credentialType===H.ID_TOKEN)}function Lt(e){return!!e&&(Nt(e)&&e.credentialType===H.REFRESH_TOKEN)}function Ut(e){return[e.homeAccountId,e.environment].join(U.CACHE_KEY_SEPARATOR).toLowerCase()}function Ht(e){const t=e.credentialType===H.REFRESH_TOKEN&&e.familyId||e.clientId;return[e.credentialType,t,e.realm||""].join(U.CACHE_KEY_SEPARATOR).toLowerCase()}function Bt(e){return(e.target||"").toLowerCase()}function Dt(e){return(e.requestedClaimsHash||"").toLowerCase()}function xt(e){return e.tokenType&&e.tokenType.toLowerCase()!==j.BEARER.toLowerCase()?e.tokenType.toLowerCase():""}function Ft(){return Et()+F}function Kt(e,t,r){e.authorization_endpoint=t.authorization_endpoint,e.token_endpoint=t.token_endpoint,e.end_session_endpoint=t.end_session_endpoint,e.issuer=t.issuer,e.endpointsFromNetwork=r,e.jwks_uri=t.jwks_uri}function zt(e,t,r){e.aliases=t.aliases,e.preferred_cache=t.preferred_cache,e.preferred_network=t.preferred_network,e.aliasesFromNetwork=r}function $t(e){return e.expiresAt<=Et()}
/*! @azure/msal-common v14.7.1 2024-02-17 */const Gt="redirect_uri_empty",Qt="claims_request_parsing_error",jt="authority_uri_insecure",Wt="url_parse_error",Yt="empty_url_error",Vt="empty_input_scopes_error",Jt="invalid_prompt_value",Xt="invalid_claims",Zt="token_request_empty",er="logout_request_empty",tr="invalid_code_challenge_method",rr="pkce_params_missing",nr="invalid_cloud_discovery_metadata",or="invalid_authority_metadata",ir="untrusted_authority",sr="missing_ssh_jwk",ar="missing_ssh_kid",cr="missing_nonce_authentication_header",lr="invalid_authentication_header",hr="cannot_set_OIDCOptions",dr="cannot_allow_native_broker",ur="authority_mismatch";var gr=Object.freeze({__proto__:null,authorityMismatch:ur,authorityUriInsecure:jt,cannotAllowNativeBroker:dr,cannotSetOIDCOptions:hr,claimsRequestParsingError:Qt,emptyInputScopesError:Vt,invalidAuthenticationHeader:lr,invalidAuthorityMetadata:or,invalidClaims:Xt,invalidCloudDiscoveryMetadata:nr,invalidCodeChallengeMethod:tr,invalidPromptValue:Jt,logoutRequestEmpty:er,missingNonceAuthenticationHeader:cr,missingSshJwk:sr,missingSshKid:ar,pkceParamsMissing:rr,redirectUriEmpty:Gt,tokenRequestEmpty:Zt,untrustedAuthority:ir,urlEmptyError:Yt,urlParseError:Wt});
/*! @azure/msal-common v14.7.1 2024-02-17 */const pr={[Gt]:"A redirect URI is required for all calls, and none has been set.",[Qt]:"Could not parse the given claims request object.",[jt]:"Authority URIs must use https.  Please see here for valid authority configuration options: https://docs.microsoft.com/en-us/azure/active-directory/develop/msal-js-initializing-client-applications#configuration-options",[Wt]:"URL could not be parsed into appropriate segments.",[Yt]:"URL was empty or null.",[Vt]:"Scopes cannot be passed as null, undefined or empty array because they are required to obtain an access token.",[Jt]:"Please see here for valid configuration options: https://azuread.github.io/microsoft-authentication-library-for-js/ref/modules/_azure_msal_common.html#commonauthorizationurlrequest",[Xt]:"Given claims parameter must be a stringified JSON object.",[Zt]:"Token request was empty and not found in cache.",[er]:"The logout request was null or undefined.",[tr]:'code_challenge_method passed is invalid. Valid values are "plain" and "S256".',[rr]:"Both params: code_challenge and code_challenge_method are to be passed if to be sent in the request",[nr]:"Invalid cloudDiscoveryMetadata provided. Must be a stringified JSON object containing tenant_discovery_endpoint and metadata fields",[or]:"Invalid authorityMetadata provided. Must by a stringified JSON object containing authorization_endpoint, token_endpoint, issuer fields.",[ir]:"The provided authority is not a trusted authority. Please include this authority in the knownAuthorities config parameter.",[sr]:"Missing sshJwk in SSH certificate request. A stringified JSON Web Key is required when using the SSH authentication scheme.",[ar]:"Missing sshKid in SSH certificate request. A string that uniquely identifies the public SSH key is required when using the SSH authentication scheme.",[cr]:"Unable to find an authentication header containing server nonce. Either the Authentication-Info or WWW-Authenticate headers must be present in order to obtain a server nonce.",[lr]:"Invalid authentication header provided",[hr]:"Cannot set OIDCOptions parameter. Please change the protocol mode to OIDC or use a non-Microsoft authority.",[dr]:"Cannot set allowNativeBroker parameter to true when not in AAD protocol mode.",[ur]:"Authority mismatch error. Authority provided in login request or PublicClientApplication config does not match the environment of the provided account. Please use a matching account or make an interactive request to login to this authority."},mr={redirectUriNotSet:{code:Gt,desc:pr[Gt]},claimsRequestParsingError:{code:Qt,desc:pr[Qt]},authorityUriInsecure:{code:jt,desc:pr[jt]},urlParseError:{code:Wt,desc:pr[Wt]},urlEmptyError:{code:Yt,desc:pr[Yt]},emptyScopesError:{code:Vt,desc:pr[Vt]},invalidPrompt:{code:Jt,desc:pr[Jt]},invalidClaimsRequest:{code:Xt,desc:pr[Xt]},tokenRequestEmptyError:{code:Zt,desc:pr[Zt]},logoutRequestEmptyError:{code:er,desc:pr[er]},invalidCodeChallengeMethod:{code:tr,desc:pr[tr]},invalidCodeChallengeParams:{code:rr,desc:pr[rr]},invalidCloudDiscoveryMetadata:{code:nr,desc:pr[nr]},invalidAuthorityMetadata:{code:or,desc:pr[or]},untrustedAuthority:{code:ir,desc:pr[ir]},missingSshJwk:{code:sr,desc:pr[sr]},missingSshKid:{code:ar,desc:pr[ar]},missingNonceAuthenticationHeader:{code:cr,desc:pr[cr]},invalidAuthenticationHeader:{code:lr,desc:pr[lr]},cannotSetOIDCOptions:{code:hr,desc:pr[hr]},cannotAllowNativeBroker:{code:dr,desc:pr[dr]},authorityMismatch:{code:ur,desc:pr[ur]}};class fr extends Te{constructor(e){super(e,pr[e]),this.name="ClientConfigurationError",Object.setPrototypeOf(this,fr.prototype)}}function Cr(e){return new fr(e)}
/*! @azure/msal-common v14.7.1 2024-02-17 */class yr{static isEmptyObj(e){if(e)try{const t=JSON.parse(e);return 0===Object.keys(t).length}catch(e){}return!0}static startsWith(e,t){return 0===e.indexOf(t)}static endsWith(e,t){return e.length>=t.length&&e.lastIndexOf(t)===e.length-t.length}static queryStringToObject(e){const t={},r=e.split("&"),n=e=>decodeURIComponent(e.replace(/\+/g," "));return r.forEach((e=>{if(e.trim()){const[r,o]=e.split(/=(.+)/g,2);r&&o&&(t[n(r)]=n(o))}})),t}static trimArrayEntries(e){return e.map((e=>e.trim()))}static removeEmptyStringsFromArray(e){return e.filter((e=>!!e))}static jsonParseHelper(e){try{return JSON.parse(e)}catch(e){return null}}static matchPattern(e,t){return new RegExp(e.replace(/\\/g,"\\\\").replace(/\*/g,"[^ ]*").replace(/\?/g,"\\?")).test(t)}}
/*! @azure/msal-common v14.7.1 2024-02-17 */class vr{constructor(e){const t=e?yr.trimArrayEntries([...e]):[],r=t?yr.removeEmptyStringsFromArray(t):[];this.validateInputScopes(r),this.scopes=new Set,r.forEach((e=>this.scopes.add(e)))}static fromString(e){const r=(e||t.EMPTY_STRING).split(" ");return new vr(r)}static createSearchScopes(e){const r=new vr(e);return r.containsOnlyOIDCScopes()?r.removeScope(t.OFFLINE_ACCESS_SCOPE):r.removeOIDCScopes(),r}validateInputScopes(e){if(!e||e.length<1)throw Cr(Vt)}containsScope(e){const t=this.printScopesLowerCase().split(" "),r=new vr(t);return!!e&&r.scopes.has(e.toLowerCase())}containsScopeSet(e){return!(!e||e.scopes.size<=0)&&(this.scopes.size>=e.scopes.size&&e.asArray().every((e=>this.containsScope(e))))}containsOnlyOIDCScopes(){let e=0;return a.forEach((t=>{this.containsScope(t)&&(e+=1)})),this.scopes.size===e}appendScope(e){e&&this.scopes.add(e.trim())}appendScopes(e){try{e.forEach((e=>this.appendScope(e)))}catch(e){throw Ct(Ke)}}removeScope(e){if(!e)throw Ct(Fe);this.scopes.delete(e.trim())}removeOIDCScopes(){a.forEach((e=>{this.scopes.delete(e)}))}unionScopeSets(e){if(!e)throw Ct(ze);const t=new Set;return e.scopes.forEach((e=>t.add(e.toLowerCase()))),this.scopes.forEach((e=>t.add(e.toLowerCase()))),t}intersectingScopeSets(e){if(!e)throw Ct(ze);e.containsOnlyOIDCScopes()||e.removeOIDCScopes();const t=this.unionScopeSets(e),r=e.getScopeCount(),n=this.getScopeCount();return t.size<n+r}getScopeCount(){return this.scopes.size}asArray(){const e=[];return this.scopes.forEach((t=>e.push(t))),e}printScopes(){if(this.scopes){return this.asArray().join(" ")}return t.EMPTY_STRING}printScopesLowerCase(){return this.printScopes().toLowerCase()}}
/*! @azure/msal-common v14.7.1 2024-02-17 */function Ir(e,t){if(!e)throw Ct(ke);try{const r=t(e);return JSON.parse(r)}catch(e){throw Ct(Ae)}}function Tr(e){if(!e)throw Ct(Ae);const r=e.split(U.CLIENT_INFO_SEPARATOR,2);return{uid:r[0],utid:r.length<2?t.EMPTY_STRING:r[1]}}
/*! @azure/msal-common v14.7.1 2024-02-17 */function wr(e,t){return!!e&&!!t&&e===t.split(".")[1]}function Ar(e,t){const{oid:r,sub:n,tid:o,name:i,tfp:s,acr:a}=t,c=o||s||a||"";return{tenantId:c,localAccountId:r||n||"",name:i,isHomeTenant:wr(c,e)}}function kr(e,t,r,n){let o=e;if(t){const{isHomeTenant:r,...n}=t;o={...e,...n}}if(r){const{isHomeTenant:t,...i}=Ar(e.homeAccountId,r);return o={...o,...i,idTokenClaims:r,idToken:n},o}return o}
/*! @azure/msal-common v14.7.1 2024-02-17 */const Sr=0,Er=1,Rr=2,br=3;
/*! @azure/msal-common v14.7.1 2024-02-17 */function _r(e){if(e){return e.tid||e.tfp||e.acr||null}return null}
/*! @azure/msal-common v14.7.1 2024-02-17 */const Pr={AAD:"AAD",OIDC:"OIDC"};
/*! @azure/msal-common v14.7.1 2024-02-17 */class Mr{generateAccountId(){return[this.homeAccountId,this.environment].join(U.CACHE_KEY_SEPARATOR).toLowerCase()}generateAccountKey(){return Mr.generateAccountCacheKey({homeAccountId:this.homeAccountId,environment:this.environment,tenantId:this.realm,username:this.username,localAccountId:this.localAccountId})}getAccountInfo(){return{homeAccountId:this.homeAccountId,environment:this.environment,tenantId:this.realm,username:this.username,localAccountId:this.localAccountId,name:this.name,nativeAccountId:this.nativeAccountId,authorityType:this.authorityType,tenantProfiles:new Map((this.tenantProfiles||[]).map((e=>[e.tenantId,e])))}}isSingleTenant(){return!this.tenantProfiles}static generateAccountCacheKey(e){const t=e.homeAccountId.split(".")[1];return[e.homeAccountId,e.environment||"",t||e.tenantId||""].join(U.CACHE_KEY_SEPARATOR).toLowerCase()}static createAccount(e,t,r){const n=new Mr;let o;t.authorityType===Er?n.authorityType=q:t.protocolMode===Pr.AAD?n.authorityType=O:n.authorityType=L,e.clientInfo&&r&&(o=Ir(e.clientInfo,r)),n.clientInfo=e.clientInfo,n.homeAccountId=e.homeAccountId,n.nativeAccountId=e.nativeAccountId;const i=e.environment||t&&t.getPreferredCache();if(!i)throw Ct(Ye);n.environment=i,n.realm=o?.utid||_r(e.idTokenClaims)||"",n.localAccountId=o?.uid||e.idTokenClaims.oid||e.idTokenClaims.sub||"";const s=e.idTokenClaims.preferred_username||e.idTokenClaims.upn,a=e.idTokenClaims.emails?e.idTokenClaims.emails[0]:null;if(n.username=s||a||"",n.name=e.idTokenClaims.name,n.cloudGraphHostName=e.cloudGraphHostName,n.msGraphHost=e.msGraphHost,e.tenantProfiles)n.tenantProfiles=e.tenantProfiles;else{const t=[];if(e.idTokenClaims){const r=Ar(e.homeAccountId,e.idTokenClaims);t.push(r)}n.tenantProfiles=t}return n}static createFromAccountInfo(e,t,r){const n=new Mr;return n.authorityType=e.authorityType||L,n.homeAccountId=e.homeAccountId,n.localAccountId=e.localAccountId,n.nativeAccountId=e.nativeAccountId,n.realm=e.tenantId,n.environment=e.environment,n.username=e.username,n.name=e.name,n.cloudGraphHostName=t,n.msGraphHost=r,n.tenantProfiles=Array.from(e.tenantProfiles?.values()||[]),n}static generateHomeAccountId(e,t,r,n,o){if(t!==Er&&t!==Rr){if(e)try{const t=Ir(e,n.base64Decode);if(t.uid&&t.utid)return`${t.uid}.${t.utid}`}catch(e){}r.warning("No client info in response")}return o?.sub||""}static isAccountEntity(e){return!!e&&(e.hasOwnProperty("homeAccountId")&&e.hasOwnProperty("environment")&&e.hasOwnProperty("realm")&&e.hasOwnProperty("localAccountId")&&e.hasOwnProperty("username")&&e.hasOwnProperty("authorityType"))}static accountInfoIsEqual(e,t,r){if(!e||!t)return!1;let n=!0;if(r){const r=e.idTokenClaims||{},o=t.idTokenClaims||{};n=r.iat===o.iat&&r.nonce===o.nonce}return e.homeAccountId===t.homeAccountId&&e.localAccountId===t.localAccountId&&e.username===t.username&&e.tenantId===t.tenantId&&e.environment===t.environment&&e.nativeAccountId===t.nativeAccountId&&n}}
/*! @azure/msal-common v14.7.1 2024-02-17 */function Nr(e){return e.startsWith("#/")?e.substring(2):e.startsWith("#")||e.startsWith("?")?e.substring(1):e}function Or(e){if(!e||e.indexOf("=")<0)return null;try{const t=Nr(e),r=Object.fromEntries(new URLSearchParams(t));if(r.code||r.error||r.error_description||r.state)return r}catch(e){throw Ct(Pe)}return null}
/*! @azure/msal-common v14.7.1 2024-02-17 */class qr{get urlString(){return this._urlString}constructor(e){if(this._urlString=e,!this._urlString)throw Cr(Yt);e.includes("#")||(this._urlString=qr.canonicalizeUri(e))}static canonicalizeUri(e){if(e){let t=e.toLowerCase();return yr.endsWith(t,"?")?t=t.slice(0,-1):yr.endsWith(t,"?/")&&(t=t.slice(0,-2)),yr.endsWith(t,"/")||(t+="/"),t}return e}validateAsUri(){let e;try{e=this.getUrlComponents()}catch(e){throw Cr(Wt)}if(!e.HostNameAndPort||!e.PathSegments)throw Cr(Wt);if(!e.Protocol||"https:"!==e.Protocol.toLowerCase())throw Cr(jt)}static appendQueryString(e,t){return t?e.indexOf("?")<0?`${e}?${t}`:`${e}&${t}`:e}static removeHashFromUrl(e){return qr.canonicalizeUri(e.split("#")[0])}replaceTenantPath(e){const t=this.getUrlComponents(),r=t.PathSegments;return!e||0===r.length||r[0]!==w&&r[0]!==A||(r[0]=e),qr.constructAuthorityUriFromObject(t)}getUrlComponents(){const e=RegExp("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?"),t=this.urlString.match(e);if(!t)throw Cr(Wt);const r={Protocol:t[1],HostNameAndPort:t[4],AbsolutePath:t[5],QueryString:t[7]};let n=r.AbsolutePath.split("/");return n=n.filter((e=>e&&e.length>0)),r.PathSegments=n,r.QueryString&&r.QueryString.endsWith("/")&&(r.QueryString=r.QueryString.substring(0,r.QueryString.length-1)),r}static getDomainFromUrl(e){const t=RegExp("^([^:/?#]+://)?([^/?#]*)"),r=e.match(t);if(!r)throw Cr(Wt);return r[2]}static getAbsoluteUrl(e,r){if(e[0]===t.FORWARD_SLASH){const t=new qr(r).getUrlComponents();return t.Protocol+"//"+t.HostNameAndPort+e}return e}static constructAuthorityUriFromObject(e){return new qr(e.Protocol+"//"+e.HostNameAndPort+"/"+e.PathSegments.join("/"))}static hashContainsKnownProperties(e){return!!Or(e)}}
/*! @azure/msal-common v14.7.1 2024-02-17 */const Lr={"login.microsoftonline.com":{token_endpoint:"https://login.microsoftonline.com/{tenantid}/oauth2/v2.0/token",jwks_uri:"https://login.microsoftonline.com/{tenantid}/discovery/v2.0/keys",issuer:"https://login.microsoftonline.com/{tenantid}/v2.0",authorization_endpoint:"https://login.microsoftonline.com/{tenantid}/oauth2/v2.0/authorize",end_session_endpoint:"https://login.microsoftonline.com/{tenantid}/oauth2/v2.0/logout"},"login.chinacloudapi.cn":{token_endpoint:"https://login.chinacloudapi.cn/{tenantid}/oauth2/v2.0/token",jwks_uri:"https://login.chinacloudapi.cn/{tenantid}/discovery/v2.0/keys",issuer:"https://login.partner.microsoftonline.cn/{tenantid}/v2.0",authorization_endpoint:"https://login.chinacloudapi.cn/{tenantid}/oauth2/v2.0/authorize",end_session_endpoint:"https://login.chinacloudapi.cn/{tenantid}/oauth2/v2.0/logout"},"login.microsoftonline.us":{token_endpoint:"https://login.microsoftonline.us/{tenantid}/oauth2/v2.0/token",jwks_uri:"https://login.microsoftonline.us/{tenantid}/discovery/v2.0/keys",issuer:"https://login.microsoftonline.us/{tenantid}/v2.0",authorization_endpoint:"https://login.microsoftonline.us/{tenantid}/oauth2/v2.0/authorize",end_session_endpoint:"https://login.microsoftonline.us/{tenantid}/oauth2/v2.0/logout"}},Ur={tenant_discovery_endpoint:"https://{canonicalAuthority}/v2.0/.well-known/openid-configuration",metadata:[{preferred_network:"login.microsoftonline.com",preferred_cache:"login.windows.net",aliases:["login.microsoftonline.com","login.windows.net","login.microsoft.com","sts.windows.net"]},{preferred_network:"login.partner.microsoftonline.cn",preferred_cache:"login.partner.microsoftonline.cn",aliases:["login.partner.microsoftonline.cn","login.chinacloudapi.cn"]},{preferred_network:"login.microsoftonline.de",preferred_cache:"login.microsoftonline.de",aliases:["login.microsoftonline.de"]},{preferred_network:"login.microsoftonline.us",preferred_cache:"login.microsoftonline.us",aliases:["login.microsoftonline.us","login.usgovcloudapi.net"]},{preferred_network:"login-us.microsoftonline.com",preferred_cache:"login-us.microsoftonline.com",aliases:["login-us.microsoftonline.com"]}]},Hr=new Set;function Br(e,t,r,n){if(n?.trace(`getAliasesFromMetadata called with source: ${r}`),e&&t){const o=Dr(t,e);if(o)return n?.trace(`getAliasesFromMetadata: found cloud discovery metadata in ${r}, returning aliases`),o.aliases;n?.trace(`getAliasesFromMetadata: did not find cloud discovery metadata in ${r}`)}return null}function Dr(e,t){for(let r=0;r<e.length;r++){const n=e[r];if(n.aliases.includes(t))return n}return null}
/*! @azure/msal-common v14.7.1 2024-02-17 */Ur.metadata.forEach((e=>{e.aliases.forEach((e=>{Hr.add(e)}))}));class xr{constructor(e,t,r,n){this.clientId=e,this.cryptoImpl=t,this.commonLogger=r.clone(Tt,wt),this.staticAuthorityOptions=n}getAllAccounts(e){return this.buildTenantProfiles(this.getAccountsFilteredBy(e||{}),e)}getAccountInfoFilteredBy(e){const t=this.getAllAccounts(e);if(t.length>1){return t.sort((e=>e.idTokenClaims?-1:1))[0]}return 1===t.length?t[0]:null}getBaseAccountInfo(e){const t=this.getAccountsFilteredBy(e);return t.length>0?t[0].getAccountInfo():null}buildTenantProfiles(e,t){return e.flatMap((e=>this.getAccountInfoForTenantProfiles(e,t)))}getAccountInfoForTenantProfiles(e,t){return this.getTenantProfilesFromAccountEntity(e,t?.tenantId,t)}getTenantedAccountInfoByFilter(e,t,r,n){let o,i=null;if(n&&!this.tenantProfileMatchesFilter(r,n))return null;const s=this.getIdToken(e,t,r.tenantId);return s&&(o=kt(s.secret,this.cryptoImpl.base64Decode),!this.idTokenClaimsMatchTenantProfileFilter(o,n))?null:(i=kr(e,r,o,s?.secret),i)}getTenantProfilesFromAccountEntity(e,t,r){const n=e.getAccountInfo();let o=n.tenantProfiles||new Map;const i=this.getTokenKeys();if(t){const e=o.get(t);if(!e)return[];o=new Map([[t,e]])}const s=[];return o.forEach((e=>{const t=this.getTenantedAccountInfoByFilter(n,i,e,r);t&&s.push(t)})),s}tenantProfileMatchesFilter(e,t){return!(t.localAccountId&&!this.matchLocalAccountIdFromTenantProfile(e,t.localAccountId))&&((!t.name||e.name===t.name)&&(void 0===t.isHomeTenant||e.isHomeTenant===t.isHomeTenant))}idTokenClaimsMatchTenantProfileFilter(e,t){if(t){if(t.localAccountId&&!this.matchLocalAccountIdFromTokenClaims(e,t.localAccountId))return!1;if(t.loginHint&&!this.matchLoginHintFromTokenClaims(e,t.loginHint))return!1;if(t.username&&!this.matchUsername(e.preferred_username,t.username))return!1;if(t.name&&!this.matchName(e,t.name))return!1;if(t.sid&&!this.matchSid(e,t.sid))return!1}return!0}async saveCacheRecord(e,t){if(!e)throw Ct(We);e.account&&this.setAccount(e.account),e.idToken&&!1!==t?.idToken&&this.setIdTokenCredential(e.idToken),e.accessToken&&!1!==t?.accessToken&&await this.saveAccessToken(e.accessToken),e.refreshToken&&!1!==t?.refreshToken&&this.setRefreshTokenCredential(e.refreshToken),e.appMetadata&&this.setAppMetadata(e.appMetadata)}async saveAccessToken(e){const t={clientId:e.clientId,credentialType:e.credentialType,environment:e.environment,homeAccountId:e.homeAccountId,realm:e.realm,tokenType:e.tokenType,requestedClaimsHash:e.requestedClaimsHash},r=this.getTokenKeys(),n=vr.fromString(e.target),o=[];r.accessToken.forEach((e=>{if(!this.accessTokenKeyMatchesFilter(e,t,!1))return;const r=this.getAccessTokenCredential(e);if(r&&this.credentialMatchesFilter(r,t)){vr.fromString(r.target).intersectingScopeSets(n)&&o.push(this.removeAccessToken(e))}})),await Promise.all(o),this.setAccessTokenCredential(e)}getAccountsFilteredBy(e){const t=this.getAccountKeys(),r=[];return t.forEach((t=>{if(!this.isAccountKey(t,e.homeAccountId))return;const n=this.getAccount(t,this.commonLogger);if(!n)return;if(e.homeAccountId&&!this.matchHomeAccountId(n,e.homeAccountId))return;if(e.username&&!this.matchUsername(n.username,e.username))return;if(e.environment&&!this.matchEnvironment(n,e.environment))return;if(e.realm&&!this.matchRealm(n,e.realm))return;if(e.nativeAccountId&&!this.matchNativeAccountId(n,e.nativeAccountId))return;if(e.authorityType&&!this.matchAuthorityType(n,e.authorityType))return;const o={localAccountId:e?.localAccountId,name:e?.name},i=n.tenantProfiles?.filter((e=>this.tenantProfileMatchesFilter(e,o)));i&&0===i.length||r.push(n)})),r}isAccountKey(e,t,r){return!(e.split(U.CACHE_KEY_SEPARATOR).length<3)&&(!(t&&!e.toLowerCase().includes(t.toLowerCase()))&&!(r&&!e.toLowerCase().includes(r.toLowerCase())))}isCredentialKey(e){if(e.split(U.CACHE_KEY_SEPARATOR).length<6)return!1;const t=e.toLowerCase();if(-1===t.indexOf(H.ID_TOKEN.toLowerCase())&&-1===t.indexOf(H.ACCESS_TOKEN.toLowerCase())&&-1===t.indexOf(H.ACCESS_TOKEN_WITH_AUTH_SCHEME.toLowerCase())&&-1===t.indexOf(H.REFRESH_TOKEN.toLowerCase()))return!1;if(t.indexOf(H.REFRESH_TOKEN.toLowerCase())>-1){const e=`${H.REFRESH_TOKEN}${U.CACHE_KEY_SEPARATOR}${this.clientId}${U.CACHE_KEY_SEPARATOR}`,r=`${H.REFRESH_TOKEN}${U.CACHE_KEY_SEPARATOR}${D}${U.CACHE_KEY_SEPARATOR}`;if(-1===t.indexOf(e.toLowerCase())&&-1===t.indexOf(r.toLowerCase()))return!1}else if(-1===t.indexOf(this.clientId.toLowerCase()))return!1;return!0}credentialMatchesFilter(e,t){if(t.clientId&&!this.matchClientId(e,t.clientId))return!1;if(t.userAssertionHash&&!this.matchUserAssertionHash(e,t.userAssertionHash))return!1;if("string"==typeof t.homeAccountId&&!this.matchHomeAccountId(e,t.homeAccountId))return!1;if(t.environment&&!this.matchEnvironment(e,t.environment))return!1;if(t.realm&&!this.matchRealm(e,t.realm))return!1;if(t.credentialType&&!this.matchCredentialType(e,t.credentialType))return!1;if(t.familyId&&!this.matchFamilyId(e,t.familyId))return!1;if(t.target&&!this.matchTarget(e,t.target))return!1;if((t.requestedClaimsHash||e.requestedClaimsHash)&&e.requestedClaimsHash!==t.requestedClaimsHash)return!1;if(e.credentialType===H.ACCESS_TOKEN_WITH_AUTH_SCHEME){if(t.tokenType&&!this.matchTokenType(e,t.tokenType))return!1;if(t.tokenType===j.SSH&&t.keyId&&!this.matchKeyId(e,t.keyId))return!1}return!0}getAppMetadataFilteredBy(e){return this.getAppMetadataFilteredByInternal(e.environment,e.clientId)}getAppMetadataFilteredByInternal(e,t){const r=this.getKeys(),n={};return r.forEach((r=>{if(!this.isAppMetadata(r))return;const o=this.getAppMetadata(r);o&&(e&&!this.matchEnvironment(o,e)||t&&!this.matchClientId(o,t)||(n[r]=o))})),n}getAuthorityMetadataByAlias(e){const t=this.getAuthorityMetadataKeys();let r=null;return t.forEach((t=>{if(!this.isAuthorityMetadata(t)||-1===t.indexOf(this.clientId))return;const n=this.getAuthorityMetadata(t);n&&-1!==n.aliases.indexOf(e)&&(r=n)})),r}async removeAllAccounts(){const e=this.getAccountKeys(),t=[];e.forEach((e=>{t.push(this.removeAccount(e))})),await Promise.all(t)}async removeAccount(e){const t=this.getAccount(e,this.commonLogger);t&&(await this.removeAccountContext(t),this.removeItem(e))}async removeAccountContext(e){const t=this.getTokenKeys(),r=e.generateAccountId(),n=[];t.idToken.forEach((e=>{0===e.indexOf(r)&&this.removeIdToken(e)})),t.accessToken.forEach((e=>{0===e.indexOf(r)&&n.push(this.removeAccessToken(e))})),t.refreshToken.forEach((e=>{0===e.indexOf(r)&&this.removeRefreshToken(e)})),await Promise.all(n)}updateOutdatedCachedAccount(e,t,r){if(t&&t.isSingleTenant()){this.commonLogger?.verbose("updateOutdatedCachedAccount: Found a single-tenant (outdated) account entity in the cache, migrating to multi-tenant account entity");const n=this.getAccountKeys().filter((e=>e.startsWith(t.homeAccountId))),o=[];n.forEach((e=>{const t=this.getCachedAccountEntity(e);t&&o.push(t)}));const i=o.find((e=>wr(e.realm,e.homeAccountId)))||o[0];i.tenantProfiles=o.map((e=>({tenantId:e.realm,localAccountId:e.localAccountId,name:e.name,isHomeTenant:wr(e.realm,e.homeAccountId)})));const s=xr.toObject(new Mr,{...i}),a=s.generateAccountKey();return n.forEach((t=>{t!==a&&this.removeOutdatedAccount(e)})),this.setAccount(s),r?.verbose("Updated an outdated account entity in the cache"),s}return t}async removeAccessToken(e){const t=this.getAccessTokenCredential(e);if(t){if(t.credentialType.toLowerCase()===H.ACCESS_TOKEN_WITH_AUTH_SCHEME.toLowerCase()&&t.tokenType===j.POP){const e=t.keyId;if(e)try{await this.cryptoImpl.removeTokenBindingKey(e)}catch(e){throw Ct(it)}}return this.removeItem(e)}}removeAppMetadata(){return this.getKeys().forEach((e=>{this.isAppMetadata(e)&&this.removeItem(e)})),!0}readAccountFromCache(e){const t=Mr.generateAccountCacheKey(e);return this.getAccount(t,this.commonLogger)}getIdToken(e,t,r,n,o){this.commonLogger.trace("CacheManager - getIdToken called");const i={homeAccountId:e.homeAccountId,environment:e.environment,credentialType:H.ID_TOKEN,clientId:this.clientId,realm:r},s=this.getIdTokensByFilter(i,t),a=s.size;if(a<1)return this.commonLogger.info("CacheManager:getIdToken - No token found"),null;if(a>1){let t=s;if(!r){const r=new Map;s.forEach(((t,n)=>{t.realm===e.tenantId&&r.set(n,t)}));const n=r.size;if(n<1)return this.commonLogger.info("CacheManager:getIdToken - Multiple ID tokens found for account but none match account entity tenant id, returning first result"),s.values().next().value;if(1===n)return this.commonLogger.info("CacheManager:getIdToken - Multiple ID tokens found for account, defaulting to home tenant profile"),r.values().next().value;t=r}return this.commonLogger.info("CacheManager:getIdToken - Multiple matching ID tokens found, clearing them"),t.forEach(((e,t)=>{this.removeIdToken(t)})),n&&o&&n.addFields({multiMatchedID:s.size},o),null}return this.commonLogger.info("CacheManager:getIdToken - Returning ID token"),s.values().next().value}getIdTokensByFilter(e,t){const r=t&&t.idToken||this.getTokenKeys().idToken,n=new Map;return r.forEach((t=>{if(!this.idTokenKeyMatchesFilter(t,{clientId:this.clientId,...e}))return;const r=this.getIdTokenCredential(t);r&&this.credentialMatchesFilter(r,e)&&n.set(t,r)})),n}idTokenKeyMatchesFilter(e,t){const r=e.toLowerCase();return(!t.clientId||-1!==r.indexOf(t.clientId.toLowerCase()))&&(!t.homeAccountId||-1!==r.indexOf(t.homeAccountId.toLowerCase()))}removeIdToken(e){this.removeItem(e)}removeRefreshToken(e){this.removeItem(e)}getAccessToken(e,t,r,n,o,i){this.commonLogger.trace("CacheManager - getAccessToken called");const s=vr.createSearchScopes(t.scopes),a=t.authenticationScheme||j.BEARER,c=a&&a.toLowerCase()!==j.BEARER.toLowerCase()?H.ACCESS_TOKEN_WITH_AUTH_SCHEME:H.ACCESS_TOKEN,l={homeAccountId:e.homeAccountId,environment:e.environment,credentialType:c,clientId:this.clientId,realm:n||e.tenantId,target:s,tokenType:a,keyId:t.sshKid,requestedClaimsHash:t.requestedClaimsHash},h=r&&r.accessToken||this.getTokenKeys().accessToken,d=[];h.forEach((e=>{if(this.accessTokenKeyMatchesFilter(e,l,!0)){const t=this.getAccessTokenCredential(e);t&&this.credentialMatchesFilter(t,l)&&d.push(t)}}));const u=d.length;return u<1?(this.commonLogger.info("CacheManager:getAccessToken - No token found"),null):u>1?(this.commonLogger.info("CacheManager:getAccessToken - Multiple access tokens found, clearing them"),d.forEach((e=>{this.removeAccessToken(bt(e))})),o&&i&&o.addFields({multiMatchedAT:d.length},i),null):(this.commonLogger.info("CacheManager:getAccessToken - Returning access token"),d[0])}accessTokenKeyMatchesFilter(e,t,r){const n=e.toLowerCase();if(t.clientId&&-1===n.indexOf(t.clientId.toLowerCase()))return!1;if(t.homeAccountId&&-1===n.indexOf(t.homeAccountId.toLowerCase()))return!1;if(t.realm&&-1===n.indexOf(t.realm.toLowerCase()))return!1;if(t.requestedClaimsHash&&-1===n.indexOf(t.requestedClaimsHash.toLowerCase()))return!1;if(t.target){const e=t.target.asArray();for(let t=0;t<e.length;t++){if(r&&!n.includes(e[t].toLowerCase()))return!1;if(!r&&n.includes(e[t].toLowerCase()))return!0}}return!0}getAccessTokensByFilter(e){const t=this.getTokenKeys(),r=[];return t.accessToken.forEach((t=>{if(!this.accessTokenKeyMatchesFilter(t,e,!0))return;const n=this.getAccessTokenCredential(t);n&&this.credentialMatchesFilter(n,e)&&r.push(n)})),r}getRefreshToken(e,t,r,n,o){this.commonLogger.trace("CacheManager - getRefreshToken called");const i=t?D:void 0,s={homeAccountId:e.homeAccountId,environment:e.environment,credentialType:H.REFRESH_TOKEN,clientId:this.clientId,familyId:i},a=r&&r.refreshToken||this.getTokenKeys().refreshToken,c=[];a.forEach((e=>{if(this.refreshTokenKeyMatchesFilter(e,s)){const t=this.getRefreshTokenCredential(e);t&&this.credentialMatchesFilter(t,s)&&c.push(t)}}));const l=c.length;return l<1?(this.commonLogger.info("CacheManager:getRefreshToken - No refresh token found."),null):(l>1&&n&&o&&n.addFields({multiMatchedRT:l},o),this.commonLogger.info("CacheManager:getRefreshToken - returning refresh token"),c[0])}refreshTokenKeyMatchesFilter(e,t){const r=e.toLowerCase();return(!t.familyId||-1!==r.indexOf(t.familyId.toLowerCase()))&&(!(!t.familyId&&t.clientId&&-1===r.indexOf(t.clientId.toLowerCase()))&&(!t.homeAccountId||-1!==r.indexOf(t.homeAccountId.toLowerCase())))}readAppMetadataFromCache(e){const t={environment:e,clientId:this.clientId},r=this.getAppMetadataFilteredBy(t),n=Object.keys(r).map((e=>r[e])),o=n.length;if(o<1)return null;if(o>1)throw Ct(De);return n[0]}isAppMetadataFOCI(e){const t=this.readAppMetadataFromCache(e);return!(!t||t.familyId!==D)}matchHomeAccountId(e,t){return!("string"!=typeof e.homeAccountId||t!==e.homeAccountId)}matchLocalAccountIdFromTokenClaims(e,t){return t===(e.oid||e.sub)}matchLocalAccountIdFromTenantProfile(e,t){return e.localAccountId===t}matchName(e,t){return!(t.toLowerCase()!==e.name?.toLowerCase())}matchUsername(e,t){return!(!e||"string"!=typeof e||t?.toLowerCase()!==e.toLowerCase())}matchUserAssertionHash(e,t){return!(!e.userAssertionHash||t!==e.userAssertionHash)}matchEnvironment(e,t){if(this.staticAuthorityOptions){const r=function(e,t){let r;const n=e.canonicalAuthority;if(n){const o=new qr(n).getUrlComponents().HostNameAndPort;r=Br(o,e.cloudDiscoveryMetadata?.metadata,K,t)||Br(o,Ur.metadata,G,t)||e.knownAuthorities}return r||[]}(this.staticAuthorityOptions,this.commonLogger);if(r.includes(t)&&r.includes(e.environment))return!0}const r=this.getAuthorityMetadataByAlias(t);return!!(r&&r.aliases.indexOf(e.environment)>-1)}matchCredentialType(e,t){return e.credentialType&&t.toLowerCase()===e.credentialType.toLowerCase()}matchClientId(e,t){return!(!e.clientId||t!==e.clientId)}matchFamilyId(e,t){return!(!e.familyId||t!==e.familyId)}matchRealm(e,t){return!(e.realm?.toLowerCase()!==t.toLowerCase())}matchNativeAccountId(e,t){return!(!e.nativeAccountId||t!==e.nativeAccountId)}matchLoginHintFromTokenClaims(e,t){return e.login_hint===t||(e.preferred_username===t||e.upn===t)}matchSid(e,t){return e.sid===t}matchAuthorityType(e,t){return!(!e.authorityType||t.toLowerCase()!==e.authorityType.toLowerCase())}matchTarget(e,t){if(e.credentialType!==H.ACCESS_TOKEN&&e.credentialType!==H.ACCESS_TOKEN_WITH_AUTH_SCHEME||!e.target)return!1;return vr.fromString(e.target).containsScopeSet(t)}matchTokenType(e,t){return!(!e.tokenType||e.tokenType!==t)}matchKeyId(e,t){return!(!e.keyId||e.keyId!==t)}isAppMetadata(e){return-1!==e.indexOf(B)}isAuthorityMetadata(e){return-1!==e.indexOf(x)}generateAuthorityMetadataCacheKey(e){return`${x}-${this.clientId}-${e}`}static toObject(e,t){for(const r in t)e[r]=t[r];return e}}class Fr extends xr{setAccount(){throw Ct(dt)}getAccount(){throw Ct(dt)}getCachedAccountEntity(){throw Ct(dt)}setIdTokenCredential(){throw Ct(dt)}getIdTokenCredential(){throw Ct(dt)}setAccessTokenCredential(){throw Ct(dt)}getAccessTokenCredential(){throw Ct(dt)}setRefreshTokenCredential(){throw Ct(dt)}getRefreshTokenCredential(){throw Ct(dt)}setAppMetadata(){throw Ct(dt)}getAppMetadata(){throw Ct(dt)}setServerTelemetry(){throw Ct(dt)}getServerTelemetry(){throw Ct(dt)}setAuthorityMetadata(){throw Ct(dt)}getAuthorityMetadata(){throw Ct(dt)}getAuthorityMetadataKeys(){throw Ct(dt)}setThrottlingCache(){throw Ct(dt)}getThrottlingCache(){throw Ct(dt)}removeItem(){throw Ct(dt)}containsKey(){throw Ct(dt)}getKeys(){throw Ct(dt)}getAccountKeys(){throw Ct(dt)}getTokenKeys(){throw Ct(dt)}async clear(){throw Ct(dt)}updateCredentialCacheKey(){throw Ct(dt)}removeOutdatedAccount(){throw Ct(dt)}}
/*! @azure/msal-common v14.7.1 2024-02-17 */const Kr={tokenRenewalOffsetSeconds:300,preventCorsPreflight:!1},zr={loggerCallback:()=>{},piiLoggingEnabled:!1,logLevel:e.LogLevel.Info,correlationId:t.EMPTY_STRING},$r={claimsBasedCachingEnabled:!1},Gr={async sendGetRequestAsync(){throw Ct(dt)},async sendPostRequestAsync(){throw Ct(dt)}},Qr={sku:t.SKU,version:wt,cpu:t.EMPTY_STRING,os:t.EMPTY_STRING},jr={clientSecret:t.EMPTY_STRING,clientAssertion:void 0},Wr={azureCloudInstance:At.None,tenant:`${t.DEFAULT_COMMON_TENANT}`},Yr={application:{appName:"",appVersion:""}};function Vr(e){return e.authOptions.authority.options.protocolMode===Pr.OIDC}
/*! @azure/msal-common v14.7.1 2024-02-17 */class Jr extends Te{constructor(e,t,r){super(e,t,r),this.name="ServerError",Object.setPrototypeOf(this,Jr.prototype)}}
/*! @azure/msal-common v14.7.1 2024-02-17 */class Xr{static generateThrottlingStorageKey(e){return`${V}.${JSON.stringify(e)}`}static preProcess(e,r){const n=Xr.generateThrottlingStorageKey(r),o=e.getThrottlingCache(n);if(o){if(o.throttleTime<Date.now())return void e.removeItem(n);throw new Jr(o.errorCodes?.join(" ")||t.EMPTY_STRING,o.errorMessage,o.subError)}}static postProcess(e,t,r){if(Xr.checkResponseStatus(r)||Xr.checkResponseForRetryAfter(r)){const n={throttleTime:Xr.calculateThrottleTime(parseInt(r.headers[l])),error:r.body.error,errorCodes:r.body.error_codes,errorMessage:r.body.error_description,subError:r.body.suberror};e.setThrottlingCache(Xr.generateThrottlingStorageKey(t),n)}}static checkResponseStatus(e){return 429===e.status||e.status>=500&&e.status<600}static checkResponseForRetryAfter(e){return!!e.headers&&(e.headers.hasOwnProperty(l)&&(e.status<200||e.status>=300))}static calculateThrottleTime(e){const t=e<=0?0:e,r=Date.now()/1e3;return Math.floor(1e3*Math.min(r+(t||W),r+Y))}static removeThrottle(e,t,r,n){const o={clientId:t,authority:r.authority,scopes:r.scopes,homeAccountIdentifier:n,claims:r.claims,authenticationScheme:r.authenticationScheme,resourceRequestMethod:r.resourceRequestMethod,resourceRequestUri:r.resourceRequestUri,shrClaims:r.shrClaims,sshKid:r.sshKid},i=this.generateThrottlingStorageKey(o);e.removeItem(i)}}
/*! @azure/msal-common v14.7.1 2024-02-17 */class Zr{constructor(e,t){this.networkClient=e,this.cacheManager=t}async sendPostRequest(e,t,r){let n;Xr.preProcess(this.cacheManager,e);try{n=await this.networkClient.sendPostRequestAsync(t,r)}catch(e){throw e instanceof Te?e:Ct(be)}return Xr.postProcess(this.cacheManager,e,n),n}}
/*! @azure/msal-common v14.7.1 2024-02-17 */const en="home_account_id",tn="UPN",rn="client_id",nn="response_type",on="token_type",sn="req_cnf",an="return_spa_code";
/*! @azure/msal-common v14.7.1 2024-02-17 */
/*! @azure/msal-common v14.7.1 2024-02-17 */
class cn{static validateRedirectUri(e){if(!e)throw Cr(Gt)}static validatePrompt(e){const t=[];for(const e in R)t.push(R[e]);if(t.indexOf(e)<0)throw Cr(Jt)}static validateClaims(e){try{JSON.parse(e)}catch(e){throw Cr(Xt)}}static validateCodeChallengeParams(e,t){if(!e||!t)throw Cr(rr);this.validateCodeChallengeMethod(t)}static validateCodeChallengeMethod(e){if([b.PLAIN,b.S256].indexOf(e)<0)throw Cr(tr)}static sanitizeEQParams(e,t){return e?(t.forEach(((t,r)=>{e[r]&&delete e[r]})),Object.fromEntries(Object.entries(e).filter((e=>""!==e[1])))):{}}}
/*! @azure/msal-common v14.7.1 2024-02-17 */class ln{constructor(){this.parameters=new Map}addResponseTypeCode(){this.parameters.set(nn,encodeURIComponent(t.CODE_RESPONSE_TYPE))}addResponseTypeForTokenAndIdToken(){this.parameters.set(nn,encodeURIComponent(`${t.TOKEN_RESPONSE_TYPE} ${t.ID_TOKEN_RESPONSE_TYPE}`))}addResponseMode(e){this.parameters.set("response_mode",encodeURIComponent(e||P.QUERY))}addNativeBroker(){this.parameters.set("nativebroker",encodeURIComponent("1"))}addScopes(e,t=!0,r=s){!t||r.includes("openid")||e.includes("openid")||r.push("openid");const n=t?[...e||[],...r]:e||[],o=new vr(n);this.parameters.set("scope",encodeURIComponent(o.printScopes()))}addClientId(e){this.parameters.set(rn,encodeURIComponent(e))}addRedirectUri(e){cn.validateRedirectUri(e),this.parameters.set("redirect_uri",encodeURIComponent(e))}addPostLogoutRedirectUri(e){cn.validateRedirectUri(e),this.parameters.set("post_logout_redirect_uri",encodeURIComponent(e))}addIdTokenHint(e){this.parameters.set("id_token_hint",encodeURIComponent(e))}addDomainHint(e){this.parameters.set("domain_hint",encodeURIComponent(e))}addLoginHint(e){this.parameters.set("login_hint",encodeURIComponent(e))}addCcsUpn(e){this.parameters.set(h,encodeURIComponent(`UPN:${e}`))}addCcsOid(e){this.parameters.set(h,encodeURIComponent(`Oid:${e.uid}@${e.utid}`))}addSid(e){this.parameters.set("sid",encodeURIComponent(e))}addClaims(e,t){const r=this.addClientCapabilitiesToClaims(e,t);cn.validateClaims(r),this.parameters.set("claims",encodeURIComponent(r))}addCorrelationId(e){this.parameters.set("client-request-id",encodeURIComponent(e))}addLibraryInfo(e){this.parameters.set("x-client-SKU",e.sku),this.parameters.set("x-client-VER",e.version),e.os&&this.parameters.set("x-client-OS",e.os),e.cpu&&this.parameters.set("x-client-CPU",e.cpu)}addApplicationTelemetry(e){e?.appName&&this.parameters.set("x-app-name",e.appName),e?.appVersion&&this.parameters.set("x-app-ver",e.appVersion)}addPrompt(e){cn.validatePrompt(e),this.parameters.set("prompt",encodeURIComponent(e))}addState(e){e&&this.parameters.set("state",encodeURIComponent(e))}addNonce(e){this.parameters.set("nonce",encodeURIComponent(e))}addCodeChallengeParams(e,t){if(cn.validateCodeChallengeParams(e,t),!e||!t)throw Cr(rr);this.parameters.set("code_challenge",encodeURIComponent(e)),this.parameters.set("code_challenge_method",encodeURIComponent(t))}addAuthorizationCode(e){this.parameters.set("code",encodeURIComponent(e))}addDeviceCode(e){this.parameters.set("device_code",encodeURIComponent(e))}addRefreshToken(e){this.parameters.set("refresh_token",encodeURIComponent(e))}addCodeVerifier(e){this.parameters.set("code_verifier",encodeURIComponent(e))}addClientSecret(e){this.parameters.set("client_secret",encodeURIComponent(e))}addClientAssertion(e){e&&this.parameters.set("client_assertion",encodeURIComponent(e))}addClientAssertionType(e){e&&this.parameters.set("client_assertion_type",encodeURIComponent(e))}addOboAssertion(e){this.parameters.set("assertion",encodeURIComponent(e))}addRequestTokenUse(e){this.parameters.set("requested_token_use",encodeURIComponent(e))}addGrantType(e){this.parameters.set("grant_type",encodeURIComponent(e))}addClientInfo(){this.parameters.set("client_info","1")}addExtraQueryParameters(e){const t=cn.sanitizeEQParams(e,this.parameters);Object.keys(t).forEach((t=>{this.parameters.set(t,e[t])}))}addClientCapabilitiesToClaims(e,t){let r;if(e)try{r=JSON.parse(e)}catch(e){throw Cr(Xt)}else r={};return t&&t.length>0&&(r.hasOwnProperty(S)||(r[S]={}),r[S][E]={values:t}),JSON.stringify(r)}addUsername(e){this.parameters.set(ee,encodeURIComponent(e))}addPassword(e){this.parameters.set(te,encodeURIComponent(e))}addPopToken(e){e&&(this.parameters.set(on,j.POP),this.parameters.set(sn,encodeURIComponent(e)))}addSshJwk(e){e&&(this.parameters.set(on,j.SSH),this.parameters.set(sn,encodeURIComponent(e)))}addServerTelemetry(e){this.parameters.set("x-client-current-telemetry",e.generateCurrentRequestHeaderValue()),this.parameters.set("x-client-last-telemetry",e.generateLastRequestHeaderValue())}addThrottling(){this.parameters.set("x-ms-lib-capability",J)}addLogoutHint(e){this.parameters.set("logout_hint",encodeURIComponent(e))}createQueryString(){const e=new Array;return this.parameters.forEach(((t,r)=>{e.push(`${r}=${t}`)})),e.join("&")}}
/*! @azure/msal-common v14.7.1 2024-02-17 */
/*! @azure/msal-common v14.7.1 2024-02-17 */
const hn={AcquireTokenByCode:"acquireTokenByCode",AcquireTokenByRefreshToken:"acquireTokenByRefreshToken",AcquireTokenSilent:"acquireTokenSilent",AcquireTokenSilentAsync:"acquireTokenSilentAsync",AcquireTokenPopup:"acquireTokenPopup",AcquireTokenRedirect:"acquireTokenRedirect",CryptoOptsGetPublicKeyThumbprint:"cryptoOptsGetPublicKeyThumbprint",CryptoOptsSignJwt:"cryptoOptsSignJwt",SilentCacheClientAcquireToken:"silentCacheClientAcquireToken",SilentIframeClientAcquireToken:"silentIframeClientAcquireToken",SilentRefreshClientAcquireToken:"silentRefreshClientAcquireToken",SsoSilent:"ssoSilent",StandardInteractionClientGetDiscoveredAuthority:"standardInteractionClientGetDiscoveredAuthority",FetchAccountIdWithNativeBroker:"fetchAccountIdWithNativeBroker",NativeInteractionClientAcquireToken:"nativeInteractionClientAcquireToken",BaseClientCreateTokenRequestHeaders:"baseClientCreateTokenRequestHeaders",RefreshTokenClientExecutePostToTokenEndpoint:"refreshTokenClientExecutePostToTokenEndpoint",AuthorizationCodeClientExecutePostToTokenEndpoint:"authorizationCodeClientExecutePostToTokenEndpoint",BrokerHandhshake:"brokerHandshake",AcquireTokenByRefreshTokenInBroker:"acquireTokenByRefreshTokenInBroker",AcquireTokenByBroker:"acquireTokenByBroker",RefreshTokenClientExecuteTokenRequest:"refreshTokenClientExecuteTokenRequest",RefreshTokenClientAcquireToken:"refreshTokenClientAcquireToken",RefreshTokenClientAcquireTokenWithCachedRefreshToken:"refreshTokenClientAcquireTokenWithCachedRefreshToken",RefreshTokenClientAcquireTokenByRefreshToken:"refreshTokenClientAcquireTokenByRefreshToken",RefreshTokenClientCreateTokenRequestBody:"refreshTokenClientCreateTokenRequestBody",AcquireTokenFromCache:"acquireTokenFromCache",SilentFlowClientAcquireCachedToken:"silentFlowClientAcquireCachedToken",SilentFlowClientGenerateResultFromCacheRecord:"silentFlowClientGenerateResultFromCacheRecord",AcquireTokenBySilentIframe:"acquireTokenBySilentIframe",InitializeBaseRequest:"initializeBaseRequest",InitializeSilentRequest:"initializeSilentRequest",InitializeClientApplication:"initializeClientApplication",SilentIframeClientTokenHelper:"silentIframeClientTokenHelper",SilentHandlerInitiateAuthRequest:"silentHandlerInitiateAuthRequest",SilentHandlerMonitorIframeForHash:"silentHandlerMonitorIframeForHash",SilentHandlerLoadFrame:"silentHandlerLoadFrame",SilentHandlerLoadFrameSync:"silentHandlerLoadFrameSync",StandardInteractionClientCreateAuthCodeClient:"standardInteractionClientCreateAuthCodeClient",StandardInteractionClientGetClientConfiguration:"standardInteractionClientGetClientConfiguration",StandardInteractionClientInitializeAuthorizationRequest:"standardInteractionClientInitializeAuthorizationRequest",StandardInteractionClientInitializeAuthorizationCodeRequest:"standardInteractionClientInitializeAuthorizationCodeRequest",GetAuthCodeUrl:"getAuthCodeUrl",HandleCodeResponseFromServer:"handleCodeResponseFromServer",HandleCodeResponse:"handleCodeResponse",UpdateTokenEndpointAuthority:"updateTokenEndpointAuthority",AuthClientAcquireToken:"authClientAcquireToken",AuthClientExecuteTokenRequest:"authClientExecuteTokenRequest",AuthClientCreateTokenRequestBody:"authClientCreateTokenRequestBody",AuthClientCreateQueryString:"authClientCreateQueryString",PopTokenGenerateCnf:"popTokenGenerateCnf",PopTokenGenerateKid:"popTokenGenerateKid",HandleServerTokenResponse:"handleServerTokenResponse",DeserializeResponse:"deserializeResponse",AuthorityFactoryCreateDiscoveredInstance:"authorityFactoryCreateDiscoveredInstance",AuthorityResolveEndpointsAsync:"authorityResolveEndpointsAsync",AuthorityResolveEndpointsFromLocalSources:"authorityResolveEndpointsFromLocalSources",AuthorityGetCloudDiscoveryMetadataFromNetwork:"authorityGetCloudDiscoveryMetadataFromNetwork",AuthorityUpdateCloudDiscoveryMetadata:"authorityUpdateCloudDiscoveryMetadata",AuthorityGetEndpointMetadataFromNetwork:"authorityGetEndpointMetadataFromNetwork",AuthorityUpdateEndpointMetadata:"authorityUpdateEndpointMetadata",AuthorityUpdateMetadataWithRegionalInformation:"authorityUpdateMetadataWithRegionalInformation",RegionDiscoveryDetectRegion:"regionDiscoveryDetectRegion",RegionDiscoveryGetRegionFromIMDS:"regionDiscoveryGetRegionFromIMDS",RegionDiscoveryGetCurrentVersion:"regionDiscoveryGetCurrentVersion",AcquireTokenByCodeAsync:"acquireTokenByCodeAsync",GetEndpointMetadataFromNetwork:"getEndpointMetadataFromNetwork",GetCloudDiscoveryMetadataFromNetworkMeasurement:"getCloudDiscoveryMetadataFromNetworkMeasurement",HandleRedirectPromiseMeasurement:"handleRedirectPromise",HandleNativeRedirectPromiseMeasurement:"handleNativeRedirectPromise",UpdateCloudDiscoveryMetadataMeasurement:"updateCloudDiscoveryMetadataMeasurement",UsernamePasswordClientAcquireToken:"usernamePasswordClientAcquireToken",NativeMessageHandlerHandshake:"nativeMessageHandlerHandshake",NativeGenerateAuthResult:"nativeGenerateAuthResult",RemoveHiddenIframe:"removeHiddenIframe",ClearTokensAndKeysWithClaims:"clearTokensAndKeysWithClaims",CacheManagerGetRefreshToken:"cacheManagerGetRefreshToken",GeneratePkceCodes:"generatePkceCodes",GenerateCodeVerifier:"generateCodeVerifier",GenerateCodeChallengeFromVerifier:"generateCodeChallengeFromVerifier",Sha256Digest:"sha256Digest",GetRandomValues:"getRandomValues"},dn=1,un=2,gn=new Set(["accessTokenSize","durationMs","idTokenSize","matsSilentStatus","matsHttpStatus","refreshTokenSize","queuedTimeMs","startTimeMs","status","multiMatchedAT","multiMatchedID","multiMatchedRT"]),pn=(e,t,r,n,o)=>(...i)=>{r.trace(`Executing function ${t}`);const s=n?.startMeasurement(t,o);if(o){const e=t+"CallCount";n?.incrementFields({[e]:1},o)}try{const n=e(...i);return s?.end({success:!0}),r.trace(`Returning result from ${t}`),n}catch(e){r.trace(`Error occurred in ${t}`);try{r.trace(JSON.stringify(e))}catch(e){r.trace("Unable to print error message.")}throw s?.end({success:!1}),e}},mn=(e,t,r,n,o)=>(...i)=>{r.trace(`Executing function ${t}`);const s=n?.startMeasurement(t,o);if(o){const e=t+"CallCount";n?.incrementFields({[e]:1},o)}return n?.setPreQueueTime(t,o),e(...i).then((e=>(r.trace(`Returning result from ${t}`),s?.end({success:!0}),e))).catch((e=>{r.trace(`Error occurred in ${t}`);try{r.trace(JSON.stringify(e))}catch(e){r.trace("Unable to print error message.")}throw s?.end({success:!1}),e}))};
/*! @azure/msal-common v14.7.1 2024-02-17 */
class fn{constructor(e,t,r,n){this.networkInterface=e,this.logger=t,this.performanceClient=r,this.correlationId=n}async detectRegion(e,r){this.performanceClient?.addQueueMeasurement(hn.RegionDiscoveryDetectRegion,this.correlationId);let n=e;if(n)r.region_source=ie;else{const e=fn.IMDS_OPTIONS;try{const o=await mn(this.getRegionFromIMDS.bind(this),hn.RegionDiscoveryGetRegionFromIMDS,this.logger,this.performanceClient,this.correlationId)(t.IMDS_VERSION,e);if(o.status===re&&(n=o.body,r.region_source=se),o.status===ne){const t=await mn(this.getCurrentVersion.bind(this),hn.RegionDiscoveryGetCurrentVersion,this.logger,this.performanceClient,this.correlationId)(e);if(!t)return r.region_source=oe,null;const o=await mn(this.getRegionFromIMDS.bind(this),hn.RegionDiscoveryGetRegionFromIMDS,this.logger,this.performanceClient,this.correlationId)(t,e);o.status===re&&(n=o.body,r.region_source=se)}}catch(e){return r.region_source=oe,null}}return n||(r.region_source=oe),n||null}async getRegionFromIMDS(e,r){return this.performanceClient?.addQueueMeasurement(hn.RegionDiscoveryGetRegionFromIMDS,this.correlationId),this.networkInterface.sendGetRequestAsync(`${t.IMDS_ENDPOINT}?api-version=${e}&format=text`,r,t.IMDS_TIMEOUT)}async getCurrentVersion(e){this.performanceClient?.addQueueMeasurement(hn.RegionDiscoveryGetCurrentVersion,this.correlationId);try{const r=await this.networkInterface.sendGetRequestAsync(`${t.IMDS_ENDPOINT}?format=json`,e);return r.status===ne&&r.body&&r.body["newest-versions"]&&r.body["newest-versions"].length>0?r.body["newest-versions"][0]:null}catch(e){return null}}}fn.IMDS_OPTIONS={headers:{Metadata:"true"}};
/*! @azure/msal-common v14.7.1 2024-02-17 */
class Cn{constructor(e,t,r,n,o,i,s){this.canonicalAuthority=e,this._canonicalAuthority.validateAsUri(),this.networkInterface=t,this.cacheManager=r,this.authorityOptions=n,this.regionDiscoveryMetadata={region_used:void 0,region_source:void 0,region_outcome:void 0},this.logger=o,this.performanceClient=s,this.correlationId=i,this.regionDiscovery=new fn(t,this.logger,this.performanceClient,this.correlationId)}getAuthorityType(e){if(e.HostNameAndPort.endsWith(t.CIAM_AUTH_URL))return br;const r=e.PathSegments;if(r.length)switch(r[0].toLowerCase()){case t.ADFS:return Er;case t.DSTS:return Rr}return Sr}get authorityType(){return this.getAuthorityType(this.canonicalAuthorityUrlComponents)}get protocolMode(){return this.authorityOptions.protocolMode}get options(){return this.authorityOptions}get canonicalAuthority(){return this._canonicalAuthority.urlString}set canonicalAuthority(e){this._canonicalAuthority=new qr(e),this._canonicalAuthority.validateAsUri(),this._canonicalAuthorityUrlComponents=null}get canonicalAuthorityUrlComponents(){return this._canonicalAuthorityUrlComponents||(this._canonicalAuthorityUrlComponents=this._canonicalAuthority.getUrlComponents()),this._canonicalAuthorityUrlComponents}get hostnameAndPort(){return this.canonicalAuthorityUrlComponents.HostNameAndPort.toLowerCase()}get tenant(){return this.canonicalAuthorityUrlComponents.PathSegments[0]}get authorizationEndpoint(){if(this.discoveryComplete())return this.replacePath(this.metadata.authorization_endpoint);throw Ct(Re)}get tokenEndpoint(){if(this.discoveryComplete())return this.replacePath(this.metadata.token_endpoint);throw Ct(Re)}get deviceCodeEndpoint(){if(this.discoveryComplete())return this.replacePath(this.metadata.token_endpoint.replace("/token","/devicecode"));throw Ct(Re)}get endSessionEndpoint(){if(this.discoveryComplete()){if(!this.metadata.end_session_endpoint)throw Ct(st);return this.replacePath(this.metadata.end_session_endpoint)}throw Ct(Re)}get selfSignedJwtAudience(){if(this.discoveryComplete())return this.replacePath(this.metadata.issuer);throw Ct(Re)}get jwksUri(){if(this.discoveryComplete())return this.replacePath(this.metadata.jwks_uri);throw Ct(Re)}canReplaceTenant(e){return 1===e.PathSegments.length&&!Cn.reservedTenantDomains.has(e.PathSegments[0])&&this.getAuthorityType(e)===Sr&&this.protocolMode===Pr.AAD}replaceTenant(e){return e.replace(/{tenant}|{tenantid}/g,this.tenant)}replacePath(e){let t=e;const r=new qr(this.metadata.canonical_authority).getUrlComponents(),n=r.PathSegments;return this.canonicalAuthorityUrlComponents.PathSegments.forEach(((e,o)=>{let i=n[o];if(0===o&&this.canReplaceTenant(r)){const e=new qr(this.metadata.authorization_endpoint).getUrlComponents().PathSegments[0];i!==e&&(this.logger.verbose(`Replacing tenant domain name ${i} with id ${e}`),i=e)}e!==i&&(t=t.replace(`/${i}/`,`/${e}/`))})),this.replaceTenant(t)}get defaultOpenIdConfigurationEndpoint(){const e=this.hostnameAndPort;return this.canonicalAuthority.endsWith("v2.0/")||this.authorityType===Er||this.protocolMode!==Pr.AAD&&!this.isAliasOfKnownMicrosoftAuthority(e)?`${this.canonicalAuthority}.well-known/openid-configuration`:`${this.canonicalAuthority}v2.0/.well-known/openid-configuration`}discoveryComplete(){return!!this.metadata}async resolveEndpointsAsync(){this.performanceClient?.addQueueMeasurement(hn.AuthorityResolveEndpointsAsync,this.correlationId);const e=this.getCurrentMetadataEntity(),t=await mn(this.updateCloudDiscoveryMetadata.bind(this),hn.AuthorityUpdateCloudDiscoveryMetadata,this.logger,this.performanceClient,this.correlationId)(e);this.canonicalAuthority=this.canonicalAuthority.replace(this.hostnameAndPort,e.preferred_network);const r=await mn(this.updateEndpointMetadata.bind(this),hn.AuthorityUpdateEndpointMetadata,this.logger,this.performanceClient,this.correlationId)(e);this.updateCachedMetadata(e,t,{source:r}),this.performanceClient?.addFields({cloudDiscoverySource:t,authorityEndpointSource:r},this.correlationId)}getCurrentMetadataEntity(){let e=this.cacheManager.getAuthorityMetadataByAlias(this.hostnameAndPort);return e||(e={aliases:[],preferred_cache:this.hostnameAndPort,preferred_network:this.hostnameAndPort,canonical_authority:this.canonicalAuthority,authorization_endpoint:"",token_endpoint:"",end_session_endpoint:"",issuer:"",aliasesFromNetwork:!1,endpointsFromNetwork:!1,expiresAt:Ft(),jwks_uri:""}),e}updateCachedMetadata(e,t,r){t!==z&&r?.source!==z&&(e.expiresAt=Ft(),e.canonical_authority=this.canonicalAuthority);const n=this.cacheManager.generateAuthorityMetadataCacheKey(e.preferred_cache);this.cacheManager.setAuthorityMetadata(n,e),this.metadata=e}async updateEndpointMetadata(e){this.performanceClient?.addQueueMeasurement(hn.AuthorityUpdateEndpointMetadata,this.correlationId);const t=this.updateEndpointMetadataFromLocalSources(e);if(t){if(t.source===G&&this.authorityOptions.azureRegionConfiguration?.azureRegion&&t.metadata){Kt(e,await mn(this.updateMetadataWithRegionalInformation.bind(this),hn.AuthorityUpdateMetadataWithRegionalInformation,this.logger,this.performanceClient,this.correlationId)(t.metadata),!1),e.canonical_authority=this.canonicalAuthority}return t.source}let r=await mn(this.getEndpointMetadataFromNetwork.bind(this),hn.AuthorityGetEndpointMetadataFromNetwork,this.logger,this.performanceClient,this.correlationId)();if(r)return this.authorityOptions.azureRegionConfiguration?.azureRegion&&(r=await mn(this.updateMetadataWithRegionalInformation.bind(this),hn.AuthorityUpdateMetadataWithRegionalInformation,this.logger,this.performanceClient,this.correlationId)(r)),Kt(e,r,!0),$;throw Ct(_e,this.defaultOpenIdConfigurationEndpoint)}updateEndpointMetadataFromLocalSources(e){this.logger.verbose("Attempting to get endpoint metadata from authority configuration");const t=this.getEndpointMetadataFromConfig();if(t)return this.logger.verbose("Found endpoint metadata in authority configuration"),Kt(e,t,!1),{source:K};if(this.logger.verbose("Did not find endpoint metadata in the config... Attempting to get endpoint metadata from the hardcoded values."),this.authorityOptions.skipAuthorityMetadataCache)this.logger.verbose("Skipping hardcoded metadata cache since skipAuthorityMetadataCache is set to true. Attempting to get endpoint metadata from the network metadata cache.");else{const t=this.getEndpointMetadataFromHardcodedValues();if(t)return Kt(e,t,!1),{source:G,metadata:t};this.logger.verbose("Did not find endpoint metadata in hardcoded values... Attempting to get endpoint metadata from the network metadata cache.")}const r=$t(e);return this.isAuthoritySameType(e)&&e.endpointsFromNetwork&&!r?(this.logger.verbose("Found endpoint metadata in the cache."),{source:z}):(r&&this.logger.verbose("The metadata entity is expired."),null)}isAuthoritySameType(e){return new qr(e.canonical_authority).getUrlComponents().PathSegments.length===this.canonicalAuthorityUrlComponents.PathSegments.length}getEndpointMetadataFromConfig(){if(this.authorityOptions.authorityMetadata)try{return JSON.parse(this.authorityOptions.authorityMetadata)}catch(e){throw Cr(or)}return null}async getEndpointMetadataFromNetwork(){this.performanceClient?.addQueueMeasurement(hn.AuthorityGetEndpointMetadataFromNetwork,this.correlationId);const e={},t=this.defaultOpenIdConfigurationEndpoint;this.logger.verbose(`Authority.getEndpointMetadataFromNetwork: attempting to retrieve OAuth endpoints from ${t}`);try{const r=await this.networkInterface.sendGetRequestAsync(t,e),n=function(e){return e.hasOwnProperty("authorization_endpoint")&&e.hasOwnProperty("token_endpoint")&&e.hasOwnProperty("issuer")&&e.hasOwnProperty("jwks_uri")}
/*! @azure/msal-common v14.7.1 2024-02-17 */(r.body);return n?r.body:(this.logger.verbose("Authority.getEndpointMetadataFromNetwork: could not parse response as OpenID configuration"),null)}catch(e){return this.logger.verbose(`Authority.getEndpointMetadataFromNetwork: ${e}`),null}}getEndpointMetadataFromHardcodedValues(){return this.hostnameAndPort in Lr?Lr[this.hostnameAndPort]:null}async updateMetadataWithRegionalInformation(e){this.performanceClient?.addQueueMeasurement(hn.AuthorityUpdateMetadataWithRegionalInformation,this.correlationId);const r=this.authorityOptions.azureRegionConfiguration?.azureRegion;if(r){if(r!==t.AZURE_REGION_AUTO_DISCOVER_FLAG)return this.regionDiscoveryMetadata.region_outcome=ae,this.regionDiscoveryMetadata.region_used=r,Cn.replaceWithRegionalInformation(e,r);const n=await mn(this.regionDiscovery.detectRegion.bind(this.regionDiscovery),hn.RegionDiscoveryDetectRegion,this.logger,this.performanceClient,this.correlationId)(this.authorityOptions.azureRegionConfiguration?.environmentRegion,this.regionDiscoveryMetadata);if(n)return this.regionDiscoveryMetadata.region_outcome=ce,this.regionDiscoveryMetadata.region_used=n,Cn.replaceWithRegionalInformation(e,n);this.regionDiscoveryMetadata.region_outcome=le}return e}async updateCloudDiscoveryMetadata(e){this.performanceClient?.addQueueMeasurement(hn.AuthorityUpdateCloudDiscoveryMetadata,this.correlationId);const t=this.updateCloudDiscoveryMetadataFromLocalSources(e);if(t)return t;const r=await mn(this.getCloudDiscoveryMetadataFromNetwork.bind(this),hn.AuthorityGetCloudDiscoveryMetadataFromNetwork,this.logger,this.performanceClient,this.correlationId)();if(r)return zt(e,r,!0),$;throw Cr(ir)}updateCloudDiscoveryMetadataFromLocalSources(e){this.logger.verbose("Attempting to get cloud discovery metadata  from authority configuration"),this.logger.verbosePii(`Known Authorities: ${this.authorityOptions.knownAuthorities||t.NOT_APPLICABLE}`),this.logger.verbosePii(`Authority Metadata: ${this.authorityOptions.authorityMetadata||t.NOT_APPLICABLE}`),this.logger.verbosePii(`Canonical Authority: ${e.canonical_authority||t.NOT_APPLICABLE}`);const r=this.getCloudDiscoveryMetadataFromConfig();if(r)return this.logger.verbose("Found cloud discovery metadata in authority configuration"),zt(e,r,!1),K;if(this.logger.verbose("Did not find cloud discovery metadata in the config... Attempting to get cloud discovery metadata from the hardcoded values."),this.options.skipAuthorityMetadataCache)this.logger.verbose("Skipping hardcoded cloud discovery metadata cache since skipAuthorityMetadataCache is set to true. Attempting to get cloud discovery metadata from the network metadata cache.");else{const t=(n=this.hostnameAndPort,Dr(Ur.metadata,n));if(t)return this.logger.verbose("Found cloud discovery metadata from hardcoded values."),zt(e,t,!1),G;this.logger.verbose("Did not find cloud discovery metadata in hardcoded values... Attempting to get cloud discovery metadata from the network metadata cache.")}var n;const o=$t(e);return this.isAuthoritySameType(e)&&e.aliasesFromNetwork&&!o?(this.logger.verbose("Found cloud discovery metadata in the cache."),z):(o&&this.logger.verbose("The metadata entity is expired."),null)}getCloudDiscoveryMetadataFromConfig(){if(this.authorityType===br)return this.logger.verbose("CIAM authorities do not support cloud discovery metadata, generate the aliases from authority host."),Cn.createCloudDiscoveryMetadataFromHost(this.hostnameAndPort);if(this.authorityOptions.cloudDiscoveryMetadata){this.logger.verbose("The cloud discovery metadata has been provided as a network response, in the config.");try{this.logger.verbose("Attempting to parse the cloud discovery metadata.");const e=Dr(JSON.parse(this.authorityOptions.cloudDiscoveryMetadata).metadata,this.hostnameAndPort);if(this.logger.verbose("Parsed the cloud discovery metadata."),e)return this.logger.verbose("There is returnable metadata attached to the parsed cloud discovery metadata."),e;this.logger.verbose("There is no metadata attached to the parsed cloud discovery metadata.")}catch(e){throw this.logger.verbose("Unable to parse the cloud discovery metadata. Throwing Invalid Cloud Discovery Metadata Error."),Cr(nr)}}return this.isInKnownAuthorities()?(this.logger.verbose("The host is included in knownAuthorities. Creating new cloud discovery metadata from the host."),Cn.createCloudDiscoveryMetadataFromHost(this.hostnameAndPort)):null}async getCloudDiscoveryMetadataFromNetwork(){this.performanceClient?.addQueueMeasurement(hn.AuthorityGetCloudDiscoveryMetadataFromNetwork,this.correlationId);const e=`${t.AAD_INSTANCE_DISCOVERY_ENDPT}${this.canonicalAuthority}oauth2/v2.0/authorize`,r={};let n=null;try{const o=await this.networkInterface.sendGetRequestAsync(e,r);let i,s;if(function(e){return e.hasOwnProperty("tenant_discovery_endpoint")&&e.hasOwnProperty("metadata")}
/*! @azure/msal-common v14.7.1 2024-02-17 */(o.body))i=o.body,s=i.metadata,this.logger.verbosePii(`tenant_discovery_endpoint is: ${i.tenant_discovery_endpoint}`);else{if(!function(e){return e.hasOwnProperty("error")&&e.hasOwnProperty("error_description")}(o.body))return this.logger.error("AAD did not return a CloudInstanceDiscoveryResponse or CloudInstanceDiscoveryErrorResponse"),null;if(this.logger.warning(`A CloudInstanceDiscoveryErrorResponse was returned. The cloud instance discovery network request's status code is: ${o.status}`),i=o.body,i.error===t.INVALID_INSTANCE)return this.logger.error("The CloudInstanceDiscoveryErrorResponse error is invalid_instance."),null;this.logger.warning(`The CloudInstanceDiscoveryErrorResponse error is ${i.error}`),this.logger.warning(`The CloudInstanceDiscoveryErrorResponse error description is ${i.error_description}`),this.logger.warning("Setting the value of the CloudInstanceDiscoveryMetadata (returned from the network) to []"),s=[]}this.logger.verbose("Attempting to find a match between the developer's authority and the CloudInstanceDiscoveryMetadata returned from the network request."),n=Dr(s,this.hostnameAndPort)}catch(e){if(e instanceof Te)this.logger.error(`There was a network error while attempting to get the cloud discovery instance metadata.\nError: ${e.errorCode}\nError Description: ${e.errorMessage}`);else{const t=e;this.logger.error(`A non-MSALJS error was thrown while attempting to get the cloud instance discovery metadata.\nError: ${t.name}\nError Description: ${t.message}`)}return null}return n||(this.logger.warning("The developer's authority was not found within the CloudInstanceDiscoveryMetadata returned from the network request."),this.logger.verbose("Creating custom Authority for custom domain scenario."),n=Cn.createCloudDiscoveryMetadataFromHost(this.hostnameAndPort)),n}isInKnownAuthorities(){return this.authorityOptions.knownAuthorities.filter((e=>e&&qr.getDomainFromUrl(e).toLowerCase()===this.hostnameAndPort)).length>0}static generateAuthority(e,r){let n;if(r&&r.azureCloudInstance!==At.None){const e=r.tenant?r.tenant:t.DEFAULT_COMMON_TENANT;n=`${r.azureCloudInstance}/${e}/`}return n||e}static createCloudDiscoveryMetadataFromHost(e){return{preferred_network:e,preferred_cache:e,aliases:[e]}}getPreferredCache(){if(this.discoveryComplete())return this.metadata.preferred_cache;throw Ct(Re)}isAlias(e){return this.metadata.aliases.indexOf(e)>-1}isAliasOfKnownMicrosoftAuthority(e){return Hr.has(e)}static isPublicCloudAuthority(e){return t.KNOWN_PUBLIC_CLOUDS.indexOf(e)>=0}static buildRegionalAuthorityString(e,r,n){const o=new qr(e);o.validateAsUri();const i=o.getUrlComponents();let s=`${r}.${i.HostNameAndPort}`;this.isPublicCloudAuthority(i.HostNameAndPort)&&(s=`${r}.${t.REGIONAL_AUTH_PUBLIC_CLOUD_SUFFIX}`);const a=qr.constructAuthorityUriFromObject({...o.getUrlComponents(),HostNameAndPort:s}).urlString;return n?`${a}?${n}`:a}static replaceWithRegionalInformation(e,t){const r={...e};return r.authorization_endpoint=Cn.buildRegionalAuthorityString(r.authorization_endpoint,t),r.token_endpoint=Cn.buildRegionalAuthorityString(r.token_endpoint,t),r.end_session_endpoint&&(r.end_session_endpoint=Cn.buildRegionalAuthorityString(r.end_session_endpoint,t)),r}static transformCIAMAuthority(e){let r=e;const n=new qr(e).getUrlComponents();if(0===n.PathSegments.length&&n.HostNameAndPort.endsWith(t.CIAM_AUTH_URL)){r=`${r}${n.HostNameAndPort.split(".")[0]}${t.AAD_TENANT_DOMAIN_SUFFIX}`}return r}}function yn(e){return e.endsWith(t.FORWARD_SLASH)?e:`${e}${t.FORWARD_SLASH}`}
/*! @azure/msal-common v14.7.1 2024-02-17 */
async function vn(e,t,r,n,o,i,s){s?.addQueueMeasurement(hn.AuthorityFactoryCreateDiscoveredInstance,i);const a=Cn.transformCIAMAuthority(yn(e)),c=new Cn(a,t,r,n,o,i,s);try{return await mn(c.resolveEndpointsAsync.bind(c),hn.AuthorityResolveEndpointsAsync,o,s,i)(),c}catch(e){throw Ct(Re)}}
/*! @azure/msal-common v14.7.1 2024-02-17 */Cn.reservedTenantDomains=new Set(["{tenant}","{tenantid}",w,k,A]);class In{constructor(e,t){this.config=function({authOptions:e,systemOptions:t,loggerOptions:r,cacheOptions:n,storageInterface:o,networkInterface:i,cryptoInterface:s,clientCredentials:a,libraryInfo:c,telemetry:l,serverTelemetryManager:h,persistencePlugin:d,serializableCache:u}){const g={...zr,...r};return{authOptions:(p=e,{clientCapabilities:[],azureCloudOptions:Wr,skipAuthorityMetadataCache:!1,...p}),systemOptions:{...Kr,...t},loggerOptions:g,cacheOptions:{...$r,...n},storageInterface:o||new Fr(e.clientId,yt,new It(g)),networkInterface:i||Gr,cryptoInterface:s||yt,clientCredentials:a||jr,libraryInfo:{...Qr,...c},telemetry:{...Yr,...l},serverTelemetryManager:h||null,persistencePlugin:d||null,serializableCache:u||null};var p}(e),this.logger=new It(this.config.loggerOptions,Tt,wt),this.cryptoUtils=this.config.cryptoInterface,this.cacheManager=this.config.storageInterface,this.networkClient=this.config.networkInterface,this.networkManager=new Zr(this.networkClient,this.cacheManager),this.serverTelemetryManager=this.config.serverTelemetryManager,this.authority=this.config.authOptions.authority,this.performanceClient=t}createTokenRequestHeaders(e){const r={};if(r[c]=t.URL_FORM_CONTENT_TYPE,!this.config.systemOptions.preventCorsPreflight&&e)switch(e.type){case en:try{const t=Tr(e.credential);r[h]=`Oid:${t.uid}@${t.utid}`}catch(e){this.logger.verbose("Could not parse home account ID for CCS Header: "+e)}break;case tn:r[h]=`UPN: ${e.credential}`}return r}async executePostToTokenEndpoint(e,t,r,n,o,i){i&&this.performanceClient?.addQueueMeasurement(i,o);const s=await this.networkManager.sendPostRequest(n,e,{body:t,headers:r});return this.performanceClient?.addFields({refreshTokenSize:s.body.refresh_token?.length||0,httpVerToken:s.headers?.[p]||""},o),this.config.serverTelemetryManager&&s.status<500&&429!==s.status&&this.config.serverTelemetryManager.clearTelemetryCache(),s}async updateAuthority(e,t){this.performanceClient?.addQueueMeasurement(hn.UpdateTokenEndpointAuthority,t);const r=`https://${e}/${this.authority.tenant}/`,n=await vn(r,this.networkClient,this.cacheManager,this.authority.options,this.logger,t,this.performanceClient);this.authority=n}createTokenQueryParameters(e){const t=new ln;return e.tokenQueryParameters&&t.addExtraQueryParameters(e.tokenQueryParameters),t.createQueryString()}}
/*! @azure/msal-common v14.7.1 2024-02-17 */const Tn="no_tokens_found",wn="native_account_unavailable",An="refresh_token_expired",kn="interaction_required",Sn="consent_required",En="login_required",Rn="bad_token";var bn=Object.freeze({__proto__:null,badToken:Rn,consentRequired:Sn,interactionRequired:kn,loginRequired:En,nativeAccountUnavailable:wn,noTokensFound:Tn,refreshTokenExpired:An});
/*! @azure/msal-common v14.7.1 2024-02-17 */const _n=[kn,Sn,En,Rn],Pn=["message_only","additional_action","basic_action","user_password_expired","consent_required","bad_token"],Mn={[Tn]:"No refresh token found in the cache. Please sign-in.",[wn]:"The requested account is not available in the native broker. It may have been deleted or logged out. Please sign-in again using an interactive API.",[An]:"Refresh token has expired.",[Rn]:"Identity provider returned bad_token due to an expired or invalid refresh token. Please invoke an interactive API to resolve."},Nn={noTokensFoundError:{code:Tn,desc:Mn[Tn]},native_account_unavailable:{code:wn,desc:Mn[wn]},bad_token:{code:Rn,desc:Mn[Rn]}};class On extends Te{constructor(e,r,n,o,i,s,a){super(e,r,n),Object.setPrototypeOf(this,On.prototype),this.timestamp=o||t.EMPTY_STRING,this.traceId=i||t.EMPTY_STRING,this.correlationId=s||t.EMPTY_STRING,this.claims=a||t.EMPTY_STRING,this.name="InteractionRequiredAuthError"}}function qn(e,t,r){const n=!!e&&_n.indexOf(e)>-1,o=!!r&&Pn.indexOf(r)>-1,i=!!t&&_n.some((e=>t.indexOf(e)>-1));return n||i||o}function Ln(e){return new On(e,Mn[e])}
/*! @azure/msal-common v14.7.1 2024-02-17 */class Un{constructor(e,t,r,n,o){this.account=e||null,this.idToken=t||null,this.accessToken=r||null,this.refreshToken=n||null,this.appMetadata=o||null}}
/*! @azure/msal-common v14.7.1 2024-02-17 */class Hn{static setRequestState(e,r,n){const o=Hn.generateLibraryState(e,n);return r?`${o}${t.RESOURCE_DELIM}${r}`:o}static generateLibraryState(e,t){if(!e)throw Ct(Je);const r={id:e.createNewGuid()};t&&(r.meta=t);const n=JSON.stringify(r);return e.base64Encode(n)}static parseRequestState(e,r){if(!e)throw Ct(Je);if(!r)throw Ct(Me);try{const n=r.split(t.RESOURCE_DELIM),o=n[0],i=n.length>1?n.slice(1).join(t.RESOURCE_DELIM):t.EMPTY_STRING,s=e.base64Decode(o),a=JSON.parse(s);return{userRequestState:i||t.EMPTY_STRING,libraryState:a}}catch(e){throw Ct(Me)}}}
/*! @azure/msal-common v14.7.1 2024-02-17 */const Bn="sw";class Dn{constructor(e,t){this.cryptoUtils=e,this.performanceClient=t}async generateCnf(e,t){this.performanceClient?.addQueueMeasurement(hn.PopTokenGenerateCnf,e.correlationId);const r=await mn(this.generateKid.bind(this),hn.PopTokenGenerateCnf,t,this.performanceClient,e.correlationId)(e),n=this.cryptoUtils.base64Encode(JSON.stringify(r));return{kid:r.kid,reqCnfString:n,reqCnfHash:await this.cryptoUtils.hashString(n)}}async generateKid(e){this.performanceClient?.addQueueMeasurement(hn.PopTokenGenerateKid,e.correlationId);return{kid:await this.cryptoUtils.getPublicKeyThumbprint(e),xms_ksl:Bn}}async signPopToken(e,t,r){return this.signPayload(e,t,r)}async signPayload(e,t,r,n){const{resourceRequestMethod:o,resourceRequestUri:i,shrClaims:s,shrNonce:a,shrOptions:c}=r,l=i?new qr(i):void 0,h=l?.getUrlComponents();return this.cryptoUtils.signJwt({at:e,ts:Et(),m:o?.toUpperCase(),u:h?.HostNameAndPort,nonce:a||this.cryptoUtils.createNewGuid(),p:h?.AbsolutePath,q:h?.QueryString?[[],h.QueryString]:void 0,client_claims:s||void 0,...n},t,c,r.correlationId)}}
/*! @azure/msal-common v14.7.1 2024-02-17 */class xn{constructor(e,t){this.cache=e,this.hasChanged=t}get cacheHasChanged(){return this.hasChanged}get tokenCache(){return this.cache}}
/*! @azure/msal-common v14.7.1 2024-02-17 */class Fn{constructor(e,t,r,n,o,i,s){this.clientId=e,this.cacheStorage=t,this.cryptoObj=r,this.logger=n,this.serializableCache=o,this.persistencePlugin=i,this.performanceClient=s}validateServerAuthorizationCodeResponse(e,t){if(!e.state||!t)throw e.state?Ct(Oe,"Cached State"):Ct(Oe,"Server State");let r,n;try{r=decodeURIComponent(e.state)}catch(t){throw Ct(Me,e.state)}try{n=decodeURIComponent(t)}catch(t){throw Ct(Me,e.state)}if(r!==n)throw Ct(Ne);if(e.error||e.error_description||e.suberror){if(qn(e.error,e.error_description,e.suberror))throw new On(e.error||"",e.error_description,e.suberror,e.timestamp||"",e.trace_id||"",e.correlation_id||"",e.claims||"");throw new Jr(e.error||"",e.error_description,e.suberror)}}validateTokenResponse(e,s){if(e.error||e.error_description||e.suberror){const a=`${e.error_codes} - [${e.timestamp}]: ${e.error_description} - Correlation ID: ${e.correlation_id} - Trace ID: ${e.trace_id}`,c=new Jr(e.error,a,e.suberror);if(s&&e.status&&e.status>=o&&e.status<=i)return void this.logger.warning(`executeTokenRequest:validateTokenResponse - AAD is currently unavailable and the access token is unable to be refreshed.\n${c}`);if(s&&e.status&&e.status>=r&&e.status<=n)return void this.logger.warning(`executeTokenRequest:validateTokenResponse - AAD is currently available but is unable to refresh the access token.\n${c}`);if(qn(e.error,e.error_description,e.suberror))throw new On(e.error,e.error_description,e.suberror,e.timestamp||t.EMPTY_STRING,e.trace_id||t.EMPTY_STRING,e.correlation_id||t.EMPTY_STRING,e.claims||t.EMPTY_STRING);throw c}}async handleServerTokenResponse(e,r,n,o,i,s,a,c,l){let h,d;if(this.performanceClient?.addQueueMeasurement(hn.HandleServerTokenResponse,e.correlation_id),e.id_token){if(h=kt(e.id_token||t.EMPTY_STRING,this.cryptoObj.base64Decode),i&&i.nonce&&h.nonce!==i.nonce)throw Ct(qe);if(o.maxAge||0===o.maxAge){const e=h.auth_time;if(!e)throw Ct(Le);St(e,o.maxAge)}}this.homeAccountIdentifier=Mr.generateHomeAccountId(e.client_info||t.EMPTY_STRING,r.authorityType,this.logger,this.cryptoObj,h),i&&i.state&&(d=Hn.parseRequestState(this.cryptoObj,i.state)),e.key_id=e.key_id||o.sshKid||void 0;const u=this.generateCacheRecord(e,r,n,o,h,s,i);let g;try{if(this.persistencePlugin&&this.serializableCache&&(this.logger.verbose("Persistence enabled, calling beforeCacheAccess"),g=new xn(this.serializableCache,!0),await this.persistencePlugin.beforeCacheAccess(g)),a&&!c&&u.account){const e=u.account.generateAccountKey();if(!this.cacheStorage.getAccount(e,this.logger))return this.logger.warning("Account used to refresh tokens not in persistence, refreshed tokens will not be stored in the cache"),await Fn.generateAuthenticationResult(this.cryptoObj,r,u,!1,o,h,d,void 0,l)}await this.cacheStorage.saveCacheRecord(u,o.storeInCache)}finally{this.persistencePlugin&&this.serializableCache&&g&&(this.logger.verbose("Persistence enabled, calling afterCacheAccess"),await this.persistencePlugin.afterCacheAccess(g))}return Fn.generateAuthenticationResult(this.cryptoObj,r,u,!1,o,h,d,e,l)}generateCacheRecord(e,t,r,n,o,i,s){const a=t.getPreferredCache();if(!a)throw Ct(Ye);const c=_r(o);let l,h;e.id_token&&o&&(l=_t(this.homeAccountIdentifier,a,e.id_token,this.clientId,c||""),h=Kn(this.cacheStorage,t,this.homeAccountIdentifier,o,this.cryptoObj.base64Decode,e.client_info,a,c,s,void 0,this.logger));let d=null;if(e.access_token){const o=e.scope?vr.fromString(e.scope):new vr(n.scopes||[]),s=("string"==typeof e.expires_in?parseInt(e.expires_in,10):e.expires_in)||0,l=("string"==typeof e.ext_expires_in?parseInt(e.ext_expires_in,10):e.ext_expires_in)||0,h=("string"==typeof e.refresh_in?parseInt(e.refresh_in,10):e.refresh_in)||void 0,u=r+s,g=u+l,p=h&&h>0?r+h:void 0;d=Pt(this.homeAccountIdentifier,a,e.access_token,this.clientId,c||t.tenant||"",o.printScopes(),u,g,this.cryptoObj.base64Decode,p,e.token_type,i,e.key_id,n.claims,n.requestedClaimsHash)}let u=null;if(e.refresh_token){let t;if(e.refresh_token_expires_in){t=r+("string"==typeof e.refresh_token_expires_in?parseInt(e.refresh_token_expires_in,10):e.refresh_token_expires_in)}u=Mt(this.homeAccountIdentifier,a,e.refresh_token,this.clientId,e.foci,i,t)}let g=null;return e.foci&&(g={clientId:this.clientId,environment:a,familyId:e.foci}),new Un(h,l,d,u,g)}static async generateAuthenticationResult(e,r,n,o,i,s,a,c,l){let h,d,u=t.EMPTY_STRING,g=[],p=null,m=t.EMPTY_STRING;if(n.accessToken){if(n.accessToken.tokenType===j.POP){const t=new Dn(e),{secret:r,keyId:o}=n.accessToken;if(!o)throw Ct(at);u=await t.signPopToken(r,o,i)}else u=n.accessToken.secret;g=vr.fromString(n.accessToken.target).asArray(),p=new Date(1e3*Number(n.accessToken.expiresOn)),h=new Date(1e3*Number(n.accessToken.extendedExpiresOn)),n.accessToken.refreshOn&&(d=new Date(1e3*Number(n.accessToken.refreshOn)))}n.appMetadata&&(m=n.appMetadata.familyId===D?D:"");const f=s?.oid||s?.sub||"",C=s?.tid||"";c?.spa_accountid&&n.account&&(n.account.nativeAccountId=c?.spa_accountid);const y=n.account?kr(n.account.getAccountInfo(),void 0,s,n.idToken?.secret):null;return{authority:r.canonicalAuthority,uniqueId:f,tenantId:C,scopes:g,account:y,idToken:n?.idToken?.secret||"",idTokenClaims:s||{},accessToken:u,fromCache:o,expiresOn:p,extExpiresOn:h,refreshOn:d,correlationId:i.correlationId,requestId:l||t.EMPTY_STRING,familyId:m,tokenType:n.accessToken?.tokenType||t.EMPTY_STRING,state:a?a.userRequestState:t.EMPTY_STRING,cloudGraphHostName:n.account?.cloudGraphHostName||t.EMPTY_STRING,msGraphHost:n.account?.msGraphHost||t.EMPTY_STRING,code:c?.spa_code,fromNativeBroker:!1}}}function Kn(e,t,r,n,o,i,s,a,c,l,h){h?.verbose("setCachedAccount called");const d=e.getAccountKeys().find((e=>e.startsWith(r)));let u=null;d&&(u=e.getAccount(d,h));const g=u||Mr.createAccount({homeAccountId:r,idTokenClaims:n,clientInfo:i,environment:s,cloudGraphHostName:c?.cloud_graph_host_name,msGraphHost:c?.msgraph_host,nativeAccountId:l},t,o),p=g.tenantProfiles||[];if(a&&!p.find((e=>e.tenantId===a))){const e=Ar(r,n);p.push(e)}return g.tenantProfiles=p,g}
/*! @azure/msal-common v14.7.1 2024-02-17 */class zn extends In{constructor(e,t){super(e,t),this.includeRedirectUri=!0,this.oidcDefaultScopes=this.config.authOptions.authority.options.OIDCOptions?.defaultScopes}async getAuthCodeUrl(e){this.performanceClient?.addQueueMeasurement(hn.GetAuthCodeUrl,e.correlationId);const t=await mn(this.createAuthCodeUrlQueryString.bind(this),hn.AuthClientCreateQueryString,this.logger,this.performanceClient,e.correlationId)(e);return qr.appendQueryString(this.authority.authorizationEndpoint,t)}async acquireToken(e,t){if(this.performanceClient?.addQueueMeasurement(hn.AuthClientAcquireToken,e.correlationId),!e.code)throw Ct(xe);const r=Et(),n=await mn(this.executeTokenRequest.bind(this),hn.AuthClientExecuteTokenRequest,this.logger,this.performanceClient,e.correlationId)(this.authority,e),o=n.headers?.[g],i=new Fn(this.config.authOptions.clientId,this.cacheManager,this.cryptoUtils,this.logger,this.config.serializableCache,this.config.persistencePlugin,this.performanceClient);return i.validateTokenResponse(n.body),mn(i.handleServerTokenResponse.bind(i),hn.HandleServerTokenResponse,this.logger,this.performanceClient,e.correlationId)(n.body,this.authority,r,e,t,void 0,void 0,void 0,o)}handleFragmentResponse(e,t){if(new Fn(this.config.authOptions.clientId,this.cacheManager,this.cryptoUtils,this.logger,null,null).validateServerAuthorizationCodeResponse(e,t),!e.code)throw Ct(ot);return e}getLogoutUri(e){if(!e)throw Cr(er);const t=this.createLogoutUrlQueryString(e);return qr.appendQueryString(this.authority.endSessionEndpoint,t)}async executeTokenRequest(e,t){this.performanceClient?.addQueueMeasurement(hn.AuthClientExecuteTokenRequest,t.correlationId);const r=this.createTokenQueryParameters(t),n=qr.appendQueryString(e.tokenEndpoint,r),o=await mn(this.createTokenRequestBody.bind(this),hn.AuthClientCreateTokenRequestBody,this.logger,this.performanceClient,t.correlationId)(t);let i;if(t.clientInfo)try{const e=Ir(t.clientInfo,this.cryptoUtils.base64Decode);i={credential:`${e.uid}${U.CLIENT_INFO_SEPARATOR}${e.utid}`,type:en}}catch(e){this.logger.verbose("Could not parse client info for CCS Header: "+e)}const s=this.createTokenRequestHeaders(i||t.ccsCredential),a={clientId:t.tokenBodyParameters?.clientId||this.config.authOptions.clientId,authority:e.canonicalAuthority,scopes:t.scopes,claims:t.claims,authenticationScheme:t.authenticationScheme,resourceRequestMethod:t.resourceRequestMethod,resourceRequestUri:t.resourceRequestUri,shrClaims:t.shrClaims,sshKid:t.sshKid};return mn(this.executePostToTokenEndpoint.bind(this),hn.AuthorizationCodeClientExecutePostToTokenEndpoint,this.logger,this.performanceClient,t.correlationId)(n,o,s,a,t.correlationId,hn.AuthorizationCodeClientExecutePostToTokenEndpoint)}async createTokenRequestBody(e){this.performanceClient?.addQueueMeasurement(hn.AuthClientCreateTokenRequestBody,e.correlationId);const t=new ln;if(t.addClientId(e.tokenBodyParameters?.[rn]||this.config.authOptions.clientId),this.includeRedirectUri?t.addRedirectUri(e.redirectUri):cn.validateRedirectUri(e.redirectUri),t.addScopes(e.scopes,!0,this.oidcDefaultScopes),t.addAuthorizationCode(e.code),t.addLibraryInfo(this.config.libraryInfo),t.addApplicationTelemetry(this.config.telemetry.application),t.addThrottling(),this.serverTelemetryManager&&!Vr(this.config)&&t.addServerTelemetry(this.serverTelemetryManager),e.codeVerifier&&t.addCodeVerifier(e.codeVerifier),this.config.clientCredentials.clientSecret&&t.addClientSecret(this.config.clientCredentials.clientSecret),this.config.clientCredentials.clientAssertion){const e=this.config.clientCredentials.clientAssertion;t.addClientAssertion(e.assertion),t.addClientAssertionType(e.assertionType)}if(t.addGrantType(M),t.addClientInfo(),e.authenticationScheme===j.POP){const r=new Dn(this.cryptoUtils,this.performanceClient),n=await mn(r.generateCnf.bind(r),hn.PopTokenGenerateCnf,this.logger,this.performanceClient,e.correlationId)(e,this.logger);t.addPopToken(n.reqCnfString)}else if(e.authenticationScheme===j.SSH){if(!e.sshJwk)throw Cr(sr);t.addSshJwk(e.sshJwk)}const r=e.correlationId||this.config.cryptoInterface.createNewGuid();let n;if(t.addCorrelationId(r),(!yr.isEmptyObj(e.claims)||this.config.authOptions.clientCapabilities&&this.config.authOptions.clientCapabilities.length>0)&&t.addClaims(e.claims,this.config.authOptions.clientCapabilities),e.clientInfo)try{const t=Ir(e.clientInfo,this.cryptoUtils.base64Decode);n={credential:`${t.uid}${U.CLIENT_INFO_SEPARATOR}${t.utid}`,type:en}}catch(e){this.logger.verbose("Could not parse client info for CCS Header: "+e)}else n=e.ccsCredential;if(this.config.systemOptions.preventCorsPreflight&&n)switch(n.type){case en:try{const e=Tr(n.credential);t.addCcsOid(e)}catch(e){this.logger.verbose("Could not parse home account ID for CCS Header: "+e)}break;case tn:t.addCcsUpn(n.credential)}return e.tokenBodyParameters&&t.addExtraQueryParameters(e.tokenBodyParameters),!e.enableSpaAuthorizationCode||e.tokenBodyParameters&&e.tokenBodyParameters[an]||t.addExtraQueryParameters({[an]:"1"}),t.createQueryString()}async createAuthCodeUrlQueryString(e){this.performanceClient?.addQueueMeasurement(hn.AuthClientCreateQueryString,e.correlationId);const t=new ln;t.addClientId(e.extraQueryParameters?.[rn]||this.config.authOptions.clientId);const r=[...e.scopes||[],...e.extraScopesToConsent||[]];t.addScopes(r,!0,this.oidcDefaultScopes),t.addRedirectUri(e.redirectUri);const n=e.correlationId||this.config.cryptoInterface.createNewGuid();if(t.addCorrelationId(n),t.addResponseMode(e.responseMode),t.addResponseTypeCode(),t.addLibraryInfo(this.config.libraryInfo),Vr(this.config)||t.addApplicationTelemetry(this.config.telemetry.application),t.addClientInfo(),e.codeChallenge&&e.codeChallengeMethod&&t.addCodeChallengeParams(e.codeChallenge,e.codeChallengeMethod),e.prompt&&t.addPrompt(e.prompt),e.domainHint&&t.addDomainHint(e.domainHint),e.prompt!==R.SELECT_ACCOUNT)if(e.sid&&e.prompt===R.NONE)this.logger.verbose("createAuthCodeUrlQueryString: Prompt is none, adding sid from request"),t.addSid(e.sid);else if(e.account){const r=this.extractAccountSid(e.account),n=this.extractLoginHint(e.account);if(n){this.logger.verbose("createAuthCodeUrlQueryString: login_hint claim present on account"),t.addLoginHint(n);try{const r=Tr(e.account.homeAccountId);t.addCcsOid(r)}catch(e){this.logger.verbose("createAuthCodeUrlQueryString: Could not parse home account ID for CCS Header")}}else if(r&&e.prompt===R.NONE){this.logger.verbose("createAuthCodeUrlQueryString: Prompt is none, adding sid from account"),t.addSid(r);try{const r=Tr(e.account.homeAccountId);t.addCcsOid(r)}catch(e){this.logger.verbose("createAuthCodeUrlQueryString: Could not parse home account ID for CCS Header")}}else if(e.loginHint)this.logger.verbose("createAuthCodeUrlQueryString: Adding login_hint from request"),t.addLoginHint(e.loginHint),t.addCcsUpn(e.loginHint);else if(e.account.username){this.logger.verbose("createAuthCodeUrlQueryString: Adding login_hint from account"),t.addLoginHint(e.account.username);try{const r=Tr(e.account.homeAccountId);t.addCcsOid(r)}catch(e){this.logger.verbose("createAuthCodeUrlQueryString: Could not parse home account ID for CCS Header")}}}else e.loginHint&&(this.logger.verbose("createAuthCodeUrlQueryString: No account, adding login_hint from request"),t.addLoginHint(e.loginHint),t.addCcsUpn(e.loginHint));else this.logger.verbose("createAuthCodeUrlQueryString: Prompt is select_account, ignoring account hints");if(e.nonce&&t.addNonce(e.nonce),e.state&&t.addState(e.state),(e.claims||this.config.authOptions.clientCapabilities&&this.config.authOptions.clientCapabilities.length>0)&&t.addClaims(e.claims,this.config.authOptions.clientCapabilities),e.extraQueryParameters&&t.addExtraQueryParameters(e.extraQueryParameters),e.nativeBroker&&(t.addNativeBroker(),e.authenticationScheme===j.POP)){const r=new Dn(this.cryptoUtils),n=await mn(r.generateCnf.bind(r),hn.PopTokenGenerateCnf,this.logger,this.performanceClient,e.correlationId)(e,this.logger);t.addPopToken(n.reqCnfHash)}return t.createQueryString()}createLogoutUrlQueryString(e){const t=new ln;return e.postLogoutRedirectUri&&t.addPostLogoutRedirectUri(e.postLogoutRedirectUri),e.correlationId&&t.addCorrelationId(e.correlationId),e.idTokenHint&&t.addIdTokenHint(e.idTokenHint),e.state&&t.addState(e.state),e.logoutHint&&t.addLogoutHint(e.logoutHint),e.extraQueryParameters&&t.addExtraQueryParameters(e.extraQueryParameters),t.createQueryString()}extractAccountSid(e){return e.idTokenClaims?.sid||null}extractLoginHint(e){return e.idTokenClaims?.login_hint||null}}
/*! @azure/msal-common v14.7.1 2024-02-17 */class $n extends In{constructor(e,t){super(e,t)}async acquireToken(e){this.performanceClient?.addQueueMeasurement(hn.RefreshTokenClientAcquireToken,e.correlationId);const t=Et(),r=await mn(this.executeTokenRequest.bind(this),hn.RefreshTokenClientExecuteTokenRequest,this.logger,this.performanceClient,e.correlationId)(e,this.authority),n=r.headers?.[g],o=new Fn(this.config.authOptions.clientId,this.cacheManager,this.cryptoUtils,this.logger,this.config.serializableCache,this.config.persistencePlugin);return o.validateTokenResponse(r.body),mn(o.handleServerTokenResponse.bind(o),hn.HandleServerTokenResponse,this.logger,this.performanceClient,e.correlationId)(r.body,this.authority,t,e,void 0,void 0,!0,e.forceCache,n)}async acquireTokenByRefreshToken(e){if(!e)throw Cr(Zt);if(this.performanceClient?.addQueueMeasurement(hn.RefreshTokenClientAcquireTokenByRefreshToken,e.correlationId),!e.account)throw Ct(je);if(this.cacheManager.isAppMetadataFOCI(e.account.environment))try{return await mn(this.acquireTokenWithCachedRefreshToken.bind(this),hn.RefreshTokenClientAcquireTokenWithCachedRefreshToken,this.logger,this.performanceClient,e.correlationId)(e,!0)}catch(t){const r=t instanceof On&&t.errorCode===Tn,n=t instanceof Jr&&t.errorCode===X&&t.subError===Z;if(r||n)return mn(this.acquireTokenWithCachedRefreshToken.bind(this),hn.RefreshTokenClientAcquireTokenWithCachedRefreshToken,this.logger,this.performanceClient,e.correlationId)(e,!1);throw t}return mn(this.acquireTokenWithCachedRefreshToken.bind(this),hn.RefreshTokenClientAcquireTokenWithCachedRefreshToken,this.logger,this.performanceClient,e.correlationId)(e,!1)}async acquireTokenWithCachedRefreshToken(e,t){this.performanceClient?.addQueueMeasurement(hn.RefreshTokenClientAcquireTokenWithCachedRefreshToken,e.correlationId);const r=pn(this.cacheManager.getRefreshToken.bind(this.cacheManager),hn.CacheManagerGetRefreshToken,this.logger,this.performanceClient,e.correlationId)(e.account,t,void 0,this.performanceClient,e.correlationId);if(!r)throw Ln(Tn);if(r.expiresOn&&Rt(r.expiresOn,e.refreshTokenExpirationOffsetSeconds||300))throw Ln(An);const n={...e,refreshToken:r.secret,authenticationScheme:e.authenticationScheme||j.BEARER,ccsCredential:{credential:e.account.homeAccountId,type:en}};try{return await mn(this.acquireToken.bind(this),hn.RefreshTokenClientAcquireToken,this.logger,this.performanceClient,e.correlationId)(n)}catch(e){if(e instanceof On&&e.subError===Rn){this.logger.verbose("acquireTokenWithRefreshToken: bad refresh token, removing from cache");const e=bt(r);this.cacheManager.removeRefreshToken(e)}throw e}}async executeTokenRequest(e,t){this.performanceClient?.addQueueMeasurement(hn.RefreshTokenClientExecuteTokenRequest,e.correlationId);const r=this.createTokenQueryParameters(e),n=qr.appendQueryString(t.tokenEndpoint,r),o=await mn(this.createTokenRequestBody.bind(this),hn.RefreshTokenClientCreateTokenRequestBody,this.logger,this.performanceClient,e.correlationId)(e),i=this.createTokenRequestHeaders(e.ccsCredential),s={clientId:e.tokenBodyParameters?.clientId||this.config.authOptions.clientId,authority:t.canonicalAuthority,scopes:e.scopes,claims:e.claims,authenticationScheme:e.authenticationScheme,resourceRequestMethod:e.resourceRequestMethod,resourceRequestUri:e.resourceRequestUri,shrClaims:e.shrClaims,sshKid:e.sshKid};return mn(this.executePostToTokenEndpoint.bind(this),hn.RefreshTokenClientExecutePostToTokenEndpoint,this.logger,this.performanceClient,e.correlationId)(n,o,i,s,e.correlationId,hn.RefreshTokenClientExecutePostToTokenEndpoint)}async createTokenRequestBody(e){this.performanceClient?.addQueueMeasurement(hn.RefreshTokenClientCreateTokenRequestBody,e.correlationId);const t=e.correlationId,r=new ln;if(r.addClientId(e.tokenBodyParameters?.[rn]||this.config.authOptions.clientId),e.redirectUri&&r.addRedirectUri(e.redirectUri),r.addScopes(e.scopes,!0,this.config.authOptions.authority.options.OIDCOptions?.defaultScopes),r.addGrantType(N),r.addClientInfo(),r.addLibraryInfo(this.config.libraryInfo),r.addApplicationTelemetry(this.config.telemetry.application),r.addThrottling(),this.serverTelemetryManager&&!Vr(this.config)&&r.addServerTelemetry(this.serverTelemetryManager),r.addCorrelationId(t),r.addRefreshToken(e.refreshToken),this.config.clientCredentials.clientSecret&&r.addClientSecret(this.config.clientCredentials.clientSecret),this.config.clientCredentials.clientAssertion){const e=this.config.clientCredentials.clientAssertion;r.addClientAssertion(e.assertion),r.addClientAssertionType(e.assertionType)}if(e.authenticationScheme===j.POP){const t=new Dn(this.cryptoUtils,this.performanceClient),n=await mn(t.generateCnf.bind(t),hn.PopTokenGenerateCnf,this.logger,this.performanceClient,e.correlationId)(e,this.logger);r.addPopToken(n.reqCnfString)}else if(e.authenticationScheme===j.SSH){if(!e.sshJwk)throw Cr(sr);r.addSshJwk(e.sshJwk)}if((!yr.isEmptyObj(e.claims)||this.config.authOptions.clientCapabilities&&this.config.authOptions.clientCapabilities.length>0)&&r.addClaims(e.claims,this.config.authOptions.clientCapabilities),this.config.systemOptions.preventCorsPreflight&&e.ccsCredential)switch(e.ccsCredential.type){case en:try{const t=Tr(e.ccsCredential.credential);r.addCcsOid(t)}catch(e){this.logger.verbose("Could not parse home account ID for CCS Header: "+e)}break;case tn:r.addCcsUpn(e.ccsCredential.credential)}return e.tokenBodyParameters&&r.addExtraQueryParameters(e.tokenBodyParameters),r.createQueryString()}}
/*! @azure/msal-common v14.7.1 2024-02-17 */class Gn extends In{constructor(e,t){super(e,t)}async acquireToken(e){try{const[t,r]=await this.acquireCachedToken(e);if(r===pe){this.logger.info("SilentFlowClient:acquireCachedToken - Cached access token's refreshOn property has been exceeded'. It's not expired, but must be refreshed.");new $n(this.config,this.performanceClient).acquireTokenByRefreshToken(e).catch((()=>{}))}return t}catch(t){if(t instanceof ft&&t.errorCode===tt){return new $n(this.config,this.performanceClient).acquireTokenByRefreshToken(e)}throw t}}async acquireCachedToken(e){this.performanceClient?.addQueueMeasurement(hn.SilentFlowClientAcquireCachedToken,e.correlationId);let t=he;if(e.forceRefresh||!this.config.cacheOptions.claimsBasedCachingEnabled&&!yr.isEmptyObj(e.claims))throw this.setCacheOutcome(de,e.correlationId),Ct(tt);if(!e.account)throw Ct(je);const r=e.account.tenantId||function(e){const t=new qr(e).getUrlComponents(),r=t.PathSegments.slice(-1)[0]?.toLowerCase();switch(r){case w:case A:case k:return;default:return r}}(e.authority),n=this.cacheManager.getTokenKeys(),o=this.cacheManager.getAccessToken(e.account,e,n,r,this.performanceClient,e.correlationId);if(!o)throw this.setCacheOutcome(ue,e.correlationId),Ct(tt);if(i=o.cachedAt,Number(i)>Et()||Rt(o.expiresOn,this.config.systemOptions.tokenRenewalOffsetSeconds))throw this.setCacheOutcome(ge,e.correlationId),Ct(tt);var i;o.refreshOn&&Rt(o.refreshOn,0)&&(t=pe);const s=e.authority||this.authority.getPreferredCache(),a={account:this.cacheManager.readAccountFromCache(e.account),accessToken:o,idToken:this.cacheManager.getIdToken(e.account,n,r,this.performanceClient,e.correlationId),refreshToken:null,appMetadata:this.cacheManager.readAppMetadataFromCache(s)};return this.setCacheOutcome(t,e.correlationId),this.config.serverTelemetryManager&&this.config.serverTelemetryManager.incrementCacheHits(),[await mn(this.generateResultFromCacheRecord.bind(this),hn.SilentFlowClientGenerateResultFromCacheRecord,this.logger,this.performanceClient,e.correlationId)(a,e),t]}setCacheOutcome(e,t){this.serverTelemetryManager?.setCacheOutcome(e),this.performanceClient?.addFields({cacheOutcome:e},t),e!==he&&this.logger.info(`Token refresh is required due to cache outcome: ${e}`)}async generateResultFromCacheRecord(e,t){let r;if(this.performanceClient?.addQueueMeasurement(hn.SilentFlowClientGenerateResultFromCacheRecord,t.correlationId),e.idToken&&(r=kt(e.idToken.secret,this.config.cryptoInterface.base64Decode)),t.maxAge||0===t.maxAge){const e=r?.auth_time;if(!e)throw Ct(Le);St(e,t.maxAge)}return Fn.generateAuthenticationResult(this.cryptoUtils,this.authority,e,!0,t,r)}}
/*! @azure/msal-common v14.7.1 2024-02-17 */const Qn={sendGetRequestAsync:()=>Promise.reject(Ct(dt)),sendPostRequestAsync:()=>Promise.reject(Ct(dt))},jn="missing_kid_error",Wn="missing_alg_error",Yn={[jn]:"The JOSE Header for the requested JWT, JWS or JWK object requires a keyId to be configured as the 'kid' header claim. No 'kid' value was provided.",[Wn]:"The JOSE Header for the requested JWT, JWS or JWK object requires an algorithm to be specified as the 'alg' header claim. No 'alg' value was provided."};
/*! @azure/msal-common v14.7.1 2024-02-17 */class Vn extends Te{constructor(e,t){super(e,t),this.name="JoseHeaderError",Object.setPrototypeOf(this,Vn.prototype)}}function Jn(e){return new Vn(e,Yn[e])}
/*! @azure/msal-common v14.7.1 2024-02-17 */class Xn{constructor(e){this.typ=e.typ,this.alg=e.alg,this.kid=e.kid}static getShrHeaderString(e){if(!e.kid)throw Jn(jn);if(!e.alg)throw Jn(Wn);const t=new Xn({typ:e.typ||me.Pop,kid:e.kid,alg:e.alg});return JSON.stringify(t)}}
/*! @azure/msal-common v14.7.1 2024-02-17 */
/*! @azure/msal-common v14.7.1 2024-02-17 */
class Zn{constructor(e,r){this.cacheOutcome=he,this.cacheManager=r,this.apiId=e.apiId,this.correlationId=e.correlationId,this.wrapperSKU=e.wrapperSKU||t.EMPTY_STRING,this.wrapperVer=e.wrapperVer||t.EMPTY_STRING,this.telemetryCacheKey=Q.CACHE_KEY+U.CACHE_KEY_SEPARATOR+e.clientId}generateCurrentRequestHeaderValue(){const e=`${this.apiId}${Q.VALUE_SEPARATOR}${this.cacheOutcome}`,t=[this.wrapperSKU,this.wrapperVer].join(Q.VALUE_SEPARATOR),r=[e,this.getRegionDiscoveryFields()].join(Q.VALUE_SEPARATOR);return[Q.SCHEMA_VERSION,r,t].join(Q.CATEGORY_SEPARATOR)}generateLastRequestHeaderValue(){const e=this.getLastRequests(),t=Zn.maxErrorsToSend(e),r=e.failedRequests.slice(0,2*t).join(Q.VALUE_SEPARATOR),n=e.errors.slice(0,t).join(Q.VALUE_SEPARATOR),o=e.errors.length,i=[o,t<o?Q.OVERFLOW_TRUE:Q.OVERFLOW_FALSE].join(Q.VALUE_SEPARATOR);return[Q.SCHEMA_VERSION,e.cacheHits,r,n,i].join(Q.CATEGORY_SEPARATOR)}cacheFailedRequest(e){const t=this.getLastRequests();t.errors.length>=Q.MAX_CACHED_ERRORS&&(t.failedRequests.shift(),t.failedRequests.shift(),t.errors.shift()),t.failedRequests.push(this.apiId,this.correlationId),e instanceof Error&&e&&e.toString()?e instanceof Te?e.subError?t.errors.push(e.subError):e.errorCode?t.errors.push(e.errorCode):t.errors.push(e.toString()):t.errors.push(e.toString()):t.errors.push(Q.UNKNOWN_ERROR),this.cacheManager.setServerTelemetry(this.telemetryCacheKey,t)}incrementCacheHits(){const e=this.getLastRequests();return e.cacheHits+=1,this.cacheManager.setServerTelemetry(this.telemetryCacheKey,e),e.cacheHits}getLastRequests(){return this.cacheManager.getServerTelemetry(this.telemetryCacheKey)||{failedRequests:[],errors:[],cacheHits:0}}clearTelemetryCache(){const e=this.getLastRequests(),t=Zn.maxErrorsToSend(e);if(t===e.errors.length)this.cacheManager.removeItem(this.telemetryCacheKey);else{const r={failedRequests:e.failedRequests.slice(2*t),errors:e.errors.slice(t),cacheHits:0};this.cacheManager.setServerTelemetry(this.telemetryCacheKey,r)}}static maxErrorsToSend(e){let r,n=0,o=0;const i=e.errors.length;for(r=0;r<i;r++){const i=e.failedRequests[2*r]||t.EMPTY_STRING,s=e.failedRequests[2*r+1]||t.EMPTY_STRING,a=e.errors[r]||t.EMPTY_STRING;if(o+=i.toString().length+s.toString().length+a.length+3,!(o<Q.MAX_LAST_HEADER_BYTES))break;n+=1}return n}getRegionDiscoveryFields(){const e=[];return e.push(this.regionUsed||t.EMPTY_STRING),e.push(this.regionSource||t.EMPTY_STRING),e.push(this.regionOutcome||t.EMPTY_STRING),e.join(",")}updateRegionDiscoveryMetadata(e){this.regionUsed=e.region_used,this.regionSource=e.region_source,this.regionOutcome=e.region_outcome}setCacheOutcome(e){this.cacheOutcome=e}}
/*! @azure/msal-common v14.7.1 2024-02-17 */class eo{startMeasurement(){}endMeasurement(){}flushMeasurement(){return null}}class to{generateId(){return"callback-id"}startMeasurement(e,t){return{end:()=>null,discard:()=>{},add:()=>{},increment:()=>{},event:{eventId:this.generateId(),status:dn,authority:"",libraryName:"",libraryVersion:"",clientId:"",name:e,startTimeMs:Date.now(),correlationId:t||""},measurement:new eo}}startPerformanceMeasurement(){return new eo}calculateQueuedTime(){return 0}addQueueMeasurement(){}setPreQueueTime(){}endMeasurement(){return null}discardMeasurements(){}removePerformanceCallback(){return!0}addPerformanceCallback(){return""}emitEvents(){}addFields(){}incrementFields(){}cacheEventByCorrelationId(){}}
/*! @azure/msal-common v14.7.1 2024-02-17 */class ro{constructor(e,t,r,n,o,i,s){this.authority=t,this.libraryName=n,this.libraryVersion=o,this.applicationTelemetry=i,this.clientId=e,this.logger=r,this.callbacks=new Map,this.eventsByCorrelationId=new Map,this.queueMeasurements=new Map,this.preQueueTimeByCorrelationId=new Map,this.intFields=s||new Set;for(const e of gn)this.intFields.add(e)}startPerformanceMeasurement(e,t){return{}}getPreQueueTime(e,t){const r=this.preQueueTimeByCorrelationId.get(t);if(r){if(r.name===e)return r.time;this.logger.trace(`PerformanceClient.getPreQueueTime: no pre-queue time found for ${e}, unable to add queue measurement`)}else this.logger.trace(`PerformanceClient.getPreQueueTime: no pre-queue times found for correlationId: ${t}, unable to add queue measurement`)}calculateQueuedTime(e,t){return e<1?(this.logger.trace(`PerformanceClient: preQueueTime should be a positive integer and not ${e}`),0):t<1?(this.logger.trace(`PerformanceClient: currentTime should be a positive integer and not ${t}`),0):t<e?(this.logger.trace("PerformanceClient: currentTime is less than preQueueTime, check how time is being retrieved"),0):t-e}addQueueMeasurement(e,t,r,n){if(!t)return void this.logger.trace(`PerformanceClient.addQueueMeasurement: correlationId not provided for ${e}, cannot add queue measurement`);if(0===r)this.logger.trace(`PerformanceClient.addQueueMeasurement: queue time provided for ${e} is ${r}`);else if(!r)return void this.logger.trace(`PerformanceClient.addQueueMeasurement: no queue time provided for ${e}`);const o={eventName:e,queueTime:n?0:r,manuallyCompleted:n},i=this.queueMeasurements.get(t);if(i)i.push(o),this.queueMeasurements.set(t,i);else{this.logger.trace(`PerformanceClient.addQueueMeasurement: adding correlationId ${t} to queue measurements`);const e=[o];this.queueMeasurements.set(t,e)}this.preQueueTimeByCorrelationId.delete(t)}startMeasurement(e,t){const r=t||this.generateId();t||this.logger.info(`PerformanceClient: No correlation id provided for ${e}, generating`,r),this.logger.trace(`PerformanceClient: Performance measurement started for ${e}`,r);const n={eventId:this.generateId(),status:dn,authority:this.authority,libraryName:this.libraryName,libraryVersion:this.libraryVersion,clientId:this.clientId,name:e,startTimeMs:Date.now(),correlationId:r,appName:this.applicationTelemetry?.appName,appVersion:this.applicationTelemetry?.appVersion};return this.cacheEventByCorrelationId(n),{end:e=>this.endMeasurement({...n,...e}),discard:()=>this.discardMeasurements(n.correlationId),add:e=>this.addFields(e,n.correlationId),increment:e=>this.incrementFields(e,n.correlationId),event:n,measurement:new eo}}endMeasurement(e){const t=this.eventsByCorrelationId.get(e.correlationId);if(!t)return this.logger.trace(`PerformanceClient: Measurement not found for ${e.eventId}`,e.correlationId),null;const r=e.eventId===t.eventId;let n={totalQueueTime:0,totalQueueCount:0,manuallyCompletedCount:0};r?(n=this.getQueueInfo(e.correlationId),this.discardCache(t.correlationId)):t.incompleteSubMeasurements?.delete(e.eventId);const o=e.durationMs||this.getDurationMs(e.startTimeMs);if(this.logger.trace(`PerformanceClient: Performance measurement ended for ${e.name}: ${o} ms`,e.correlationId),!r)return t[e.name+"DurationMs"]=Math.floor(o),{...t};let i={...t,...e},s=0;return i.incompleteSubMeasurements?.forEach((t=>{this.logger.trace(`PerformanceClient: Incomplete submeasurement ${t.name} found for ${e.name}`,i.correlationId),s++})),i.incompleteSubMeasurements=void 0,i={...i,durationMs:Math.round(o),queuedTimeMs:n.totalQueueTime,queuedCount:n.totalQueueCount,queuedManuallyCompletedCount:n.manuallyCompletedCount,status:un,incompleteSubsCount:s},this.truncateIntegralFields(i),this.emitEvents([i],e.correlationId),i}addFields(e,t){this.logger.trace("PerformanceClient: Updating static fields");const r=this.eventsByCorrelationId.get(t);r?this.eventsByCorrelationId.set(t,{...r,...e}):this.logger.trace("PerformanceClient: Event not found for",t)}incrementFields(e,t){this.logger.trace("PerformanceClient: Updating counters");const r=this.eventsByCorrelationId.get(t);if(r)for(const t in e){if(r.hasOwnProperty(t)){if(isNaN(Number(r[t])))return}else r[t]=0;r[t]+=e[t]}else this.logger.trace("PerformanceClient: Event not found for",t)}cacheEventByCorrelationId(e){const t=this.eventsByCorrelationId.get(e.correlationId);t?(this.logger.trace(`PerformanceClient: Performance measurement for ${e.name} added/updated`,e.correlationId),t.incompleteSubMeasurements=t.incompleteSubMeasurements||new Map,t.incompleteSubMeasurements.set(e.eventId,{name:e.name,startTimeMs:e.startTimeMs})):(this.logger.trace(`PerformanceClient: Performance measurement for ${e.name} started`,e.correlationId),this.eventsByCorrelationId.set(e.correlationId,{...e}))}getQueueInfo(e){const t=this.queueMeasurements.get(e);t||this.logger.trace(`PerformanceClient: no queue measurements found for for correlationId: ${e}`);let r=0,n=0,o=0;return t?.forEach((e=>{r+=e.queueTime,n++,o+=e.manuallyCompleted?1:0})),{totalQueueTime:r,totalQueueCount:n,manuallyCompletedCount:o}}discardMeasurements(e){this.logger.trace("PerformanceClient: Performance measurements discarded",e),this.eventsByCorrelationId.delete(e)}discardCache(e){this.discardMeasurements(e),this.logger.trace("PerformanceClient: QueueMeasurements discarded",e),this.queueMeasurements.delete(e),this.logger.trace("PerformanceClient: Pre-queue times discarded",e),this.preQueueTimeByCorrelationId.delete(e)}addPerformanceCallback(e){const t=this.generateId();return this.callbacks.set(t,e),this.logger.verbose(`PerformanceClient: Performance callback registered with id: ${t}`),t}removePerformanceCallback(e){const t=this.callbacks.delete(e);return t?this.logger.verbose(`PerformanceClient: Performance callback ${e} removed.`):this.logger.verbose(`PerformanceClient: Performance callback ${e} not removed.`),t}emitEvents(e,t){this.logger.verbose("PerformanceClient: Emitting performance events",t),this.callbacks.forEach(((r,n)=>{this.logger.trace(`PerformanceClient: Emitting event to callback ${n}`,t),r.apply(null,[e])}))}truncateIntegralFields(e){this.intFields.forEach((t=>{t in e&&"number"==typeof e[t]&&(e[t]=Math.floor(e[t]))}))}getDurationMs(e){const t=Date.now()-e;return t<0?t:0}}const no="pkce_not_created",oo="crypto_nonexistent",io="empty_navigate_uri",so="hash_empty_error",ao="no_state_in_hash",co="hash_does_not_contain_known_properties",lo="unable_to_parse_state",ho="state_interaction_type_mismatch",uo="interaction_in_progress",go="popup_window_error",po="empty_window_error",mo="user_cancelled",fo="monitor_popup_timeout",Co="monitor_window_timeout",yo="redirect_in_iframe",vo="block_iframe_reload",Io="block_nested_popups",To="iframe_closed_prematurely",wo="silent_logout_unsupported",Ao="no_account_error",ko="silent_prompt_value_error",So="no_token_request_cache_error",Eo="unable_to_parse_token_request_cache_error",Ro="no_cached_authority_error",bo="auth_request_not_set_error",_o="invalid_cache_type",Po="non_browser_environment",Mo="database_not_open",No="no_network_connectivity",Oo="post_request_failed",qo="get_request_failed",Lo="failed_to_parse_response",Uo="unable_to_load_token",Ho="crypto_key_not_found",Bo="auth_code_required",Do="auth_code_or_nativeAccountId_required",xo="spa_code_and_nativeAccountId_present",Fo="database_unavailable",Ko="unable_to_acquire_token_from_native_platform",zo="native_handshake_timeout",$o="native_extension_not_installed",Go="native_connection_not_established",Qo="uninitialized_public_client_application",jo="native_prompt_not_supported",Wo="invalid_base64_string";var Yo=Object.freeze({__proto__:null,authCodeOrNativeAccountIdRequired:Do,authCodeRequired:Bo,authRequestNotSetError:bo,blockIframeReload:vo,blockNestedPopups:Io,cryptoKeyNotFound:Ho,cryptoNonExistent:oo,databaseNotOpen:Mo,databaseUnavailable:Fo,emptyNavigateUri:io,emptyWindowError:po,failedToParseResponse:Lo,getRequestFailed:qo,hashDoesNotContainKnownProperties:co,hashEmptyError:so,iframeClosedPrematurely:To,interactionInProgress:uo,invalidBase64String:Wo,invalidCacheType:_o,monitorPopupTimeout:fo,monitorWindowTimeout:Co,nativeConnectionNotEstablished:Go,nativeExtensionNotInstalled:$o,nativeHandshakeTimeout:zo,nativePromptNotSupported:jo,noAccountError:Ao,noCachedAuthorityError:Ro,noNetworkConnectivity:No,noStateInHash:ao,noTokenRequestCacheError:So,nonBrowserEnvironment:Po,pkceNotCreated:no,popupWindowError:go,postRequestFailed:Oo,redirectInIframe:yo,silentLogoutUnsupported:wo,silentPromptValueError:ko,spaCodeAndNativeAccountIdPresent:xo,stateInteractionTypeMismatch:ho,unableToAcquireTokenFromNativePlatform:Ko,unableToLoadToken:Uo,unableToParseState:lo,unableToParseTokenRequestCacheError:Eo,uninitializedPublicClientApplication:Qo,userCancelled:mo});const Vo="For more visit: aka.ms/msaljs/browser-errors",Jo={[no]:"The PKCE code challenge and verifier could not be generated.",[oo]:"The crypto object or function is not available.",[io]:"Navigation URI is empty. Please check stack trace for more info.",[so]:`Hash value cannot be processed because it is empty. Please verify that your redirectUri is not clearing the hash. ${Vo}`,[ao]:"Hash does not contain state. Please verify that the request originated from msal.",[co]:`Hash does not contain known properites. Please verify that your redirectUri is not changing the hash.  ${Vo}`,[lo]:"Unable to parse state. Please verify that the request originated from msal.",[ho]:"Hash contains state but the interaction type does not match the caller.",[uo]:`Interaction is currently in progress. Please ensure that this interaction has been completed before calling an interactive API.   ${Vo}`,[go]:"Error opening popup window. This can happen if you are using IE or if popups are blocked in the browser.",[po]:"window.open returned null or undefined window object.",[mo]:"User cancelled the flow.",[fo]:`Token acquisition in popup failed due to timeout.  ${Vo}`,[Co]:`Token acquisition in iframe failed due to timeout.  ${Vo}`,[yo]:"Redirects are not supported for iframed or brokered applications. Please ensure you are using MSAL.js in a top frame of the window if using the redirect APIs, or use the popup APIs.",[vo]:`Request was blocked inside an iframe because MSAL detected an authentication response.  ${Vo}`,[Io]:"Request was blocked inside a popup because MSAL detected it was running in a popup.",[To]:"The iframe being monitored was closed prematurely.",[wo]:"Silent logout not supported. Please call logoutRedirect or logoutPopup instead.",[Ao]:"No account object provided to acquireTokenSilent and no active account has been set. Please call setActiveAccount or provide an account on the request.",[ko]:"The value given for the prompt value is not valid for silent requests - must be set to 'none' or 'no_session'.",[So]:"No token request found in cache.",[Eo]:"The cached token request could not be parsed.",[Ro]:"No cached authority found.",[bo]:"Auth Request not set. Please ensure initiateAuthRequest was called from the InteractionHandler",[_o]:"Invalid cache type",[Po]:"Login and token requests are not supported in non-browser environments.",[Mo]:"Database is not open!",[No]:"No network connectivity. Check your internet connection.",[Oo]:"Network request failed: If the browser threw a CORS error, check that the redirectUri is registered in the Azure App Portal as type 'SPA'",[qo]:"Network request failed. Please check the network trace to determine root cause.",[Lo]:"Failed to parse network response. Check network trace.",[Uo]:"Error loading token to cache.",[Ho]:"Cryptographic Key or Keypair not found in browser storage.",[Bo]:"An authorization code must be provided (as the `code` property on the request) to this flow.",[Do]:"An authorization code or nativeAccountId must be provided to this flow.",[xo]:"Request cannot contain both spa code and native account id.",[Fo]:"IndexedDB, which is required for persistent cryptographic key storage, is unavailable. This may be caused by browser privacy features which block persistent storage in third-party contexts.",[Ko]:`Unable to acquire token from native platform.  ${Vo}`,[zo]:"Timed out while attempting to establish connection to browser extension",[$o]:"Native extension is not installed. If you think this is a mistake call the initialize function.",[Go]:`Connection to native platform has not been established. Please install a compatible browser extension and run initialize().  ${Vo}`,[Qo]:`You must call and await the initialize function before attempting to call any other MSAL API.  ${Vo}`,[jo]:"The provided prompt is not supported by the native platform. This request should be routed to the web based flow.",[Wo]:"Invalid base64 encoded string."},Xo={pkceNotGenerated:{code:no,desc:Jo[no]},cryptoDoesNotExist:{code:oo,desc:Jo[oo]},emptyNavigateUriError:{code:io,desc:Jo[io]},hashEmptyError:{code:so,desc:Jo[so]},hashDoesNotContainStateError:{code:ao,desc:Jo[ao]},hashDoesNotContainKnownPropertiesError:{code:co,desc:Jo[co]},unableToParseStateError:{code:lo,desc:Jo[lo]},stateInteractionTypeMismatchError:{code:ho,desc:Jo[ho]},interactionInProgress:{code:uo,desc:Jo[uo]},popupWindowError:{code:go,desc:Jo[go]},emptyWindowError:{code:po,desc:Jo[po]},userCancelledError:{code:mo,desc:Jo[mo]},monitorPopupTimeoutError:{code:fo,desc:Jo[fo]},monitorIframeTimeoutError:{code:Co,desc:Jo[Co]},redirectInIframeError:{code:yo,desc:Jo[yo]},blockTokenRequestsInHiddenIframeError:{code:vo,desc:Jo[vo]},blockAcquireTokenInPopupsError:{code:Io,desc:Jo[Io]},iframeClosedPrematurelyError:{code:To,desc:Jo[To]},silentLogoutUnsupportedError:{code:wo,desc:Jo[wo]},noAccountError:{code:Ao,desc:Jo[Ao]},silentPromptValueError:{code:ko,desc:Jo[ko]},noTokenRequestCacheError:{code:So,desc:Jo[So]},unableToParseTokenRequestCacheError:{code:Eo,desc:Jo[Eo]},noCachedAuthorityError:{code:Ro,desc:Jo[Ro]},authRequestNotSet:{code:bo,desc:Jo[bo]},invalidCacheType:{code:_o,desc:Jo[_o]},notInBrowserEnvironment:{code:Po,desc:Jo[Po]},databaseNotOpen:{code:Mo,desc:Jo[Mo]},noNetworkConnectivity:{code:No,desc:Jo[No]},postRequestFailed:{code:Oo,desc:Jo[Oo]},getRequestFailed:{code:qo,desc:Jo[qo]},failedToParseNetworkResponse:{code:Lo,desc:Jo[Lo]},unableToLoadTokenError:{code:Uo,desc:Jo[Uo]},signingKeyNotFoundInStorage:{code:Ho,desc:Jo[Ho]},authCodeRequired:{code:Bo,desc:Jo[Bo]},authCodeOrNativeAccountRequired:{code:Do,desc:Jo[Do]},spaCodeAndNativeAccountPresent:{code:xo,desc:Jo[xo]},databaseUnavailable:{code:Fo,desc:Jo[Fo]},unableToAcquireTokenFromNativePlatform:{code:Ko,desc:Jo[Ko]},nativeHandshakeTimeout:{code:zo,desc:Jo[zo]},nativeExtensionNotInstalled:{code:$o,desc:Jo[$o]},nativeConnectionNotEstablished:{code:Go,desc:Jo[Go]},uninitializedPublicClientApplication:{code:Qo,desc:Jo[Qo]},nativePromptNotSupported:{code:jo,desc:Jo[jo]},invalidBase64StringError:{code:Wo,desc:Jo[Wo]}};class Zo extends Te{constructor(e){super(e,Jo[e]),Object.setPrototypeOf(this,Zo.prototype),this.name="BrowserAuthError"}}function ei(e){return new Zo(e)}const ti={INTERACTION_IN_PROGRESS_VALUE:"interaction_in_progress",INVALID_GRANT_ERROR:"invalid_grant",POPUP_WIDTH:483,POPUP_HEIGHT:600,POPUP_NAME_PREFIX:"msal",DEFAULT_POLL_INTERVAL_MS:30,MSAL_SKU:"msal.js.browser"},ri="53ee284d-920a-4b59-9d30-a60315b26836",ni="ppnbnpeolgkicgegkbkbjmhlideopiji",oi="MATS",ii="Handshake",si="HandshakeResponse",ai="GetToken",ci="Response",li={LocalStorage:"localStorage",SessionStorage:"sessionStorage",MemoryStorage:"memoryStorage"},hi="GET",di="POST",ui="authority",gi="request.state",pi="nonce.id_token",mi="request.origin",fi="urlHash",Ci="request.params",yi="interaction.status",vi="ccs.credential",Ii="request.correlationId",Ti="request.native",wi="request.redirect.context",Ai="msal.account.keys",ki="msal.token.keys",Si="wrapper.sku",Ei="wrapper.version",Ri={acquireTokenRedirect:861,acquireTokenPopup:862,ssoSilent:863,acquireTokenSilent_authCode:864,handleRedirectPromise:865,acquireTokenByCode:866,acquireTokenSilent_silentFlow:61,logout:961,logoutPopup:962};var bi;e.InteractionType=void 0,(bi=e.InteractionType||(e.InteractionType={})).Redirect="redirect",bi.Popup="popup",bi.Silent="silent",bi.None="none";const _i={Startup:"startup",Login:"login",Logout:"logout",AcquireToken:"acquireToken",SsoSilent:"ssoSilent",HandleRedirect:"handleRedirect",None:"none"},Pi={scopes:s},Mi="msal.db",Ni=`${Mi}.keys`,Oi={Default:0,AccessToken:1,AccessTokenAndRefreshToken:2,RefreshToken:3,RefreshTokenAndNetwork:4,Skip:5},qi=[Oi.Default,Oi.Skip,Oi.RefreshTokenAndNetwork],Li="SHA-256",Ui=new Uint8Array([1,0,1]),Hi="0123456789abcdef",Bi=new Uint32Array(1),Di={name:"RSASSA-PKCS1-v1_5",hash:Li,modulusLength:2048,publicExponent:Ui};async function xi(e,t,r){t?.addQueueMeasurement(hn.Sha256Digest,r);const n=(new TextEncoder).encode(e);return window.crypto.subtle.digest(Li,n)}function Fi(e){return window.crypto.getRandomValues(e)}function Ki(){return window.crypto.getRandomValues(Bi),Bi[0]}function zi(){const e=Date.now(),t=1024*Ki()+(1023&Ki()),r=new Uint8Array(16),n=Math.trunc(t/2**30),o=t&2**30-1,i=Ki();r[0]=e/2**40,r[1]=e/2**32,r[2]=e/2**24,r[3]=e/65536,r[4]=e/256,r[5]=e,r[6]=112|n>>>8,r[7]=n,r[8]=128|o>>>24,r[9]=o>>>16,r[10]=o>>>8,r[11]=o,r[12]=i>>>24,r[13]=i>>>16,r[14]=i>>>8,r[15]=i;let s="";for(let e=0;e<r.length;e++)s+=Hi.charAt(r[e]>>>4),s+=Hi.charAt(15&r[e]),3!==e&&5!==e&&7!==e&&9!==e||(s+="-");return s}async function $i(e){return window.crypto.subtle.exportKey("jwk",e)}function Gi(e){e.location.hash="","function"==typeof e.history.replaceState&&e.history.replaceState(null,"",`${e.location.origin}${e.location.pathname}${e.location.search}`)}function Qi(e){const t=e.split("#");t.shift(),window.location.hash=t.length>0?t.join("#"):""}function ji(){return window.parent!==window}function Wi(){return"undefined"!=typeof window&&!!window.opener&&window.opener!==window&&"string"==typeof window.name&&0===window.name.indexOf(`${ti.POPUP_NAME_PREFIX}.`)}function Yi(){return window.location.href.split("?")[0].split("#")[0]}function Vi(){const e=new qr(window.location.href).getUrlComponents();return`${e.Protocol}//${e.HostNameAndPort}/`}function Ji(){if(qr.hashContainsKnownProperties(window.location.hash)&&ji())throw ei(vo)}function Xi(t,r){const n=ji();if(t===e.InteractionType.Redirect&&n&&!r)throw ei(yo)}function Zi(){if(Wi())throw ei(Io)}function es(e){if(!e)throw ei(Po)}function ts(e){if(!e)throw ei(Qo)}function rs(e){const t=document.createElement("link");t.rel="preconnect",t.href=new URL(e).origin,t.crossOrigin="anonymous",document.head.appendChild(t),window.setTimeout((()=>{try{document.head.removeChild(t)}catch{}}),1e4)}var ns=Object.freeze({__proto__:null,blockAPICallsBeforeInitialize:ts,blockAcquireTokenInPopups:Zi,blockNonBrowserEnvironment:es,blockRedirectInIframe:Xi,blockReloadInHiddenIframes:Ji,clearHash:Gi,createGuid:function(){return zi()},getCurrentUri:Yi,getHomepage:Vi,isInIframe:ji,isInPopup:Wi,preconnect:rs,replaceHash:Qi});class os{navigateInternal(e,t){return os.defaultNavigateWindow(e,t)}navigateExternal(e,t){return os.defaultNavigateWindow(e,t)}static defaultNavigateWindow(e,t){return t.noHistory?window.location.replace(e):window.location.assign(e),new Promise((e=>{setTimeout((()=>{e(!0)}),t.timeout)}))}}class is{async sendGetRequestAsync(e,t){let r;try{r=await fetch(e,{method:hi,headers:this.getFetchHeaders(t)})}catch(e){throw window.navigator.onLine?ei(qo):ei(No)}try{return{headers:this.getHeaderDict(r.headers),body:await r.json(),status:r.status}}catch(e){throw ei(Lo)}}async sendPostRequestAsync(e,r){const n=r&&r.body||t.EMPTY_STRING;let o;try{o=await fetch(e,{method:di,headers:this.getFetchHeaders(r),body:n})}catch(e){throw window.navigator.onLine?ei(Oo):ei(No)}try{return{headers:this.getHeaderDict(o.headers),body:await o.json(),status:o.status}}catch(e){throw ei(Lo)}}getFetchHeaders(e){const t=new Headers;if(!e||!e.headers)return t;const r=e.headers;return Object.keys(r).forEach((e=>{t.append(e,r[e])})),t}getHeaderDict(e){const t={};return e.forEach(((e,r)=>{t[r]=e})),t}}const ss=1e4;const as="@azure/msal-browser",cs="3.10.0";class ls{static loggerCallback(t,r){switch(t){case e.LogLevel.Error:return void console.error(r);case e.LogLevel.Info:return void console.info(r);case e.LogLevel.Verbose:return void console.debug(r);case e.LogLevel.Warning:return void console.warn(r);default:return void console.log(r)}}constructor(r){let n;this.browserEnvironment="undefined"!=typeof window,this.config=function({auth:r,cache:n,system:o,telemetry:i},s){const a={clientId:t.EMPTY_STRING,authority:`${t.DEFAULT_AUTHORITY}`,knownAuthorities:[],cloudDiscoveryMetadata:t.EMPTY_STRING,authorityMetadata:t.EMPTY_STRING,redirectUri:t.EMPTY_STRING,postLogoutRedirectUri:t.EMPTY_STRING,navigateToLoginRequestUrl:!0,clientCapabilities:[],protocolMode:Pr.AAD,OIDCOptions:{serverResponseType:_.FRAGMENT,defaultScopes:[t.OPENID_SCOPE,t.PROFILE_SCOPE,t.OFFLINE_ACCESS_SCOPE]},azureCloudOptions:{azureCloudInstance:At.None,tenant:t.EMPTY_STRING},skipAuthorityMetadataCache:!1,supportsNestedAppAuth:!1},c={cacheLocation:li.SessionStorage,temporaryCacheLocation:li.SessionStorage,storeAuthStateInCookie:!1,secureCookies:!1,cacheMigrationEnabled:!(!n||n.cacheLocation!==li.LocalStorage),claimsBasedCachingEnabled:!1},l={loggerCallback:()=>{},logLevel:e.LogLevel.Info,piiLoggingEnabled:!1},h={...{...Kr,loggerOptions:l,networkClient:s?new is:Qn,navigationClient:new os,loadFrameTimeout:0,windowHashTimeout:o?.loadFrameTimeout||6e4,iframeHashTimeout:o?.loadFrameTimeout||ss,navigateFrameWait:0,redirectNavigationTimeout:3e4,asyncPopups:!1,allowRedirectInIframe:!1,allowNativeBroker:!1,nativeBrokerHandshakeTimeout:o?.nativeBrokerHandshakeTimeout||2e3,pollIntervalMilliseconds:ti.DEFAULT_POLL_INTERVAL_MS},...o,loggerOptions:o?.loggerOptions||l},d={application:{appName:t.EMPTY_STRING,appVersion:t.EMPTY_STRING},client:new to};r?.protocolMode!==Pr.OIDC&&r?.OIDCOptions&&new It(h.loggerOptions).warning(JSON.stringify(Cr(hr)));if(r?.protocolMode&&r.protocolMode!==Pr.AAD&&h?.allowNativeBroker)throw Cr(dr);return{auth:{...a,...r,OIDCOptions:{...a.OIDCOptions,...r?.OIDCOptions}},cache:{...c,...n},system:h,telemetry:{...d,...i}}}(r,this.browserEnvironment);try{n=window[li.SessionStorage]}catch(e){}const o=n?.getItem("msal.browser.log.level"),i=n?.getItem("msal.browser.log.pii")?.toLowerCase(),s="true"===i||"false"!==i&&void 0,a={...this.config.system.loggerOptions},c=o&&Object.keys(e.LogLevel).includes(o)?e.LogLevel[o]:void 0;c&&(a.loggerCallback=ls.loggerCallback,a.logLevel=c),void 0!==s&&(a.piiLoggingEnabled=s),this.logger=new It(a,as,cs),this.available=!1}getConfig(){return this.config}getLogger(){return this.logger}isAvailable(){return this.available}isBrowserEnvironment(){return this.browserEnvironment}}const hs="USER_INTERACTION_REQUIRED",ds="USER_CANCEL",us="NO_NETWORK",gs="TRANSIENT_ERROR",ps="PERSISTENT_ERROR",ms="DISABLED",fs="ACCOUNT_UNAVAILABLE",Cs="NESTED_APP_AUTH_UNAVAILABLE";class ys{static async initializeNestedAppAuthBridge(){if(void 0===window)throw new Error("window is undefined");if(void 0===window.nestedAppAuthBridge)throw new Error("window.nestedAppAuthBridge is undefined");if(void 0===window.crypto)throw new Error("window.crypto is undefined");try{ys.crypto=window.crypto,window.nestedAppAuthBridge.addEventListener("message",(e=>{const t="string"==typeof e?e:e.data,r=JSON.parse(t),n=ys.bridgeRequests.find((e=>e.requestId===r.requestId));void 0!==n&&(ys.bridgeRequests.splice(ys.bridgeRequests.indexOf(n),1),r.success?n.resolve(r):n.reject(r.error))}));const e=await new Promise(((e,t)=>{const r={messageType:"NestedAppAuthRequest",method:"GetInitContext",requestId:ys.getRandomId()},n={requestId:r.requestId,method:r.method,resolve:e,reject:t};ys.bridgeRequests.push(n),window.nestedAppAuthBridge.postMessage(JSON.stringify(r))}));return ys.validateBridgeResultOrThrow(e.initContext)}catch(e){throw window.console.log(e),e}}static getRandomId(){return ys.crypto.randomUUID()}getTokenInteractive(e){return this.getToken("GetTokenPopup",e)}getTokenSilent(e){return this.getToken("GetToken",e)}async getToken(e,t){const r=await this.sendRequest(e,{tokenParams:t});return{token:ys.validateBridgeResultOrThrow(r.token),account:ys.validateBridgeResultOrThrow(r.account)}}async getActiveAccount(){const e=await this.sendRequest("GetActiveAccount");return ys.validateBridgeResultOrThrow(e.account)}getHostCapabilities(){return this.capabilities??null}sendRequest(e,t){const r={messageType:"NestedAppAuthRequest",method:e,requestId:ys.getRandomId(),...t};return new Promise(((e,t)=>{const n={requestId:r.requestId,method:r.method,resolve:e,reject:t};ys.bridgeRequests.push(n),window.nestedAppAuthBridge.postMessage(JSON.stringify(r))}))}static validateBridgeResultOrThrow(e){if(void 0===e){throw{status:Cs}}return e}constructor(e,t,r){this.sdkName=e,this.sdkVersion=t,this.capabilities=r}static async create(){const e=await ys.initializeNestedAppAuthBridge();return new ys(e.sdkName,e.sdkVersion,e.capabilities)}}ys.bridgeRequests=[];class vs extends ls{constructor(){super(...arguments),this.bridgeProxy=void 0,this.activeAccount=void 0}getModuleName(){return vs.MODULE_NAME}getId(){return vs.ID}getBridgeProxy(){return this.bridgeProxy}getActiveAccount(){return this.activeAccount}setActiveAccount(e){this.activeAccount=e}async initialize(){try{if("undefined"!=typeof window){const e=await ys.create();try{e.getHostCapabilities()?.queryAccount&&(this.activeAccount=await e.getActiveAccount())}catch(e){this.activeAccount=void 0}this.bridgeProxy=e,this.available=void 0!==e}else this.available=!1}catch(e){this.available=!1}finally{return this.available}}}vs.MODULE_NAME="",vs.ID="TeamsAppOperatingContext";class Is extends ls{getModuleName(){return Is.MODULE_NAME}getId(){return Is.ID}async initialize(){return this.available="undefined"!=typeof window,this.available}}async function Ts(e){const t=new Is(e),r=new vs(e),n=[t.initialize(),r.initialize()];if(await Promise.all(n),r.isAvailable()&&r.getConfig().auth.supportsNestedAppAuth){return(await Promise.resolve().then((function(){return za}))).NestedAppAuthController.createController(r)}if(t.isAvailable()){return(await Promise.resolve().then((function(){return ba}))).StandardController.createController(t)}return null}function ws(e){return encodeURIComponent(ks(e).replace(/=/g,"").replace(/\+/g,"-").replace(/\//g,"_"))}function As(e){return Ss(e).replace(/=/g,"").replace(/\+/g,"-").replace(/\//g,"_")}function ks(e){return Ss((new TextEncoder).encode(e))}function Ss(e){const t=Array.from(e,(e=>String.fromCodePoint(e))).join("");return btoa(t)}function Es(e){return(new TextDecoder).decode(function(e){let t=e.replace(/-/g,"+").replace(/_/g,"/");switch(t.length%4){case 0:break;case 2:t+="==";break;case 3:t+="=";break;default:throw ei(Wo)}const r=atob(t);return Uint8Array.from(r,(e=>e.codePointAt(0)||0))}(e))}Is.MODULE_NAME="",Is.ID="StandardOperatingContext";class Rs{constructor(){this.dbName=Mi,this.version=1,this.tableName=Ni,this.dbOpen=!1}async open(){return new Promise(((e,t)=>{const r=window.indexedDB.open(this.dbName,this.version);r.addEventListener("upgradeneeded",(e=>{e.target.result.createObjectStore(this.tableName)})),r.addEventListener("success",(t=>{const r=t;this.db=r.target.result,this.dbOpen=!0,e()})),r.addEventListener("error",(()=>t(ei(Fo))))}))}closeConnection(){const e=this.db;e&&this.dbOpen&&(e.close(),this.dbOpen=!1)}async validateDbIsOpen(){if(!this.dbOpen)return this.open()}async getItem(e){return await this.validateDbIsOpen(),new Promise(((t,r)=>{if(!this.db)return r(ei(Mo));const n=this.db.transaction([this.tableName],"readonly").objectStore(this.tableName).get(e);n.addEventListener("success",(e=>{const r=e;this.closeConnection(),t(r.target.result)})),n.addEventListener("error",(e=>{this.closeConnection(),r(e)}))}))}async setItem(e,t){return await this.validateDbIsOpen(),new Promise(((r,n)=>{if(!this.db)return n(ei(Mo));const o=this.db.transaction([this.tableName],"readwrite").objectStore(this.tableName).put(t,e);o.addEventListener("success",(()=>{this.closeConnection(),r()})),o.addEventListener("error",(e=>{this.closeConnection(),n(e)}))}))}async removeItem(e){return await this.validateDbIsOpen(),new Promise(((t,r)=>{if(!this.db)return r(ei(Mo));const n=this.db.transaction([this.tableName],"readwrite").objectStore(this.tableName).delete(e);n.addEventListener("success",(()=>{this.closeConnection(),t()})),n.addEventListener("error",(e=>{this.closeConnection(),r(e)}))}))}async getKeys(){return await this.validateDbIsOpen(),new Promise(((e,t)=>{if(!this.db)return t(ei(Mo));const r=this.db.transaction([this.tableName],"readonly").objectStore(this.tableName).getAllKeys();r.addEventListener("success",(t=>{const r=t;this.closeConnection(),e(r.target.result)})),r.addEventListener("error",(e=>{this.closeConnection(),t(e)}))}))}async containsKey(e){return await this.validateDbIsOpen(),new Promise(((t,r)=>{if(!this.db)return r(ei(Mo));const n=this.db.transaction([this.tableName],"readonly").objectStore(this.tableName).count(e);n.addEventListener("success",(e=>{const r=e;this.closeConnection(),t(1===r.target.result)})),n.addEventListener("error",(e=>{this.closeConnection(),r(e)}))}))}async deleteDatabase(){return this.db&&this.dbOpen&&this.closeConnection(),new Promise(((e,t)=>{const r=window.indexedDB.deleteDatabase(Mi);r.addEventListener("success",(()=>e(!0))),r.addEventListener("blocked",(()=>e(!0))),r.addEventListener("error",(()=>t(!1)))}))}}class bs{constructor(){this.cache=new Map}getItem(e){return this.cache.get(e)||null}setItem(e,t){this.cache.set(e,t)}removeItem(e){this.cache.delete(e)}getKeys(){const e=[];return this.cache.forEach(((t,r)=>{e.push(r)})),e}containsKey(e){return this.cache.has(e)}clear(){this.cache.clear()}}class _s{constructor(e,t){this.inMemoryCache=new bs,this.indexedDBCache=new Rs,this.logger=e,this.storeName=t}handleDatabaseAccessError(e){if(!(e instanceof Zo&&e.errorCode===Fo))throw e;this.logger.error("Could not access persistent storage. This may be caused by browser privacy features which block persistent storage in third-party contexts.")}async getItem(e){const t=this.inMemoryCache.getItem(e);if(!t)try{return this.logger.verbose("Queried item not found in in-memory cache, now querying persistent storage."),await this.indexedDBCache.getItem(e)}catch(e){this.handleDatabaseAccessError(e)}return t}async setItem(e,t){this.inMemoryCache.setItem(e,t);try{await this.indexedDBCache.setItem(e,t)}catch(e){this.handleDatabaseAccessError(e)}}async removeItem(e){this.inMemoryCache.removeItem(e);try{await this.indexedDBCache.removeItem(e)}catch(e){this.handleDatabaseAccessError(e)}}async getKeys(){const e=this.inMemoryCache.getKeys();if(0===e.length)try{return this.logger.verbose("In-memory cache is empty, now querying persistent storage."),await this.indexedDBCache.getKeys()}catch(e){this.handleDatabaseAccessError(e)}return e}async containsKey(e){const t=this.inMemoryCache.containsKey(e);if(!t)try{return this.logger.verbose("Key not found in in-memory cache, now querying persistent storage."),await this.indexedDBCache.containsKey(e)}catch(e){this.handleDatabaseAccessError(e)}return t}clearInMemory(){this.logger.verbose(`Deleting in-memory keystore ${this.storeName}`),this.inMemoryCache.clear(),this.logger.verbose(`In-memory keystore ${this.storeName} deleted`)}async clearPersistent(){try{this.logger.verbose("Deleting persistent keystore");const e=await this.indexedDBCache.deleteDatabase();return e&&this.logger.verbose("Persistent keystore deleted"),e}catch(e){return this.handleDatabaseAccessError(e),!1}}}const Ps="asymmetricKeys",Ms="symmetricKeys";class Ns{constructor(e){this.logger=e,this.asymmetricKeys=new _s(this.logger,Ps),this.symmetricKeys=new _s(this.logger,Ms)}async clear(){this.asymmetricKeys.clearInMemory(),this.symmetricKeys.clearInMemory();try{return await this.asymmetricKeys.clearPersistent(),!0}catch(e){return e instanceof Error?this.logger.error(`Clearing keystore failed with error: ${e.message}`):this.logger.error("Clearing keystore failed with unknown error"),!1}}}class Os{constructor(e,t){this.logger=e,function(e){if(!("crypto"in window))throw e.error("BrowserCrypto: crypto interface is unavailable"),ei(oo);e.verbose("BrowserCrypto: modern crypto interface available")}(e),this.cache=new Ns(this.logger),this.performanceClient=t}createNewGuid(){return zi()}base64Encode(e){return ks(e)}base64Decode(e){return Es(e)}async getPublicKeyThumbprint(e){const t=this.performanceClient?.startMeasurement(hn.CryptoOptsGetPublicKeyThumbprint,e.correlationId),r=await async function(e,t){return window.crypto.subtle.generateKey(Di,e,t)}(Os.EXTRACTABLE,Os.POP_KEY_USAGES),n=await $i(r.publicKey),o=qs({e:n.e,kty:n.kty,n:n.n}),i=await this.hashString(o),s=await $i(r.privateKey),a=await async function(e,t,r){return window.crypto.subtle.importKey("jwk",e,Di,t,r)}(s,!1,["sign"]);return await this.cache.asymmetricKeys.setItem(i,{privateKey:a,publicKey:r.publicKey,requestMethod:e.resourceRequestMethod,requestUri:e.resourceRequestUri}),t&&t.end({success:!0}),i}async removeTokenBindingKey(e){await this.cache.asymmetricKeys.removeItem(e);return!await this.cache.asymmetricKeys.containsKey(e)}async clearKeystore(){return this.cache.clear()}async signJwt(e,t,r,n){const o=this.performanceClient?.startMeasurement(hn.CryptoOptsSignJwt,n),i=await this.cache.asymmetricKeys.getItem(t);if(!i)throw ei(Ho);const s=await $i(i.publicKey),a=qs(s),c=ws(JSON.stringify({kid:t})),l=ws(Xn.getShrHeaderString({...r?.header,alg:s.alg,kid:c}));e.cnf={jwk:JSON.parse(a)};const h=`${l}.${ws(JSON.stringify(e))}`,d=(new TextEncoder).encode(h),u=await async function(e,t){return window.crypto.subtle.sign(Di,e,t)}(i.privateKey,d),g=`${h}.${As(new Uint8Array(u))}`;return o&&o.end({success:!0}),g}async hashString(e){const t=await xi(e);return As(new Uint8Array(t))}}function qs(e){return JSON.stringify(e,Object.keys(e).sort())}Os.POP_KEY_USAGES=["sign","verify"],Os.EXTRACTABLE=!0;const Ls="storage_not_supported",Us="stubbed_public_client_application_called",Hs="in_mem_redirect_unavailable";var Bs=Object.freeze({__proto__:null,inMemRedirectUnavailable:Hs,storageNotSupported:Ls,stubbedPublicClientApplicationCalled:Us});const Ds={[Ls]:"Given storage configuration option was not supported.",[Us]:"Stub instance of Public Client Application was called. If using msal-react, please ensure context is not used without a provider. For more visit: aka.ms/msaljs/browser-errors",[Hs]:"Redirect cannot be supported. In-memory storage was selected and storeAuthStateInCookie=false, which would cause the library to be unable to handle the incoming hash. If you would like to use the redirect API, please use session/localStorage or set storeAuthStateInCookie=true."},xs={storageNotSupportedError:{code:Ls,desc:Ds[Ls]},stubPcaInstanceCalled:{code:Us,desc:Ds[Us]},inMemRedirectUnavailable:{code:Hs,desc:Ds[Hs]}};class Fs extends Te{constructor(e,t){super(e,t),this.name="BrowserConfigurationAuthError",Object.setPrototypeOf(this,Fs.prototype)}}function Ks(e){return new Fs(e,Ds[e])}class zs{constructor(e){this.validateWindowStorage(e),this.windowStorage=window[e]}validateWindowStorage(e){if(e!==li.LocalStorage&&e!==li.SessionStorage||!window[e])throw Ks(Ls)}getItem(e){return this.windowStorage.getItem(e)}setItem(e,t){this.windowStorage.setItem(e,t)}removeItem(e){this.windowStorage.removeItem(e)}getKeys(){return Object.keys(this.windowStorage)}containsKey(e){return this.windowStorage.hasOwnProperty(e)}}function $s(e,t){if(!t)return null;try{return Hn.parseRequestState(e,t).libraryState.meta}catch(e){throw Ct(Me)}}class Gs extends xr{constructor(e,t,r,n,o){super(e,r,n,o),this.COOKIE_LIFE_MULTIPLIER=864e5,this.cacheConfig=t,this.logger=n,this.internalStorage=new bs,this.browserStorage=this.setupBrowserStorage(this.cacheConfig.cacheLocation),this.temporaryCacheStorage=this.setupTemporaryCacheStorage(this.cacheConfig.temporaryCacheLocation,this.cacheConfig.cacheLocation),t.cacheMigrationEnabled&&(this.migrateCacheEntries(),this.createKeyMaps())}setupBrowserStorage(e){switch(e){case li.LocalStorage:case li.SessionStorage:try{return new zs(e)}catch(e){this.logger.verbose(e);break}}return this.cacheConfig.cacheLocation=li.MemoryStorage,new bs}setupTemporaryCacheStorage(e,t){switch(t){case li.LocalStorage:case li.SessionStorage:try{return new zs(e||li.SessionStorage)}catch(e){return this.logger.verbose(e),this.internalStorage}default:return this.internalStorage}}migrateCacheEntries(){const e=`${t.CACHE_PREFIX}.${m}`,r=`${t.CACHE_PREFIX}.${f}`,n=`${t.CACHE_PREFIX}.${y}`,o=`${t.CACHE_PREFIX}.${v}`,i=[this.browserStorage.getItem(e),this.browserStorage.getItem(r),this.browserStorage.getItem(n),this.browserStorage.getItem(o)];[m,f,y,v].forEach(((e,t)=>this.migrateCacheEntry(e,i[t])))}migrateCacheEntry(e,t){t&&this.setTemporaryCache(e,t,!0)}createKeyMaps(){this.logger.trace("BrowserCacheManager - createKeyMaps called.");const e=this.getItem(Ai),t=this.getItem(`${ki}.${this.clientId}`);if(e&&t)return void this.logger.verbose("BrowserCacheManager:createKeyMaps - account and token key maps already exist, skipping migration.");this.browserStorage.getKeys().forEach((e=>{if(this.isCredentialKey(e)){const t=this.getItem(e);if(t){const r=this.validateAndParseJson(t);if(r&&r.hasOwnProperty("credentialType"))switch(r.credentialType){case H.ID_TOKEN:if(qt(r)){this.logger.trace("BrowserCacheManager:createKeyMaps - idToken found, saving key to token key map"),this.logger.tracePii(`BrowserCacheManager:createKeyMaps - idToken with key: ${e} found, saving key to token key map`);const t=r,n=this.updateCredentialCacheKey(e,t);return void this.addTokenKey(n,H.ID_TOKEN)}this.logger.trace("BrowserCacheManager:createKeyMaps - key found matching idToken schema with value containing idToken credentialType field but value failed IdTokenEntity validation, skipping."),this.logger.tracePii(`BrowserCacheManager:createKeyMaps - failed idToken validation on key: ${e}`);break;case H.ACCESS_TOKEN:case H.ACCESS_TOKEN_WITH_AUTH_SCHEME:if(Ot(r)){this.logger.trace("BrowserCacheManager:createKeyMaps - accessToken found, saving key to token key map"),this.logger.tracePii(`BrowserCacheManager:createKeyMaps - accessToken with key: ${e} found, saving key to token key map`);const t=r,n=this.updateCredentialCacheKey(e,t);return void this.addTokenKey(n,H.ACCESS_TOKEN)}this.logger.trace("BrowserCacheManager:createKeyMaps - key found matching accessToken schema with value containing accessToken credentialType field but value failed AccessTokenEntity validation, skipping."),this.logger.tracePii(`BrowserCacheManager:createKeyMaps - failed accessToken validation on key: ${e}`);break;case H.REFRESH_TOKEN:if(Lt(r)){this.logger.trace("BrowserCacheManager:createKeyMaps - refreshToken found, saving key to token key map"),this.logger.tracePii(`BrowserCacheManager:createKeyMaps - refreshToken with key: ${e} found, saving key to token key map`);const t=r,n=this.updateCredentialCacheKey(e,t);return void this.addTokenKey(n,H.REFRESH_TOKEN)}this.logger.trace("BrowserCacheManager:createKeyMaps - key found matching refreshToken schema with value containing refreshToken credentialType field but value failed RefreshTokenEntity validation, skipping."),this.logger.tracePii(`BrowserCacheManager:createKeyMaps - failed refreshToken validation on key: ${e}`)}}}if(this.isAccountKey(e)){const t=this.getItem(e);if(t){const r=this.validateAndParseJson(t);r&&Mr.isAccountEntity(r)&&(this.logger.trace("BrowserCacheManager:createKeyMaps - account found, saving key to account key map"),this.logger.tracePii(`BrowserCacheManager:createKeyMaps - account with key: ${e} found, saving key to account key map`),this.addAccountKeyToMap(e))}}}))}validateAndParseJson(e){try{const t=JSON.parse(e);return t&&"object"==typeof t?t:null}catch(e){return null}}getItem(e){return this.browserStorage.getItem(e)}setItem(e,t){this.browserStorage.setItem(e,t)}getAccount(e,t){this.logger.trace("BrowserCacheManager.getAccount called");const r=this.getCachedAccountEntity(e);return this.updateOutdatedCachedAccount(e,r,t)}getCachedAccountEntity(e){const t=this.getItem(e);if(!t)return this.removeAccountKeyFromMap(e),null;const r=this.validateAndParseJson(t);return r&&Mr.isAccountEntity(r)?xr.toObject(new Mr,r):(this.removeAccountKeyFromMap(e),null)}setAccount(e){this.logger.trace("BrowserCacheManager.setAccount called");const t=e.generateAccountKey();this.setItem(t,JSON.stringify(e)),this.addAccountKeyToMap(t)}getAccountKeys(){this.logger.trace("BrowserCacheManager.getAccountKeys called");const e=this.getItem(Ai);return e?JSON.parse(e):(this.logger.verbose("BrowserCacheManager.getAccountKeys - No account keys found"),[])}addAccountKeyToMap(e){this.logger.trace("BrowserCacheManager.addAccountKeyToMap called"),this.logger.tracePii(`BrowserCacheManager.addAccountKeyToMap called with key: ${e}`);const t=this.getAccountKeys();-1===t.indexOf(e)?(t.push(e),this.setItem(Ai,JSON.stringify(t)),this.logger.verbose("BrowserCacheManager.addAccountKeyToMap account key added")):this.logger.verbose("BrowserCacheManager.addAccountKeyToMap account key already exists in map")}removeAccountKeyFromMap(e){this.logger.trace("BrowserCacheManager.removeAccountKeyFromMap called"),this.logger.tracePii(`BrowserCacheManager.removeAccountKeyFromMap called with key: ${e}`);const t=this.getAccountKeys(),r=t.indexOf(e);r>-1?(t.splice(r,1),this.setItem(Ai,JSON.stringify(t)),this.logger.trace("BrowserCacheManager.removeAccountKeyFromMap account key removed")):this.logger.trace("BrowserCacheManager.removeAccountKeyFromMap key not found in existing map")}async removeAccount(e){super.removeAccount(e),this.removeAccountKeyFromMap(e)}removeOutdatedAccount(e){this.removeItem(e),this.removeAccountKeyFromMap(e)}removeIdToken(e){super.removeIdToken(e),this.removeTokenKey(e,H.ID_TOKEN)}async removeAccessToken(e){super.removeAccessToken(e),this.removeTokenKey(e,H.ACCESS_TOKEN)}removeRefreshToken(e){super.removeRefreshToken(e),this.removeTokenKey(e,H.REFRESH_TOKEN)}getTokenKeys(){this.logger.trace("BrowserCacheManager.getTokenKeys called");const e=this.getItem(`${ki}.${this.clientId}`);if(e){const t=this.validateAndParseJson(e);if(t&&t.hasOwnProperty("idToken")&&t.hasOwnProperty("accessToken")&&t.hasOwnProperty("refreshToken"))return t;this.logger.error("BrowserCacheManager.getTokenKeys - Token keys found but in an unknown format. Returning empty key map.")}else this.logger.verbose("BrowserCacheManager.getTokenKeys - No token keys found");return{idToken:[],accessToken:[],refreshToken:[]}}addTokenKey(e,t){this.logger.trace("BrowserCacheManager addTokenKey called");const r=this.getTokenKeys();switch(t){case H.ID_TOKEN:-1===r.idToken.indexOf(e)&&(this.logger.info("BrowserCacheManager: addTokenKey - idToken added to map"),r.idToken.push(e));break;case H.ACCESS_TOKEN:-1===r.accessToken.indexOf(e)&&(this.logger.info("BrowserCacheManager: addTokenKey - accessToken added to map"),r.accessToken.push(e));break;case H.REFRESH_TOKEN:-1===r.refreshToken.indexOf(e)&&(this.logger.info("BrowserCacheManager: addTokenKey - refreshToken added to map"),r.refreshToken.push(e));break;default:throw this.logger.error(`BrowserCacheManager:addTokenKey - CredentialType provided invalid. CredentialType: ${t}`),Ct(Xe)}this.setItem(`${ki}.${this.clientId}`,JSON.stringify(r))}removeTokenKey(e,t){this.logger.trace("BrowserCacheManager removeTokenKey called");const r=this.getTokenKeys();switch(t){case H.ID_TOKEN:this.logger.infoPii(`BrowserCacheManager: removeTokenKey - attempting to remove idToken with key: ${e} from map`);const n=r.idToken.indexOf(e);n>-1?(this.logger.info("BrowserCacheManager: removeTokenKey - idToken removed from map"),r.idToken.splice(n,1)):this.logger.info("BrowserCacheManager: removeTokenKey - idToken does not exist in map. Either it was previously removed or it was never added.");break;case H.ACCESS_TOKEN:this.logger.infoPii(`BrowserCacheManager: removeTokenKey - attempting to remove accessToken with key: ${e} from map`);const o=r.accessToken.indexOf(e);o>-1?(this.logger.info("BrowserCacheManager: removeTokenKey - accessToken removed from map"),r.accessToken.splice(o,1)):this.logger.info("BrowserCacheManager: removeTokenKey - accessToken does not exist in map. Either it was previously removed or it was never added.");break;case H.REFRESH_TOKEN:this.logger.infoPii(`BrowserCacheManager: removeTokenKey - attempting to remove refreshToken with key: ${e} from map`);const i=r.refreshToken.indexOf(e);i>-1?(this.logger.info("BrowserCacheManager: removeTokenKey - refreshToken removed from map"),r.refreshToken.splice(i,1)):this.logger.info("BrowserCacheManager: removeTokenKey - refreshToken does not exist in map. Either it was previously removed or it was never added.");break;default:throw this.logger.error(`BrowserCacheManager:removeTokenKey - CredentialType provided invalid. CredentialType: ${t}`),Ct(Xe)}this.setItem(`${ki}.${this.clientId}`,JSON.stringify(r))}getIdTokenCredential(e){const t=this.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getIdTokenCredential: called, no cache hit"),this.removeTokenKey(e,H.ID_TOKEN),null;const r=this.validateAndParseJson(t);return r&&qt(r)?(this.logger.trace("BrowserCacheManager.getIdTokenCredential: cache hit"),r):(this.logger.trace("BrowserCacheManager.getIdTokenCredential: called, no cache hit"),this.removeTokenKey(e,H.ID_TOKEN),null)}setIdTokenCredential(e){this.logger.trace("BrowserCacheManager.setIdTokenCredential called");const t=bt(e);this.setItem(t,JSON.stringify(e)),this.addTokenKey(t,H.ID_TOKEN)}getAccessTokenCredential(e){const t=this.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getAccessTokenCredential: called, no cache hit"),this.removeTokenKey(e,H.ACCESS_TOKEN),null;const r=this.validateAndParseJson(t);return r&&Ot(r)?(this.logger.trace("BrowserCacheManager.getAccessTokenCredential: cache hit"),r):(this.logger.trace("BrowserCacheManager.getAccessTokenCredential: called, no cache hit"),this.removeTokenKey(e,H.ACCESS_TOKEN),null)}setAccessTokenCredential(e){this.logger.trace("BrowserCacheManager.setAccessTokenCredential called");const t=bt(e);this.setItem(t,JSON.stringify(e)),this.addTokenKey(t,H.ACCESS_TOKEN)}getRefreshTokenCredential(e){const t=this.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getRefreshTokenCredential: called, no cache hit"),this.removeTokenKey(e,H.REFRESH_TOKEN),null;const r=this.validateAndParseJson(t);return r&&Lt(r)?(this.logger.trace("BrowserCacheManager.getRefreshTokenCredential: cache hit"),r):(this.logger.trace("BrowserCacheManager.getRefreshTokenCredential: called, no cache hit"),this.removeTokenKey(e,H.REFRESH_TOKEN),null)}setRefreshTokenCredential(e){this.logger.trace("BrowserCacheManager.setRefreshTokenCredential called");const t=bt(e);this.setItem(t,JSON.stringify(e)),this.addTokenKey(t,H.REFRESH_TOKEN)}getAppMetadata(e){const t=this.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getAppMetadata: called, no cache hit"),null;const r=this.validateAndParseJson(t);return r&&(n=e,(o=r)&&0===n.indexOf(B)&&o.hasOwnProperty("clientId")&&o.hasOwnProperty("environment"))?(this.logger.trace("BrowserCacheManager.getAppMetadata: cache hit"),r):(this.logger.trace("BrowserCacheManager.getAppMetadata: called, no cache hit"),null);var n,o}setAppMetadata(e){this.logger.trace("BrowserCacheManager.setAppMetadata called");const t=function({environment:e,clientId:t}){return[B,e,t].join(U.CACHE_KEY_SEPARATOR).toLowerCase()}(e);this.setItem(t,JSON.stringify(e))}getServerTelemetry(e){const t=this.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getServerTelemetry: called, no cache hit"),null;const r=this.validateAndParseJson(t);return r&&function(e,t){const r=0===e.indexOf(Q.CACHE_KEY);let n=!0;return t&&(n=t.hasOwnProperty("failedRequests")&&t.hasOwnProperty("errors")&&t.hasOwnProperty("cacheHits")),r&&n}(e,r)?(this.logger.trace("BrowserCacheManager.getServerTelemetry: cache hit"),r):(this.logger.trace("BrowserCacheManager.getServerTelemetry: called, no cache hit"),null)}setServerTelemetry(e,t){this.logger.trace("BrowserCacheManager.setServerTelemetry called"),this.setItem(e,JSON.stringify(t))}getAuthorityMetadata(e){const t=this.internalStorage.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getAuthorityMetadata: called, no cache hit"),null;const r=this.validateAndParseJson(t);return r&&function(e,t){return!!t&&0===e.indexOf(x)&&t.hasOwnProperty("aliases")&&t.hasOwnProperty("preferred_cache")&&t.hasOwnProperty("preferred_network")&&t.hasOwnProperty("canonical_authority")&&t.hasOwnProperty("authorization_endpoint")&&t.hasOwnProperty("token_endpoint")&&t.hasOwnProperty("issuer")&&t.hasOwnProperty("aliasesFromNetwork")&&t.hasOwnProperty("endpointsFromNetwork")&&t.hasOwnProperty("expiresAt")&&t.hasOwnProperty("jwks_uri")}(e,r)?(this.logger.trace("BrowserCacheManager.getAuthorityMetadata: cache hit"),r):null}getAuthorityMetadataKeys(){return this.internalStorage.getKeys().filter((e=>this.isAuthorityMetadata(e)))}setWrapperMetadata(e,t){this.internalStorage.setItem(Si,e),this.internalStorage.setItem(Ei,t)}getWrapperMetadata(){return[this.internalStorage.getItem(Si)||t.EMPTY_STRING,this.internalStorage.getItem(Ei)||t.EMPTY_STRING]}setAuthorityMetadata(e,t){this.logger.trace("BrowserCacheManager.setAuthorityMetadata called"),this.internalStorage.setItem(e,JSON.stringify(t))}getActiveAccount(){const e=this.generateCacheKey(T),t=this.getItem(e);if(!t){this.logger.trace("BrowserCacheManager.getActiveAccount: No active account filters cache schema found, looking for legacy schema");const e=this.generateCacheKey(I),t=this.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getActiveAccount: No active account found"),null;const r=this.getAccountInfoFilteredBy({localAccountId:t});return r?(this.logger.trace("BrowserCacheManager.getActiveAccount: Legacy active account cache schema found"),this.logger.trace("BrowserCacheManager.getActiveAccount: Adding active account filters cache schema"),this.setActiveAccount(r),r):null}const r=this.validateAndParseJson(t);return r?(this.logger.trace("BrowserCacheManager.getActiveAccount: Active account filters schema found"),this.getAccountInfoFilteredBy({homeAccountId:r.homeAccountId,localAccountId:r.localAccountId,tenantId:r.tenantId})):(this.logger.trace("BrowserCacheManager.getActiveAccount: No active account found"),null)}setActiveAccount(e){const t=this.generateCacheKey(T),r=this.generateCacheKey(I);if(e){this.logger.verbose("setActiveAccount: Active account set");const n={homeAccountId:e.homeAccountId,localAccountId:e.localAccountId,tenantId:e.tenantId};this.browserStorage.setItem(t,JSON.stringify(n)),this.browserStorage.setItem(r,e.localAccountId)}else this.logger.verbose("setActiveAccount: No account passed, active account not set"),this.browserStorage.removeItem(t),this.browserStorage.removeItem(r)}getThrottlingCache(e){const t=this.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getThrottlingCache: called, no cache hit"),null;const r=this.validateAndParseJson(t);return r&&function(e,t){let r=!1;e&&(r=0===e.indexOf(V));let n=!0;return t&&(n=t.hasOwnProperty("throttleTime")),r&&n}(e,r)?(this.logger.trace("BrowserCacheManager.getThrottlingCache: cache hit"),r):(this.logger.trace("BrowserCacheManager.getThrottlingCache: called, no cache hit"),null)}setThrottlingCache(e,t){this.logger.trace("BrowserCacheManager.setThrottlingCache called"),this.setItem(e,JSON.stringify(t))}getTemporaryCache(e,t){const r=t?this.generateCacheKey(e):e;if(this.cacheConfig.storeAuthStateInCookie){const e=this.getItemCookie(r);if(e)return this.logger.trace("BrowserCacheManager.getTemporaryCache: storeAuthStateInCookies set to true, retrieving from cookies"),e}const n=this.temporaryCacheStorage.getItem(r);if(!n){if(this.cacheConfig.cacheLocation===li.LocalStorage){const e=this.browserStorage.getItem(r);if(e)return this.logger.trace("BrowserCacheManager.getTemporaryCache: Temporary cache item found in local storage"),e}return this.logger.trace("BrowserCacheManager.getTemporaryCache: No cache item found in local storage"),null}return this.logger.trace("BrowserCacheManager.getTemporaryCache: Temporary cache item returned"),n}setTemporaryCache(e,t,r){const n=r?this.generateCacheKey(e):e;this.temporaryCacheStorage.setItem(n,t),this.cacheConfig.storeAuthStateInCookie&&(this.logger.trace("BrowserCacheManager.setTemporaryCache: storeAuthStateInCookie set to true, setting item cookie"),this.setItemCookie(n,t))}removeItem(e){this.browserStorage.removeItem(e),this.temporaryCacheStorage.removeItem(e),this.cacheConfig.storeAuthStateInCookie&&(this.logger.trace("BrowserCacheManager.removeItem: storeAuthStateInCookie is true, clearing item cookie"),this.clearItemCookie(e))}containsKey(e){return this.browserStorage.containsKey(e)||this.temporaryCacheStorage.containsKey(e)}getKeys(){return[...this.browserStorage.getKeys(),...this.temporaryCacheStorage.getKeys()]}async clear(){await this.removeAllAccounts(),this.removeAppMetadata(),this.getKeys().forEach((e=>{!this.browserStorage.containsKey(e)&&!this.temporaryCacheStorage.containsKey(e)||-1===e.indexOf(t.CACHE_PREFIX)&&-1===e.indexOf(this.clientId)||this.removeItem(e)})),this.internalStorage.clear()}async clearTokensAndKeysWithClaims(e){e.addQueueMeasurement(hn.ClearTokensAndKeysWithClaims);const t=this.getTokenKeys(),r=[];t.accessToken.forEach((e=>{const t=this.getAccessTokenCredential(e);t?.requestedClaimsHash&&e.includes(t.requestedClaimsHash.toLowerCase())&&r.push(this.removeAccessToken(e))})),await Promise.all(r),r.length>0&&this.logger.warning(`${r.length} access tokens with claims in the cache keys have been removed from the cache.`)}setItemCookie(e,t,r){let n=`${encodeURIComponent(e)}=${encodeURIComponent(t)};path=/;SameSite=Lax;`;if(r){n+=`expires=${this.getCookieExpirationTime(r)};`}this.cacheConfig.secureCookies&&(n+="Secure;"),document.cookie=n}getItemCookie(e){const r=`${encodeURIComponent(e)}=`,n=document.cookie.split(";");for(let e=0;e<n.length;e++){let t=n[e];for(;" "===t.charAt(0);)t=t.substring(1);if(0===t.indexOf(r))return decodeURIComponent(t.substring(r.length,t.length))}return t.EMPTY_STRING}clearMsalCookies(){const e=`${t.CACHE_PREFIX}.${this.clientId}`;document.cookie.split(";").forEach((t=>{for(;" "===t.charAt(0);)t=t.substring(1);if(0===t.indexOf(e)){const e=t.split("=")[0];this.clearItemCookie(e)}}))}clearItemCookie(e){this.setItemCookie(e,t.EMPTY_STRING,-1)}getCookieExpirationTime(e){const t=new Date;return new Date(t.getTime()+e*this.COOKIE_LIFE_MULTIPLIER).toUTCString()}getCache(){return this.browserStorage}setCache(){}generateCacheKey(e){return this.validateAndParseJson(e)?JSON.stringify(e):yr.startsWith(e,t.CACHE_PREFIX)||yr.startsWith(e,C)?e:`${t.CACHE_PREFIX}.${this.clientId}.${e}`}generateAuthorityKey(e){const{libraryState:{id:t}}=Hn.parseRequestState(this.cryptoImpl,e);return this.generateCacheKey(`${ui}.${t}`)}generateNonceKey(e){const{libraryState:{id:t}}=Hn.parseRequestState(this.cryptoImpl,e);return this.generateCacheKey(`${pi}.${t}`)}generateStateKey(e){const{libraryState:{id:t}}=Hn.parseRequestState(this.cryptoImpl,e);return this.generateCacheKey(`${gi}.${t}`)}getCachedAuthority(e){const t=this.generateStateKey(e),r=this.getTemporaryCache(t);if(!r)return null;const n=this.generateAuthorityKey(r);return this.getTemporaryCache(n)}updateCacheEntries(e,t,r,n,o){this.logger.trace("BrowserCacheManager.updateCacheEntries called");const i=this.generateStateKey(e);this.setTemporaryCache(i,e,!1);const s=this.generateNonceKey(e);this.setTemporaryCache(s,t,!1);const a=this.generateAuthorityKey(e);if(this.setTemporaryCache(a,r,!1),o){const e={credential:o.homeAccountId,type:en};this.setTemporaryCache(vi,JSON.stringify(e),!0)}else if(n){const e={credential:n,type:tn};this.setTemporaryCache(vi,JSON.stringify(e),!0)}}resetRequestCache(e){this.logger.trace("BrowserCacheManager.resetRequestCache called"),e&&(this.getKeys().forEach((t=>{-1!==t.indexOf(e)&&this.removeItem(t)})),this.removeItem(this.generateStateKey(e)),this.removeItem(this.generateNonceKey(e)),this.removeItem(this.generateAuthorityKey(e))),this.removeItem(this.generateCacheKey(Ci)),this.removeItem(this.generateCacheKey(mi)),this.removeItem(this.generateCacheKey(fi)),this.removeItem(this.generateCacheKey(Ii)),this.removeItem(this.generateCacheKey(vi)),this.removeItem(this.generateCacheKey(Ti)),this.setInteractionInProgress(!1)}cleanRequestByState(e){if(this.logger.trace("BrowserCacheManager.cleanRequestByState called"),e){const r=this.generateStateKey(e),n=this.temporaryCacheStorage.getItem(r);this.logger.infoPii(`BrowserCacheManager.cleanRequestByState: Removing temporary cache items for state: ${n}`),this.resetRequestCache(n||t.EMPTY_STRING)}this.clearMsalCookies()}cleanRequestByInteractionType(e){this.logger.trace("BrowserCacheManager.cleanRequestByInteractionType called"),this.getKeys().forEach((t=>{if(-1===t.indexOf(gi))return;const r=this.temporaryCacheStorage.getItem(t);if(!r)return;const n=$s(this.cryptoImpl,r);n&&n.interactionType===e&&(this.logger.infoPii(`BrowserCacheManager.cleanRequestByInteractionType: Removing temporary cache items for state: ${r}`),this.resetRequestCache(r))})),this.clearMsalCookies(),this.setInteractionInProgress(!1)}cacheCodeRequest(e){this.logger.trace("BrowserCacheManager.cacheCodeRequest called");const t=ks(JSON.stringify(e));this.setTemporaryCache(Ci,t,!0)}getCachedRequest(e){this.logger.trace("BrowserCacheManager.getCachedRequest called");const t=this.getTemporaryCache(Ci,!0);if(!t)throw ei(So);let r;try{r=JSON.parse(Es(t))}catch(e){throw this.logger.errorPii(`Attempted to parse: ${t}`),this.logger.error(`Parsing cached token request threw with error: ${e}`),ei(Eo)}if(this.removeItem(this.generateCacheKey(Ci)),!r.authority){const t=this.generateAuthorityKey(e),n=this.getTemporaryCache(t);if(!n)throw ei(Ro);r.authority=n}return r}getCachedNativeRequest(){this.logger.trace("BrowserCacheManager.getCachedNativeRequest called");const e=this.getTemporaryCache(Ti,!0);if(!e)return this.logger.trace("BrowserCacheManager.getCachedNativeRequest: No cached native request found"),null;const t=this.validateAndParseJson(e);return t||(this.logger.error("BrowserCacheManager.getCachedNativeRequest: Unable to parse native request"),null)}isInteractionInProgress(e){const t=this.getInteractionInProgress();return e?t===this.clientId:!!t}getInteractionInProgress(){const e=`${t.CACHE_PREFIX}.${yi}`;return this.getTemporaryCache(e,!1)}setInteractionInProgress(e){const r=`${t.CACHE_PREFIX}.${yi}`;if(e){if(this.getInteractionInProgress())throw ei(uo);this.setTemporaryCache(r,this.clientId,!1)}else e||this.getInteractionInProgress()!==this.clientId||this.removeItem(r)}getLegacyLoginHint(){const e=this.getTemporaryCache(C);e&&(this.browserStorage.removeItem(C),this.logger.verbose("Cached ADAL id token retrieved."));const t=this.getTemporaryCache(m,!0);t&&(this.removeItem(this.generateCacheKey(m)),this.logger.verbose("Cached MSAL.js v1 id token retrieved"));const r=t||e;if(r){const e=kt(r,Es);if(e.preferred_username)return this.logger.verbose("No SSO params used and ADAL/MSAL v1 token retrieved, setting ADAL/MSAL v1 preferred_username as loginHint"),e.preferred_username;if(e.upn)return this.logger.verbose("No SSO params used and ADAL/MSAL v1 token retrieved, setting ADAL/MSAL v1 upn as loginHint"),e.upn;this.logger.verbose("No SSO params used and ADAL/MSAL v1 token retrieved, however, no account hint claim found. Enable preferred_username or upn id token claim to get SSO.")}return null}updateCredentialCacheKey(e,t){const r=bt(t);if(e!==r){const n=this.getItem(e);if(n)return this.removeItem(e),this.setItem(r,n),this.logger.verbose(`Updated an outdated ${t.credentialType} cache key`),r;this.logger.error(`Attempted to update an outdated ${t.credentialType} cache key but no item matching the outdated key was found in storage`)}return e}getRedirectRequestContext(){return this.getTemporaryCache(wi,!0)}setRedirectRequestContext(e){this.setTemporaryCache(wi,e,!0)}async hydrateCache(e,t){const r=_t(e.account?.homeAccountId,e.account?.environment,e.idToken,this.clientId,e.tenantId);let n;t.claims&&(n=await this.cryptoImpl.hashString(t.claims));const o=Pt(e.account?.homeAccountId,e.account.environment,e.accessToken,this.clientId,e.tenantId,e.scopes.join(" "),e.expiresOn?.getTime()||0,e.extExpiresOn?.getTime()||0,Es,void 0,e.tokenType,void 0,t.sshKid,t.claims,n),i=new Un(void 0,r,o);return this.saveCacheRecord(i)}}const Qs=(e,t)=>new Gs(e,{cacheLocation:li.MemoryStorage,temporaryCacheLocation:li.MemoryStorage,storeAuthStateInCookie:!1,secureCookies:!1,cacheMigrationEnabled:!1,claimsBasedCachingEnabled:!1},yt,t),js={INITIALIZE_START:"msal:initializeStart",INITIALIZE_END:"msal:initializeEnd",ACCOUNT_ADDED:"msal:accountAdded",ACCOUNT_REMOVED:"msal:accountRemoved",ACTIVE_ACCOUNT_CHANGED:"msal:activeAccountChanged",LOGIN_START:"msal:loginStart",LOGIN_SUCCESS:"msal:loginSuccess",LOGIN_FAILURE:"msal:loginFailure",ACQUIRE_TOKEN_START:"msal:acquireTokenStart",ACQUIRE_TOKEN_SUCCESS:"msal:acquireTokenSuccess",ACQUIRE_TOKEN_FAILURE:"msal:acquireTokenFailure",ACQUIRE_TOKEN_NETWORK_START:"msal:acquireTokenFromNetworkStart",SSO_SILENT_START:"msal:ssoSilentStart",SSO_SILENT_SUCCESS:"msal:ssoSilentSuccess",SSO_SILENT_FAILURE:"msal:ssoSilentFailure",ACQUIRE_TOKEN_BY_CODE_START:"msal:acquireTokenByCodeStart",ACQUIRE_TOKEN_BY_CODE_SUCCESS:"msal:acquireTokenByCodeSuccess",ACQUIRE_TOKEN_BY_CODE_FAILURE:"msal:acquireTokenByCodeFailure",HANDLE_REDIRECT_START:"msal:handleRedirectStart",HANDLE_REDIRECT_END:"msal:handleRedirectEnd",POPUP_OPENED:"msal:popupOpened",LOGOUT_START:"msal:logoutStart",LOGOUT_SUCCESS:"msal:logoutSuccess",LOGOUT_FAILURE:"msal:logoutFailure",LOGOUT_END:"msal:logoutEnd",RESTORE_FROM_BFCACHE:"msal:restoreFromBFCache"};class Ws{constructor(e,t){this.eventCallbacks=new Map,this.logger=e,this.browserCrypto=t,this.listeningToStorageEvents=!1,this.handleAccountCacheChange=this.handleAccountCacheChange.bind(this)}addEventCallback(e){if("undefined"!=typeof window){const t=zi();return this.eventCallbacks.set(t,e),this.logger.verbose(`Event callback registered with id: ${t}`),t}return null}removeEventCallback(e){this.eventCallbacks.delete(e),this.logger.verbose(`Event callback ${e} removed.`)}enableAccountStorageEvents(){"undefined"!=typeof window&&(this.listeningToStorageEvents?this.logger.verbose("Account storage listener already registered."):(this.logger.verbose("Adding account storage listener."),this.listeningToStorageEvents=!0,window.addEventListener("storage",this.handleAccountCacheChange)))}disableAccountStorageEvents(){"undefined"!=typeof window&&(this.listeningToStorageEvents?(this.logger.verbose("Removing account storage listener."),window.removeEventListener("storage",this.handleAccountCacheChange),this.listeningToStorageEvents=!1):this.logger.verbose("No account storage listener registered."))}emitEvent(e,t,r,n){if("undefined"!=typeof window){const o={eventType:e,interactionType:t||null,payload:r||null,error:n||null,timestamp:Date.now()};this.logger.info(`Emitting event: ${e}`),this.eventCallbacks.forEach(((t,r)=>{this.logger.verbose(`Emitting event to callback ${r}: ${e}`),t.apply(null,[o])}))}}handleAccountCacheChange(e){try{e.key?.includes(T)&&this.emitEvent(js.ACTIVE_ACCOUNT_CHANGED);const t=e.newValue||e.oldValue;if(!t)return;const r=JSON.parse(t);if("object"!=typeof r||!Mr.isAccountEntity(r))return;const n=xr.toObject(new Mr,r).getAccountInfo();!e.oldValue&&e.newValue?(this.logger.info("Account was added to cache in a different window"),this.emitEvent(js.ACCOUNT_ADDED,void 0,n)):!e.newValue&&e.oldValue&&(this.logger.info("Account was removed from cache in a different window"),this.emitEvent(js.ACCOUNT_REMOVED,void 0,n))}catch(e){return}}}class Ys{constructor(e,t,r,n,o,i,s,a,c){this.config=e,this.browserStorage=t,this.browserCrypto=r,this.networkClient=this.config.system.networkClient,this.eventHandler=o,this.navigationClient=i,this.nativeMessageHandler=a,this.correlationId=c||zi(),this.logger=n.clone(ti.MSAL_SKU,cs,this.correlationId),this.performanceClient=s}async clearCacheOnLogout(e){if(e){Mr.accountInfoIsEqual(e,this.browserStorage.getActiveAccount(),!1)&&(this.logger.verbose("Setting active account to null"),this.browserStorage.setActiveAccount(null));try{await this.browserStorage.removeAccount(Mr.generateAccountCacheKey(e)),this.logger.verbose("Cleared cache items belonging to the account provided in the logout request.")}catch(e){this.logger.error("Account provided in logout request was not found. Local cache unchanged.")}}else try{this.logger.verbose("No account provided in logout request, clearing all cache items.",this.correlationId),await this.browserStorage.clear(),await this.browserCrypto.clearKeystore()}catch(e){this.logger.error("Attempted to clear all MSAL cache items and failed. Local cache unchanged.")}}async initializeBaseRequest(e){this.performanceClient.addQueueMeasurement(hn.InitializeBaseRequest,this.correlationId);const t=e.authority||this.config.auth.authority,r=[...e&&e.scopes||[]],n={...e,correlationId:this.correlationId,authority:t,scopes:r};if(n.authenticationScheme){if(n.authenticationScheme===j.SSH){if(!e.sshJwk)throw Cr(sr);if(!e.sshKid)throw Cr(ar)}this.logger.verbose(`Authentication Scheme set to "${n.authenticationScheme}" as configured in Auth request`)}else n.authenticationScheme=j.BEARER,this.logger.verbose('Authentication Scheme wasn\'t explicitly set in request, defaulting to "Bearer" request');return this.config.cache.claimsBasedCachingEnabled&&e.claims&&!yr.isEmptyObj(e.claims)&&(n.requestedClaimsHash=await this.browserCrypto.hashString(e.claims)),n}getRedirectUri(e){this.logger.verbose("getRedirectUri called");const t=e||this.config.auth.redirectUri||Yi();return qr.getAbsoluteUrl(t,Yi())}initializeServerTelemetryManager(e,t){this.logger.verbose("initializeServerTelemetryManager called");const r={clientId:this.config.auth.clientId,correlationId:this.correlationId,apiId:e,forceRefresh:t||!1,wrapperSKU:this.browserStorage.getWrapperMetadata()[0],wrapperVer:this.browserStorage.getWrapperMetadata()[1]};return new Zn(r,this.browserStorage)}async getDiscoveredAuthority(e,t,r){this.performanceClient.addQueueMeasurement(hn.StandardInteractionClientGetDiscoveredAuthority,this.correlationId);const n={protocolMode:this.config.auth.protocolMode,OIDCOptions:this.config.auth.OIDCOptions,knownAuthorities:this.config.auth.knownAuthorities,cloudDiscoveryMetadata:this.config.auth.cloudDiscoveryMetadata,authorityMetadata:this.config.auth.authorityMetadata,skipAuthorityMetadataCache:this.config.auth.skipAuthorityMetadataCache},o=e||this.config.auth.authority,i=Cn.generateAuthority(o,t||this.config.auth.azureCloudOptions),s=await mn(vn,hn.AuthorityFactoryCreateDiscoveredInstance,this.logger,this.performanceClient,this.correlationId)(i,this.config.system.networkClient,this.browserStorage,n,this.logger,this.correlationId,this.performanceClient);if(r&&!s.isAlias(r.environment))throw Cr(ur);return s}}const Vs=32;async function Js(e,t,r){e.addQueueMeasurement(hn.GeneratePkceCodes,r);const n=pn(Xs,hn.GenerateCodeVerifier,t,e,r)(e,t,r);return{verifier:n,challenge:await mn(Zs,hn.GenerateCodeChallengeFromVerifier,t,e,r)(n,e,t,r)}}function Xs(e,t,r){try{const n=new Uint8Array(Vs);pn(Fi,hn.GetRandomValues,t,e,r)(n);return As(n)}catch(e){throw ei(no)}}async function Zs(e,t,r,n){t.addQueueMeasurement(hn.GenerateCodeChallengeFromVerifier,n);try{const o=await mn(xi,hn.Sha256Digest,r,t,n)(e,t,n);return As(new Uint8Array(o))}catch(e){throw ei(no)}}class ea extends Ys{async initializeAuthorizationCodeRequest(e){this.performanceClient.addQueueMeasurement(hn.StandardInteractionClientInitializeAuthorizationCodeRequest,this.correlationId);const r=await mn(Js,hn.GeneratePkceCodes,this.logger,this.performanceClient,this.correlationId)(this.performanceClient,this.logger,this.correlationId),n={...e,redirectUri:e.redirectUri,code:t.EMPTY_STRING,codeVerifier:r.verifier};return e.codeChallenge=r.challenge,e.codeChallengeMethod=t.S256_CODE_CHALLENGE_METHOD,n}initializeLogoutRequest(e){this.logger.verbose("initializeLogoutRequest called",e?.correlationId);const t={correlationId:this.correlationId||zi(),...e};if(e)if(e.logoutHint)this.logger.verbose("logoutHint has already been set in logoutRequest");else if(e.account){const r=this.getLogoutHintFromIdTokenClaims(e.account);r&&(this.logger.verbose("Setting logoutHint to login_hint ID Token Claim value for the account provided"),t.logoutHint=r)}else this.logger.verbose("logoutHint was not set and account was not passed into logout request, logoutHint will not be set");else this.logger.verbose("logoutHint will not be set since no logout request was configured");return e&&null===e.postLogoutRedirectUri?this.logger.verbose("postLogoutRedirectUri passed as null, not setting post logout redirect uri",t.correlationId):e&&e.postLogoutRedirectUri?(this.logger.verbose("Setting postLogoutRedirectUri to uri set on logout request",t.correlationId),t.postLogoutRedirectUri=qr.getAbsoluteUrl(e.postLogoutRedirectUri,Yi())):null===this.config.auth.postLogoutRedirectUri?this.logger.verbose("postLogoutRedirectUri configured as null and no uri set on request, not passing post logout redirect",t.correlationId):this.config.auth.postLogoutRedirectUri?(this.logger.verbose("Setting postLogoutRedirectUri to configured uri",t.correlationId),t.postLogoutRedirectUri=qr.getAbsoluteUrl(this.config.auth.postLogoutRedirectUri,Yi())):(this.logger.verbose("Setting postLogoutRedirectUri to current page",t.correlationId),t.postLogoutRedirectUri=qr.getAbsoluteUrl(Yi(),Yi())),t}getLogoutHintFromIdTokenClaims(e){const t=e.idTokenClaims;if(t){if(t.login_hint)return t.login_hint;this.logger.verbose("The ID Token Claims tied to the provided account do not contain a login_hint claim, logoutHint will not be added to logout request")}else this.logger.verbose("The provided account does not contain ID Token Claims, logoutHint will not be added to logout request");return null}async createAuthCodeClient(e,t,r,n){this.performanceClient.addQueueMeasurement(hn.StandardInteractionClientCreateAuthCodeClient,this.correlationId);const o=await mn(this.getClientConfiguration.bind(this),hn.StandardInteractionClientGetClientConfiguration,this.logger,this.performanceClient,this.correlationId)(e,t,r,n);return new zn(o,this.performanceClient)}async getClientConfiguration(e,r,n,o){this.performanceClient.addQueueMeasurement(hn.StandardInteractionClientGetClientConfiguration,this.correlationId);const i=await mn(this.getDiscoveredAuthority.bind(this),hn.StandardInteractionClientGetDiscoveredAuthority,this.logger,this.performanceClient,this.correlationId)(r,n,o),s=this.config.system.loggerOptions;return{authOptions:{clientId:this.config.auth.clientId,authority:i,clientCapabilities:this.config.auth.clientCapabilities},systemOptions:{tokenRenewalOffsetSeconds:this.config.system.tokenRenewalOffsetSeconds,preventCorsPreflight:!0},loggerOptions:{loggerCallback:s.loggerCallback,piiLoggingEnabled:s.piiLoggingEnabled,logLevel:s.logLevel,correlationId:this.correlationId},cacheOptions:{claimsBasedCachingEnabled:this.config.cache.claimsBasedCachingEnabled},cryptoInterface:this.browserCrypto,networkInterface:this.networkClient,storageInterface:this.browserStorage,serverTelemetryManager:e,libraryInfo:{sku:ti.MSAL_SKU,version:cs,cpu:t.EMPTY_STRING,os:t.EMPTY_STRING},telemetry:this.config.telemetry}}async initializeAuthorizationRequest(e,r){this.performanceClient.addQueueMeasurement(hn.StandardInteractionClientInitializeAuthorizationRequest,this.correlationId);const n=this.getRedirectUri(e.redirectUri),o={interactionType:r},i=Hn.setRequestState(this.browserCrypto,e&&e.state||t.EMPTY_STRING,o),s={...await mn(this.initializeBaseRequest.bind(this),hn.InitializeBaseRequest,this.logger,this.performanceClient,this.correlationId)(e),redirectUri:n,state:i,nonce:e.nonce||zi(),responseMode:this.config.auth.OIDCOptions.serverResponseType},a=e.account||this.browserStorage.getActiveAccount();if(a&&(this.logger.verbose("Setting validated request account",this.correlationId),this.logger.verbosePii(`Setting validated request account: ${a.homeAccountId}`,this.correlationId),s.account=a),!s.loginHint&&!a){const e=this.browserStorage.getLegacyLoginHint();e&&(s.loginHint=e)}return s}}const ta="user_switch",ra={[ta]:"User attempted to switch accounts in the native broker, which is not allowed. All new accounts must sign-in through the standard web flow first, please try again."};class na extends Te{constructor(e,t,r){super(e,t),Object.setPrototypeOf(this,na.prototype),this.name="NativeAuthError",this.ext=r}}function oa(e){return!(!e.ext||!e.ext.status||"PERSISTENT_ERROR"!==e.ext.status&&"DISABLED"!==e.ext.status)||(!(!e.ext||!e.ext.error||-2147186943!==e.ext.error)||"ContentError"===e.errorCode)}function ia(e,t,r){if(r&&r.status)switch(r.status){case"ACCOUNT_UNAVAILABLE":return Ln(wn);case"USER_INTERACTION_REQUIRED":return new On(e,t);case"USER_CANCEL":return ei(mo);case"NO_NETWORK":return ei(No)}return new na(e,ra[e]||t,r)}class sa extends ea{async acquireToken(e){this.performanceClient.addQueueMeasurement(hn.SilentCacheClientAcquireToken,e.correlationId);const t=this.initializeServerTelemetryManager(Ri.acquireTokenSilent_silentFlow),r=await this.createSilentFlowClient(t,e.authority,e.azureCloudOptions,e.account);this.logger.verbose("Silent auth client created");try{const t=(await mn(r.acquireCachedToken.bind(r),hn.SilentFlowClientAcquireCachedToken,this.logger,this.performanceClient,e.correlationId)(e))[0];return this.performanceClient.addFields({fromCache:!0},e.correlationId),t}catch(e){throw e instanceof Zo&&e.errorCode===Ho&&this.logger.verbose("Signing keypair for bound access token not found. Refreshing bound access token and generating a new crypto keypair."),e}}logout(e){this.logger.verbose("logoutRedirect called");const t=this.initializeLogoutRequest(e);return this.clearCacheOnLogout(t?.account)}async createSilentFlowClient(e,t,r,n){const o=await mn(this.getClientConfiguration.bind(this),hn.StandardInteractionClientGetClientConfiguration,this.logger,this.performanceClient,this.correlationId)(e,t,r,n);return new Gn(o,this.performanceClient)}async initializeSilentRequest(e,t){this.performanceClient.addQueueMeasurement(hn.InitializeSilentRequest,this.correlationId);const r=await mn(this.initializeBaseRequest.bind(this),hn.InitializeBaseRequest,this.logger,this.performanceClient,this.correlationId)(e);return{...e,...r,account:t,forceRefresh:e.forceRefresh||!1}}}const aa="brk_client_id",ca="brk_redirect_uri";class la extends Ys{constructor(e,t,r,n,o,i,s,a,c,l,h,d){super(e,t,r,n,o,i,a,c,d),this.apiId=s,this.accountId=l,this.nativeMessageHandler=c,this.nativeStorageManager=h,this.silentCacheClient=new sa(e,this.nativeStorageManager,r,n,o,i,a,c,d)}async acquireToken(e){this.performanceClient.addQueueMeasurement(hn.NativeInteractionClientAcquireToken,e.correlationId),this.logger.trace("NativeInteractionClient - acquireToken called.");const t=this.performanceClient.startMeasurement(hn.NativeInteractionClientAcquireToken,e.correlationId),r=Et(),n=await this.initializeNativeRequest(e);try{const e=await this.acquireTokensFromCache(this.accountId,n);return t.end({success:!0,isNativeBroker:!1,fromCache:!0}),e}catch(e){this.logger.info("MSAL internal Cache does not contain tokens, proceed to make a native call")}const o={method:ai,request:n},i=await this.nativeMessageHandler.sendMessage(o),s=this.validateNativeResponse(i);return this.handleNativeResponse(s,n,r).then((e=>(t.end({success:!0,isNativeBroker:!0,requestId:e.requestId}),e))).catch((e=>{throw t.end({success:!1,errorCode:e.errorCode,subErrorCode:e.subError,isNativeBroker:!0}),e}))}createSilentCacheRequest(e,t){return{authority:e.authority,correlationId:this.correlationId,scopes:vr.fromString(e.scope).asArray(),account:t,forceRefresh:!1}}async acquireTokensFromCache(e,t){if(!e)throw this.logger.warning("NativeInteractionClient:acquireTokensFromCache - No nativeAccountId provided"),Ct(Ve);const r=this.browserStorage.getBaseAccountInfo({nativeAccountId:e});if(!r)throw Ct(Ve);try{const e=this.createSilentCacheRequest(t,r),n=await this.silentCacheClient.acquireToken(e),o={...r,idTokenClaims:n?.idTokenClaims,idToken:n?.idToken};return{...n,account:o}}catch(e){throw e}}async acquireTokenRedirect(e){this.logger.trace("NativeInteractionClient - acquireTokenRedirect called.");const t=await this.initializeNativeRequest(e),r={method:ai,request:t};try{const e=await this.nativeMessageHandler.sendMessage(r);this.validateNativeResponse(e)}catch(e){if(e instanceof na&&oa(e))throw e}this.browserStorage.setTemporaryCache(Ti,JSON.stringify(t),!0);const n={apiId:Ri.acquireTokenRedirect,timeout:this.config.system.redirectNavigationTimeout,noHistory:!1},o=this.config.auth.navigateToLoginRequestUrl?window.location.href:this.getRedirectUri(e.redirectUri);await this.navigationClient.navigateExternal(o,n)}async handleRedirectPromise(e,t){if(this.logger.trace("NativeInteractionClient - handleRedirectPromise called."),!this.browserStorage.isInteractionInProgress(!0))return this.logger.info("handleRedirectPromise called but there is no interaction in progress, returning null."),null;const r=this.browserStorage.getCachedNativeRequest();if(!r)return this.logger.verbose("NativeInteractionClient - handleRedirectPromise called but there is no cached request, returning null."),e&&t&&e?.addFields({errorCode:"no_cached_request"},t),null;const{prompt:n,...o}=r;n&&this.logger.verbose("NativeInteractionClient - handleRedirectPromise called and prompt was included in the original request, removing prompt from cached request to prevent second interaction with native broker window."),this.browserStorage.removeItem(this.browserStorage.generateCacheKey(Ti));const i={method:ai,request:o},s=Et();try{this.logger.verbose("NativeInteractionClient - handleRedirectPromise sending message to native broker.");const e=await this.nativeMessageHandler.sendMessage(i);this.validateNativeResponse(e);const t=this.handleNativeResponse(e,o,s);return this.browserStorage.setInteractionInProgress(!1),await t}catch(e){throw this.browserStorage.setInteractionInProgress(!1),e}}logout(){return this.logger.trace("NativeInteractionClient - logout called."),Promise.reject("Logout not implemented yet")}async handleNativeResponse(e,t,r){this.logger.trace("NativeInteractionClient - handleNativeResponse called.");const n=kt(e.id_token,Es),o=this.createHomeAccountIdentifier(e,n),i=this.browserStorage.getAccountInfoFilteredBy({nativeAccountId:t.accountId})?.homeAccountId;if(o!==i&&e.account.id!==t.accountId)throw ia(ta);const s=await this.getDiscoveredAuthority(t.authority),a=Kn(this.browserStorage,s,o,n,Es,e.client_info,void 0,n.tid,void 0,e.account.id,this.logger),c=await this.generateAuthenticationResult(e,t,n,a,s.canonicalAuthority,r);return this.cacheAccount(a),this.cacheNativeTokens(e,t,o,n,c.accessToken,c.tenantId,r),c}createHomeAccountIdentifier(e,r){return Mr.generateHomeAccountId(e.client_info||t.EMPTY_STRING,Sr,this.logger,this.browserCrypto,r)}generateScopes(e,t){return e.scope?vr.fromString(e.scope):vr.fromString(t.scope)}async generatePopAccessToken(e,t){if(t.tokenType===j.POP){if(e.shr)return this.logger.trace("handleNativeServerResponse: SHR is enabled in native layer"),e.shr;const r=new Dn(this.browserCrypto),n={resourceRequestMethod:t.resourceRequestMethod,resourceRequestUri:t.resourceRequestUri,shrClaims:t.shrClaims,shrNonce:t.shrNonce};if(!t.keyId)throw Ct(at);return r.signPopToken(e.access_token,t.keyId,n)}return e.access_token}async generateAuthenticationResult(e,r,n,o,i,s){const a=this.addTelemetryFromNativeResponse(e),c=e.scope?vr.fromString(e.scope):vr.fromString(r.scope),l=e.account.properties||{},h=l.UID||n.oid||n.sub||t.EMPTY_STRING,d=l.TenantId||n.tid||t.EMPTY_STRING,u=kr(o.getAccountInfo(),void 0,n,e.id_token);u.nativeAccountId!==e.account.id&&(u.nativeAccountId=e.account.id);const g=await this.generatePopAccessToken(e,r),p=r.tokenType===j.POP?j.POP:j.BEARER;return{authority:i,uniqueId:h,tenantId:d,scopes:c.asArray(),account:u,idToken:e.id_token,idTokenClaims:n,accessToken:g,fromCache:!!a&&this.isResponseFromCache(a),expiresOn:new Date(1e3*Number(s+e.expires_in)),tokenType:p,correlationId:this.correlationId,state:e.state,fromNativeBroker:!0}}cacheAccount(e){this.browserStorage.setAccount(e),this.browserStorage.removeAccountContext(e).catch((e=>{this.logger.error(`Error occurred while removing account context from browser storage. ${e}`)}))}cacheNativeTokens(e,r,n,o,i,s,a){const c=_t(n,r.authority,e.id_token||"",r.clientId,o.tid||""),l=a+(r.tokenType===j.POP?t.SHR_NONCE_VALIDITY:("string"==typeof e.expires_in?parseInt(e.expires_in,10):e.expires_in)||0),h=this.generateScopes(e,r),d=Pt(n,r.authority,i,r.clientId,o.tid||s,h.printScopes(),l,0,Es),u=new Un(void 0,c,d);this.nativeStorageManager.saveCacheRecord(u,r.storeInCache)}addTelemetryFromNativeResponse(e){const t=this.getMATSFromResponse(e);return t?(this.performanceClient.addFields({extensionId:this.nativeMessageHandler.getExtensionId(),extensionVersion:this.nativeMessageHandler.getExtensionVersion(),matsBrokerVersion:t.broker_version,matsAccountJoinOnStart:t.account_join_on_start,matsAccountJoinOnEnd:t.account_join_on_end,matsDeviceJoin:t.device_join,matsPromptBehavior:t.prompt_behavior,matsApiErrorCode:t.api_error_code,matsUiVisible:t.ui_visible,matsSilentCode:t.silent_code,matsSilentBiSubCode:t.silent_bi_sub_code,matsSilentMessage:t.silent_message,matsSilentStatus:t.silent_status,matsHttpStatus:t.http_status,matsHttpEventCount:t.http_event_count},this.correlationId),t):null}validateNativeResponse(e){if(e.hasOwnProperty("access_token")&&e.hasOwnProperty("id_token")&&e.hasOwnProperty("client_info")&&e.hasOwnProperty("account")&&e.hasOwnProperty("scope")&&e.hasOwnProperty("expires_in"))return e;throw we(fe,"Response missing expected properties.")}getMATSFromResponse(e){if(e.properties.MATS)try{return JSON.parse(e.properties.MATS)}catch(e){this.logger.error("NativeInteractionClient - Error parsing MATS telemetry, returning null instead")}return null}isResponseFromCache(e){return void 0===e.is_cached?(this.logger.verbose("NativeInteractionClient - MATS telemetry does not contain field indicating if response was served from cache. Returning false."),!1):!!e.is_cached}async initializeNativeRequest(e){this.logger.trace("NativeInteractionClient - initializeNativeRequest called");const t=e.authority||this.config.auth.authority;e.account&&await this.getDiscoveredAuthority(t,e.azureCloudOptions,e.account);const r=new qr(t);r.validateAsUri();const{scopes:n,...o}=e,i=new vr(n||[]);i.appendScopes(s);const a={...o,accountId:this.accountId,clientId:this.config.auth.clientId,authority:r.urlString,scope:i.printScopes(),redirectUri:this.getRedirectUri(e.redirectUri),prompt:(()=>{switch(this.apiId){case Ri.ssoSilent:case Ri.acquireTokenSilent_silentFlow:return this.logger.trace("initializeNativeRequest: silent request sets prompt to none"),R.NONE}if(e.prompt)switch(e.prompt){case R.NONE:case R.CONSENT:case R.LOGIN:return this.logger.trace("initializeNativeRequest: prompt is compatible with native flow"),e.prompt;default:throw this.logger.trace(`initializeNativeRequest: prompt = ${e.prompt} is not compatible with native flow`),ei(jo)}else this.logger.trace("initializeNativeRequest: prompt was not provided")})(),correlationId:this.correlationId,tokenType:e.authenticationScheme,windowTitleSubstring:document.title,extraParameters:{...e.extraQueryParameters,...e.tokenQueryParameters},extendedExpiryToken:!1};if(this.handleExtraBrokerParams(a),a.extraParameters=a.extraParameters||{},a.extraParameters.telemetry=oi,e.authenticationScheme===j.POP){const t={resourceRequestUri:e.resourceRequestUri,resourceRequestMethod:e.resourceRequestMethod,shrClaims:e.shrClaims,shrNonce:e.shrNonce},r=new Dn(this.browserCrypto),n=await mn(r.generateCnf.bind(r),hn.PopTokenGenerateCnf,this.logger,this.performanceClient,this.correlationId)(t,this.logger);a.reqCnf=n.reqCnfHash,a.keyId=n.kid}return a}handleExtraBrokerParams(e){if(e.extraParameters&&e.extraParameters.hasOwnProperty(aa)&&e.extraParameters.hasOwnProperty(ca)&&e.extraParameters.hasOwnProperty(rn)){const t=e.extraParameters[rn],r=e.redirectUri,n=e.extraParameters[ca];e.extraParameters={child_client_id:t,child_redirect_uri:r},e.redirectUri=n}}}class ha{constructor(e,t,r,n){this.logger=e,this.handshakeTimeoutMs=t,this.extensionId=n,this.resolvers=new Map,this.handshakeResolvers=new Map,this.messageChannel=new MessageChannel,this.windowListener=this.onWindowMessage.bind(this),this.performanceClient=r,this.handshakeEvent=r.startMeasurement(hn.NativeMessageHandlerHandshake)}async sendMessage(e){this.logger.trace("NativeMessageHandler - sendMessage called.");const t={channel:ri,extensionId:this.extensionId,responseId:zi(),body:e};return this.logger.trace("NativeMessageHandler - Sending request to browser extension"),this.logger.tracePii(`NativeMessageHandler - Sending request to browser extension: ${JSON.stringify(t)}`),this.messageChannel.port1.postMessage(t),new Promise(((e,r)=>{this.resolvers.set(t.responseId,{resolve:e,reject:r})}))}static async createProvider(e,t,r){e.trace("NativeMessageHandler - createProvider called.");try{const n=new ha(e,t,r,ni);return await n.sendHandshakeRequest(),n}catch(n){const o=new ha(e,t,r);return await o.sendHandshakeRequest(),o}}async sendHandshakeRequest(){this.logger.trace("NativeMessageHandler - sendHandshakeRequest called."),window.addEventListener("message",this.windowListener,!1);const e={channel:ri,extensionId:this.extensionId,responseId:zi(),body:{method:ii}};return this.handshakeEvent.add({extensionId:this.extensionId,extensionHandshakeTimeoutMs:this.handshakeTimeoutMs}),this.messageChannel.port1.onmessage=e=>{this.onChannelMessage(e)},window.postMessage(e,window.origin,[this.messageChannel.port2]),new Promise(((t,r)=>{this.handshakeResolvers.set(e.responseId,{resolve:t,reject:r}),this.timeoutId=window.setTimeout((()=>{window.removeEventListener("message",this.windowListener,!1),this.messageChannel.port1.close(),this.messageChannel.port2.close(),this.handshakeEvent.end({extensionHandshakeTimedOut:!0,success:!1}),r(ei(zo)),this.handshakeResolvers.delete(e.responseId)}),this.handshakeTimeoutMs)}))}onWindowMessage(e){if(this.logger.trace("NativeMessageHandler - onWindowMessage called"),e.source!==window)return;const t=e.data;if(t.channel&&t.channel===ri&&(!t.extensionId||t.extensionId===this.extensionId)&&t.body.method===ii){const e=this.handshakeResolvers.get(t.responseId);if(!e)return void this.logger.trace(`NativeMessageHandler.onWindowMessage - resolver can't be found for request ${t.responseId}`);this.logger.verbose(t.extensionId?`Extension with id: ${t.extensionId} not installed`:"No extension installed"),clearTimeout(this.timeoutId),this.messageChannel.port1.close(),this.messageChannel.port2.close(),window.removeEventListener("message",this.windowListener,!1),this.handshakeEvent.end({success:!1,extensionInstalled:!1}),e.reject(ei($o))}}onChannelMessage(e){this.logger.trace("NativeMessageHandler - onChannelMessage called.");const t=e.data,r=this.resolvers.get(t.responseId),n=this.handshakeResolvers.get(t.responseId);try{const e=t.body.method;if(e===ci){if(!r)return;const e=t.body.response;if(this.logger.trace("NativeMessageHandler - Received response from browser extension"),this.logger.tracePii(`NativeMessageHandler - Received response from browser extension: ${JSON.stringify(e)}`),"Success"!==e.status)r.reject(ia(e.code,e.description,e.ext));else{if(!e.result)throw we(fe,"Event does not contain result.");e.result.code&&e.result.description?r.reject(ia(e.result.code,e.result.description,e.result.ext)):r.resolve(e.result)}this.resolvers.delete(t.responseId)}else if(e===si){if(!n)return void this.logger.trace(`NativeMessageHandler.onChannelMessage - resolver can't be found for request ${t.responseId}`);clearTimeout(this.timeoutId),window.removeEventListener("message",this.windowListener,!1),this.extensionId=t.extensionId,this.extensionVersion=t.body.version,this.logger.verbose(`NativeMessageHandler - Received HandshakeResponse from extension: ${this.extensionId}`),this.handshakeEvent.end({extensionInstalled:!0,success:!0}),n.resolve(),this.handshakeResolvers.delete(t.responseId)}}catch(t){this.logger.error("Error parsing response from WAM Extension"),this.logger.errorPii(`Error parsing response from WAM Extension: ${t}`),this.logger.errorPii(`Unable to parse ${e}`),r?r.reject(t):n&&n.reject(t)}}getExtensionId(){return this.extensionId}getExtensionVersion(){return this.extensionVersion}static isNativeAvailable(e,t,r,n){if(t.trace("isNativeAvailable called"),!e.system.allowNativeBroker)return t.trace("isNativeAvailable: allowNativeBroker is not enabled, returning false"),!1;if(!r)return t.trace("isNativeAvailable: WAM extension provider is not initialized, returning false"),!1;if(n)switch(n){case j.BEARER:case j.POP:return t.trace("isNativeAvailable: authenticationScheme is supported, returning true"),!0;default:return t.trace("isNativeAvailable: authenticationScheme is not supported, returning false"),!1}return!0}}class da{constructor(e,t,r,n,o){this.authModule=e,this.browserStorage=t,this.authCodeRequest=r,this.logger=n,this.performanceClient=o}async handleCodeResponse(e,t){let r;this.performanceClient.addQueueMeasurement(hn.HandleCodeResponse,t.correlationId);try{r=this.authModule.handleFragmentResponse(e,t.state)}catch(e){throw e instanceof Jr&&e.subError===mo?ei(mo):e}return mn(this.handleCodeResponseFromServer.bind(this),hn.HandleCodeResponseFromServer,this.logger,this.performanceClient,t.correlationId)(r,t)}async handleCodeResponseFromServer(e,t,r=!0){if(this.performanceClient.addQueueMeasurement(hn.HandleCodeResponseFromServer,t.correlationId),this.logger.trace("InteractionHandler.handleCodeResponseFromServer called"),this.authCodeRequest.code=e.code,e.cloud_instance_host_name&&await mn(this.authModule.updateAuthority.bind(this.authModule),hn.UpdateTokenEndpointAuthority,this.logger,this.performanceClient,t.correlationId)(e.cloud_instance_host_name,t.correlationId),r&&(e.nonce=t.nonce||void 0),e.state=t.state,e.client_info)this.authCodeRequest.clientInfo=e.client_info;else{const e=this.createCcsCredentials(t);e&&(this.authCodeRequest.ccsCredential=e)}return await mn(this.authModule.acquireToken.bind(this.authModule),hn.AuthClientAcquireToken,this.logger,this.performanceClient,t.correlationId)(this.authCodeRequest,e)}createCcsCredentials(e){return e.account?{credential:e.account.homeAccountId,type:en}:e.loginHint?{credential:e.loginHint,type:tn}:null}}function ua(e,t,r){const n=Or(e);if(!n)throw Nr(e)?(r.error(`A ${t} is present in the iframe but it does not contain known properties. It's likely that the ${t} has been replaced by code running on the redirectUri page.`),r.errorPii(`The ${t} detected is: ${e}`),ei(co)):(r.error(`The request has returned to the redirectUri but a ${t} is not present. It's likely that the ${t} has been removed or the page has been redirected by code running on the redirectUri page.`),ei(so));return n}class ga extends ea{constructor(e,t,r,n,o,i,s,a,c,l){super(e,t,r,n,o,i,s,c,l),this.unloadWindow=this.unloadWindow.bind(this),this.nativeStorage=a}acquireToken(e){try{const t=this.generatePopupName(e.scopes||s,e.authority||this.config.auth.authority),r=e.popupWindowAttributes||{};if(this.config.system.asyncPopups)return this.logger.verbose("asyncPopups set to true, acquiring token"),this.acquireTokenPopupAsync(e,t,r);{this.logger.verbose("asyncPopup set to false, opening popup before acquiring token");const n=this.openSizedPopup("about:blank",t,r);return this.acquireTokenPopupAsync(e,t,r,n)}}catch(e){return Promise.reject(e)}}logout(e){try{this.logger.verbose("logoutPopup called");const t=this.initializeLogoutRequest(e),r=this.generateLogoutPopupName(t),n=e&&e.authority,o=e&&e.mainWindowRedirectUri,i=e?.popupWindowAttributes||{};if(this.config.system.asyncPopups)return this.logger.verbose("asyncPopups set to true"),this.logoutPopupAsync(t,r,i,n,void 0,o);{this.logger.verbose("asyncPopup set to false, opening popup");const e=this.openSizedPopup("about:blank",r,i);return this.logoutPopupAsync(t,r,i,n,e,o)}}catch(e){return Promise.reject(e)}}async acquireTokenPopupAsync(t,r,n,o){this.logger.verbose("acquireTokenPopupAsync called");const i=this.initializeServerTelemetryManager(Ri.acquireTokenPopup),s=await mn(this.initializeAuthorizationRequest.bind(this),hn.StandardInteractionClientInitializeAuthorizationRequest,this.logger,this.performanceClient,this.correlationId)(t,e.InteractionType.Popup);rs(s.authority);try{const a=await mn(this.initializeAuthorizationCodeRequest.bind(this),hn.StandardInteractionClientInitializeAuthorizationCodeRequest,this.logger,this.performanceClient,this.correlationId)(s),c=await mn(this.createAuthCodeClient.bind(this),hn.StandardInteractionClientCreateAuthCodeClient,this.logger,this.performanceClient,this.correlationId)(i,s.authority,s.azureCloudOptions,s.account),l=ha.isNativeAvailable(this.config,this.logger,this.nativeMessageHandler,t.authenticationScheme);let h;l&&(h=this.performanceClient.startMeasurement(hn.FetchAccountIdWithNativeBroker,t.correlationId));const d=await c.getAuthCodeUrl({...s,nativeBroker:l}),u=new da(c,this.browserStorage,a,this.logger,this.performanceClient),g={popup:o,popupName:r,popupWindowAttributes:n},p=this.initiateAuthRequest(d,g);this.eventHandler.emitEvent(js.POPUP_OPENED,e.InteractionType.Popup,{popupWindow:p},null);const m=await this.monitorPopupForHash(p),f=pn(ua,hn.DeserializeResponse,this.logger,this.performanceClient,this.correlationId)(m,this.config.auth.OIDCOptions.serverResponseType,this.logger);if(Xr.removeThrottle(this.browserStorage,this.config.auth.clientId,a),f.accountId){if(this.logger.verbose("Account id found in hash, calling WAM for token"),h&&h.end({success:!0,isNativeBroker:!0}),!this.nativeMessageHandler)throw ei(Go);const e=new la(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,Ri.acquireTokenPopup,this.performanceClient,this.nativeMessageHandler,f.accountId,this.nativeStorage,s.correlationId),{userRequestState:t}=Hn.parseRequestState(this.browserCrypto,s.state);return await e.acquireToken({...s,state:t,prompt:void 0})}return await u.handleCodeResponse(f,s)}catch(e){throw o&&o.close(),e instanceof Te&&(e.setCorrelationId(this.correlationId),i.cacheFailedRequest(e)),e}}async logoutPopupAsync(t,r,n,o,i,s){this.logger.verbose("logoutPopupAsync called"),this.eventHandler.emitEvent(js.LOGOUT_START,e.InteractionType.Popup,t);const a=this.initializeServerTelemetryManager(Ri.logoutPopup);try{await this.clearCacheOnLogout(t.account);const c=await mn(this.createAuthCodeClient.bind(this),hn.StandardInteractionClientCreateAuthCodeClient,this.logger,this.performanceClient,this.correlationId)(a,o,void 0,t.account||void 0);try{c.authority.endSessionEndpoint}catch{if(t.account?.homeAccountId&&t.postLogoutRedirectUri&&c.authority.protocolMode===Pr.OIDC){if(this.browserStorage.removeAccount(t.account?.homeAccountId),this.eventHandler.emitEvent(js.LOGOUT_SUCCESS,e.InteractionType.Popup,t),s){const e={apiId:Ri.logoutPopup,timeout:this.config.system.redirectNavigationTimeout,noHistory:!1},t=qr.getAbsoluteUrl(s,Yi());await this.navigationClient.navigateInternal(t,e)}return void(i&&i.close())}}const l=c.getLogoutUri(t);this.eventHandler.emitEvent(js.LOGOUT_SUCCESS,e.InteractionType.Popup,t);const h=this.openPopup(l,{popupName:r,popupWindowAttributes:n,popup:i});if(this.eventHandler.emitEvent(js.POPUP_OPENED,e.InteractionType.Popup,{popupWindow:h},null),await this.monitorPopupForHash(h).catch((()=>{})),s){const e={apiId:Ri.logoutPopup,timeout:this.config.system.redirectNavigationTimeout,noHistory:!1},t=qr.getAbsoluteUrl(s,Yi());this.logger.verbose("Redirecting main window to url specified in the request"),this.logger.verbosePii(`Redirecting main window to: ${t}`),await this.navigationClient.navigateInternal(t,e)}else this.logger.verbose("No main window navigation requested")}catch(t){throw i&&i.close(),t instanceof Te&&(t.setCorrelationId(this.correlationId),a.cacheFailedRequest(t)),this.browserStorage.setInteractionInProgress(!1),this.eventHandler.emitEvent(js.LOGOUT_FAILURE,e.InteractionType.Popup,null,t),this.eventHandler.emitEvent(js.LOGOUT_END,e.InteractionType.Popup),t}this.eventHandler.emitEvent(js.LOGOUT_END,e.InteractionType.Popup)}initiateAuthRequest(e,t){if(e)return this.logger.infoPii(`Navigate to: ${e}`),this.openPopup(e,t);throw this.logger.error("Navigate url is empty"),ei(io)}monitorPopupForHash(e){return new Promise(((t,r)=>{this.logger.verbose("PopupHandler.monitorPopupForHash - polling started");const n=setInterval((()=>{if(e.closed)return this.logger.error("PopupHandler.monitorPopupForHash - window closed"),clearInterval(n),void r(ei(mo));let o="";try{o=e.location.href}catch(e){}if(!o||"about:blank"===o)return;clearInterval(n);let i="";const s=this.config.auth.OIDCOptions.serverResponseType;e&&(i=s===_.QUERY?e.location.search:e.location.hash),this.logger.verbose("PopupHandler.monitorPopupForHash - popup window is on same origin as caller"),t(i)}),this.config.system.pollIntervalMilliseconds)})).finally((()=>{this.cleanPopup(e)}))}openPopup(e,t){try{let r;if(t.popup?(r=t.popup,this.logger.verbosePii(`Navigating popup window to: ${e}`),r.location.assign(e)):void 0===t.popup&&(this.logger.verbosePii(`Opening popup window to: ${e}`),r=this.openSizedPopup(e,t.popupName,t.popupWindowAttributes)),!r)throw ei(po);return r.focus&&r.focus(),this.currentWindow=r,window.addEventListener("beforeunload",this.unloadWindow),r}catch(e){throw this.logger.error("error opening popup "+e.message),this.browserStorage.setInteractionInProgress(!1),ei(go)}}openSizedPopup(e,t,r){const n=window.screenLeft?window.screenLeft:window.screenX,o=window.screenTop?window.screenTop:window.screenY,i=window.innerWidth||document.documentElement.clientWidth||document.body.clientWidth,s=window.innerHeight||document.documentElement.clientHeight||document.body.clientHeight;let a=r.popupSize?.width,c=r.popupSize?.height,l=r.popupPosition?.top,h=r.popupPosition?.left;return(!a||a<0||a>i)&&(this.logger.verbose("Default popup window width used. Window width not configured or invalid."),a=ti.POPUP_WIDTH),(!c||c<0||c>s)&&(this.logger.verbose("Default popup window height used. Window height not configured or invalid."),c=ti.POPUP_HEIGHT),(!l||l<0||l>s)&&(this.logger.verbose("Default popup window top position used. Window top not configured or invalid."),l=Math.max(0,s/2-ti.POPUP_HEIGHT/2+o)),(!h||h<0||h>i)&&(this.logger.verbose("Default popup window left position used. Window left not configured or invalid."),h=Math.max(0,i/2-ti.POPUP_WIDTH/2+n)),window.open(e,t,`width=${a}, height=${c}, top=${l}, left=${h}, scrollbars=yes`)}unloadWindow(t){this.browserStorage.cleanRequestByInteractionType(e.InteractionType.Popup),this.currentWindow&&this.currentWindow.close(),t.preventDefault()}cleanPopup(e){e&&e.close(),window.removeEventListener("beforeunload",this.unloadWindow),this.browserStorage.setInteractionInProgress(!1)}generatePopupName(e,t){return`${ti.POPUP_NAME_PREFIX}.${this.config.auth.clientId}.${e.join("-")}.${t}.${this.correlationId}`}generateLogoutPopupName(e){const t=e.account&&e.account.homeAccountId;return`${ti.POPUP_NAME_PREFIX}.${this.config.auth.clientId}.${t}.${this.correlationId}`}}class pa{constructor(e,t,r,n,o){this.authModule=e,this.browserStorage=t,this.authCodeRequest=r,this.logger=n,this.performanceClient=o}async initiateAuthRequest(e,t){if(this.logger.verbose("RedirectHandler.initiateAuthRequest called"),e){t.redirectStartPage&&(this.logger.verbose("RedirectHandler.initiateAuthRequest: redirectStartPage set, caching start page"),this.browserStorage.setTemporaryCache(mi,t.redirectStartPage,!0)),this.browserStorage.setTemporaryCache(Ii,this.authCodeRequest.correlationId,!0),this.browserStorage.cacheCodeRequest(this.authCodeRequest),this.logger.infoPii(`RedirectHandler.initiateAuthRequest: Navigate to: ${e}`);const r={apiId:Ri.acquireTokenRedirect,timeout:t.redirectTimeout,noHistory:!1};if("function"==typeof t.onRedirectNavigate){this.logger.verbose("RedirectHandler.initiateAuthRequest: Invoking onRedirectNavigate callback");return!1!==t.onRedirectNavigate(e)?(this.logger.verbose("RedirectHandler.initiateAuthRequest: onRedirectNavigate did not return false, navigating"),void await t.navigationClient.navigateExternal(e,r)):void this.logger.verbose("RedirectHandler.initiateAuthRequest: onRedirectNavigate returned false, stopping navigation")}return this.logger.verbose("RedirectHandler.initiateAuthRequest: Navigating window to navigate url"),void await t.navigationClient.navigateExternal(e,r)}throw this.logger.info("RedirectHandler.initiateAuthRequest: Navigate url is empty"),ei(io)}async handleCodeResponse(e,t){this.logger.verbose("RedirectHandler.handleCodeResponse called"),this.browserStorage.setInteractionInProgress(!1);const r=this.browserStorage.generateStateKey(t),n=this.browserStorage.getTemporaryCache(r);if(!n)throw Ct(Oe,"Cached State");let o;try{o=this.authModule.handleFragmentResponse(e,n)}catch(e){throw e instanceof Jr&&e.subError===mo?ei(mo):e}const i=this.browserStorage.generateNonceKey(n),s=this.browserStorage.getTemporaryCache(i);if(this.authCodeRequest.code=o.code,o.cloud_instance_host_name&&await mn(this.authModule.updateAuthority.bind(this.authModule),hn.UpdateTokenEndpointAuthority,this.logger,this.performanceClient,this.authCodeRequest.correlationId)(o.cloud_instance_host_name,this.authCodeRequest.correlationId),o.nonce=s||void 0,o.state=n,o.client_info)this.authCodeRequest.clientInfo=o.client_info;else{const e=this.checkCcsCredentials();e&&(this.authCodeRequest.ccsCredential=e)}const a=await this.authModule.acquireToken(this.authCodeRequest,o);return this.browserStorage.cleanRequestByState(t),a}checkCcsCredentials(){const e=this.browserStorage.getTemporaryCache(vi,!0);if(e)try{return JSON.parse(e)}catch(t){this.authModule.logger.error("Cache credential could not be parsed"),this.authModule.logger.errorPii(`Cache credential could not be parsed: ${e}`)}return null}}class ma extends ea{constructor(e,t,r,n,o,i,s,a,c,l){super(e,t,r,n,o,i,s,c,l),this.nativeStorage=a}async acquireToken(t){const r=await mn(this.initializeAuthorizationRequest.bind(this),hn.StandardInteractionClientInitializeAuthorizationRequest,this.logger,this.performanceClient,this.correlationId)(t,e.InteractionType.Redirect);this.browserStorage.updateCacheEntries(r.state,r.nonce,r.authority,r.loginHint||"",r.account||null);const n=this.initializeServerTelemetryManager(Ri.acquireTokenRedirect),o=t=>{t.persisted&&(this.logger.verbose("Page was restored from back/forward cache. Clearing temporary cache."),this.browserStorage.cleanRequestByState(r.state),this.eventHandler.emitEvent(js.RESTORE_FROM_BFCACHE,e.InteractionType.Redirect))};try{const e=await mn(this.initializeAuthorizationCodeRequest.bind(this),hn.StandardInteractionClientInitializeAuthorizationCodeRequest,this.logger,this.performanceClient,this.correlationId)(r),i=await mn(this.createAuthCodeClient.bind(this),hn.StandardInteractionClientCreateAuthCodeClient,this.logger,this.performanceClient,this.correlationId)(n,r.authority,r.azureCloudOptions,r.account),s=new pa(i,this.browserStorage,e,this.logger,this.performanceClient),a=await i.getAuthCodeUrl({...r,nativeBroker:ha.isNativeAvailable(this.config,this.logger,this.nativeMessageHandler,t.authenticationScheme)}),c=this.getRedirectStartPage(t.redirectStartPage);return this.logger.verbosePii(`Redirect start page: ${c}`),window.addEventListener("pageshow",o),await s.initiateAuthRequest(a,{navigationClient:this.navigationClient,redirectTimeout:this.config.system.redirectNavigationTimeout,redirectStartPage:c,onRedirectNavigate:t.onRedirectNavigate})}catch(e){throw e instanceof Te&&(e.setCorrelationId(this.correlationId),n.cacheFailedRequest(e)),window.removeEventListener("pageshow",o),this.browserStorage.cleanRequestByState(r.state),e}}async handleRedirectPromise(r,n,o){const i=this.initializeServerTelemetryManager(Ri.handleRedirectPromise);try{if(!this.browserStorage.isInteractionInProgress(!0))return this.logger.info("handleRedirectPromise called but there is no interaction in progress, returning null."),null;const[s,a]=this.getRedirectResponse(r||"");if(!s)return this.logger.info("handleRedirectPromise did not detect a response as a result of a redirect. Cleaning temporary cache."),this.browserStorage.cleanRequestByInteractionType(e.InteractionType.Redirect),n&&o&&n?.addFields({errorCode:"no_server_response"},o),null;const c=this.browserStorage.getTemporaryCache(mi,!0)||t.EMPTY_STRING,l=qr.removeHashFromUrl(c);if(l===qr.removeHashFromUrl(window.location.href)&&this.config.auth.navigateToLoginRequestUrl){this.logger.verbose("Current page is loginRequestUrl, handling response"),c.indexOf("#")>-1&&Qi(c);return await this.handleResponse(s,i)}if(!this.config.auth.navigateToLoginRequestUrl)return this.logger.verbose("NavigateToLoginRequestUrl set to false, handling response"),await this.handleResponse(s,i);if(!ji()||this.config.system.allowRedirectInIframe){this.browserStorage.setTemporaryCache(fi,a,!0);const e={apiId:Ri.handleRedirectPromise,timeout:this.config.system.redirectNavigationTimeout,noHistory:!0};let t=!0;if(c&&"null"!==c)this.logger.verbose(`Navigating to loginRequestUrl: ${c}`),t=await this.navigationClient.navigateInternal(c,e);else{const r=Vi();this.browserStorage.setTemporaryCache(mi,r,!0),this.logger.warning("Unable to get valid login request url from cache, redirecting to home page"),t=await this.navigationClient.navigateInternal(r,e)}if(!t)return await this.handleResponse(s,i)}return null}catch(t){throw t instanceof Te&&(t.setCorrelationId(this.correlationId),i.cacheFailedRequest(t)),this.browserStorage.cleanRequestByInteractionType(e.InteractionType.Redirect),t}}getRedirectResponse(t){this.logger.verbose("getRedirectResponseHash called");let r=t;r||(r=this.config.auth.OIDCOptions.serverResponseType===_.QUERY?window.location.search:window.location.hash);let n=Or(r);if(n){try{!function(e,t,r){if(!e.state)throw ei(ao);const n=$s(t,e.state);if(!n)throw ei(lo);if(n.interactionType!==r)throw ei(ho)}(n,this.browserCrypto,e.InteractionType.Redirect)}catch(e){return e instanceof Te&&this.logger.error(`Interaction type validation failed due to ${e.errorCode}: ${e.errorMessage}`),[null,""]}return Gi(window),this.logger.verbose("Hash contains known properties, returning response hash"),[n,r]}const o=this.browserStorage.getTemporaryCache(fi,!0);return this.browserStorage.removeItem(this.browserStorage.generateCacheKey(fi)),o&&(n=Or(o),n)?(this.logger.verbose("Hash does not contain known properties, returning cached hash"),[n,o]):[null,""]}async handleResponse(e,t){const r=e.state;if(!r)throw ei(ao);const n=this.browserStorage.getCachedRequest(r);if(this.logger.verbose("handleResponse called, retrieved cached request"),e.accountId){if(this.logger.verbose("Account id found in hash, calling WAM for token"),!this.nativeMessageHandler)throw ei(Go);const t=new la(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,Ri.acquireTokenPopup,this.performanceClient,this.nativeMessageHandler,e.accountId,this.nativeStorage,n.correlationId),{userRequestState:o}=Hn.parseRequestState(this.browserCrypto,r);return t.acquireToken({...n,state:o,prompt:void 0}).finally((()=>{this.browserStorage.cleanRequestByState(r)}))}const o=this.browserStorage.getCachedAuthority(r);if(!o)throw ei(Ro);const i=await mn(this.createAuthCodeClient.bind(this),hn.StandardInteractionClientCreateAuthCodeClient,this.logger,this.performanceClient,this.correlationId)(t,o);Xr.removeThrottle(this.browserStorage,this.config.auth.clientId,n);return new pa(i,this.browserStorage,n,this.logger,this.performanceClient).handleCodeResponse(e,r)}async logout(t){this.logger.verbose("logoutRedirect called");const r=this.initializeLogoutRequest(t),n=this.initializeServerTelemetryManager(Ri.logout);try{this.eventHandler.emitEvent(js.LOGOUT_START,e.InteractionType.Redirect,t),await this.clearCacheOnLogout(r.account);const o={apiId:Ri.logout,timeout:this.config.system.redirectNavigationTimeout,noHistory:!1},i=await mn(this.createAuthCodeClient.bind(this),hn.StandardInteractionClientCreateAuthCodeClient,this.logger,this.performanceClient,this.correlationId)(n,t&&t.authority,void 0,t&&t.account||void 0);if(i.authority.protocolMode===Pr.OIDC)try{i.authority.endSessionEndpoint}catch{if(r.account?.homeAccountId)return this.browserStorage.removeAccount(r.account?.homeAccountId),void this.eventHandler.emitEvent(js.LOGOUT_SUCCESS,e.InteractionType.Redirect,r)}const s=i.getLogoutUri(r);if(this.eventHandler.emitEvent(js.LOGOUT_SUCCESS,e.InteractionType.Redirect,r),!t||"function"!=typeof t.onRedirectNavigate)return this.browserStorage.getInteractionInProgress()||this.browserStorage.setInteractionInProgress(!0),void await this.navigationClient.navigateExternal(s,o);if(!1!==t.onRedirectNavigate(s))return this.logger.verbose("Logout onRedirectNavigate did not return false, navigating"),this.browserStorage.getInteractionInProgress()||this.browserStorage.setInteractionInProgress(!0),void await this.navigationClient.navigateExternal(s,o);this.browserStorage.setInteractionInProgress(!1),this.logger.verbose("Logout onRedirectNavigate returned false, stopping navigation")}catch(t){throw t instanceof Te&&(t.setCorrelationId(this.correlationId),n.cacheFailedRequest(t)),this.eventHandler.emitEvent(js.LOGOUT_FAILURE,e.InteractionType.Redirect,null,t),this.eventHandler.emitEvent(js.LOGOUT_END,e.InteractionType.Redirect),t}this.eventHandler.emitEvent(js.LOGOUT_END,e.InteractionType.Redirect)}getRedirectStartPage(e){const t=e||window.location.href;return qr.getAbsoluteUrl(t,Yi())}}async function fa(e,t,r,n,o){if(t.addQueueMeasurement(hn.SilentHandlerInitiateAuthRequest,n),!e)throw r.info("Navigate url is empty"),ei(io);return o?mn(ya,hn.SilentHandlerLoadFrame,r,t,n)(e,o,t,n):pn(va,hn.SilentHandlerLoadFrameSync,r,t,n)(e)}async function Ca(e,t,r,n,o,i,s){return n.addQueueMeasurement(hn.SilentHandlerMonitorIframeForHash,i),new Promise(((n,i)=>{t<ss&&o.warning(`system.loadFrameTimeout or system.iframeHashTimeout set to lower (${t}ms) than the default (10000ms). This may result in timeouts.`);const a=window.setTimeout((()=>{window.clearInterval(c),i(ei(Co))}),t),c=window.setInterval((()=>{let t="";const r=e.contentWindow;try{t=r?r.location.href:""}catch(e){}if(!t||"about:blank"===t)return;let o="";r&&(o=s===_.QUERY?r.location.search:r.location.hash),window.clearTimeout(a),window.clearInterval(c),n(o)}),r)})).finally((()=>{pn(Ta,hn.RemoveHiddenIframe,o,n,i)(e)}))}function ya(e,t,r,n){return r.addQueueMeasurement(hn.SilentHandlerLoadFrame,n),new Promise(((r,n)=>{const o=Ia();window.setTimeout((()=>{o?(o.src=e,r(o)):n("Unable to load iframe")}),t)}))}function va(e){const t=Ia();return t.src=e,t}function Ia(){const e=document.createElement("iframe");return e.style.visibility="hidden",e.style.position="absolute",e.style.width=e.style.height="0",e.style.border="0",e.setAttribute("sandbox","allow-scripts allow-same-origin allow-forms"),document.body.appendChild(e),e}function Ta(e){document.body===e.parentNode&&document.body.removeChild(e)}class wa extends ea{constructor(e,t,r,n,o,i,s,a,c,l,h){super(e,t,r,n,o,i,a,l,h),this.apiId=s,this.nativeStorage=c}async acquireToken(t){this.performanceClient.addQueueMeasurement(hn.SilentIframeClientAcquireToken,t.correlationId),t.loginHint||t.sid||t.account&&t.account.username||this.logger.warning("No user hint provided. The authorization server may need more information to complete this request.");const r={...t};r.prompt?r.prompt!==R.NONE&&r.prompt!==R.NO_SESSION&&(this.logger.warning(`SilentIframeClient. Replacing invalid prompt ${r.prompt} with ${R.NONE}`),r.prompt=R.NONE):r.prompt=R.NONE;const n=await mn(this.initializeAuthorizationRequest.bind(this),hn.StandardInteractionClientInitializeAuthorizationRequest,this.logger,this.performanceClient,t.correlationId)(r,e.InteractionType.Silent);rs(n.authority);const o=this.initializeServerTelemetryManager(this.apiId);try{const e=await mn(this.createAuthCodeClient.bind(this),hn.StandardInteractionClientCreateAuthCodeClient,this.logger,this.performanceClient,t.correlationId)(o,n.authority,n.azureCloudOptions,n.account);return await mn(this.silentTokenHelper.bind(this),hn.SilentIframeClientTokenHelper,this.logger,this.performanceClient,t.correlationId)(e,n)}catch(e){throw e instanceof Te&&(e.setCorrelationId(this.correlationId),o.cacheFailedRequest(e)),e}}logout(){return Promise.reject(ei(wo))}async silentTokenHelper(e,t){const r=t.correlationId;this.performanceClient.addQueueMeasurement(hn.SilentIframeClientTokenHelper,r);const n=await mn(this.initializeAuthorizationCodeRequest.bind(this),hn.StandardInteractionClientInitializeAuthorizationCodeRequest,this.logger,this.performanceClient,r)(t),o=await mn(e.getAuthCodeUrl.bind(e),hn.GetAuthCodeUrl,this.logger,this.performanceClient,r)({...t,nativeBroker:ha.isNativeAvailable(this.config,this.logger,this.nativeMessageHandler,t.authenticationScheme)}),i=new da(e,this.browserStorage,n,this.logger,this.performanceClient),s=await mn(fa,hn.SilentHandlerInitiateAuthRequest,this.logger,this.performanceClient,r)(o,this.performanceClient,this.logger,r,this.config.system.navigateFrameWait),a=this.config.auth.OIDCOptions.serverResponseType,c=await mn(Ca,hn.SilentHandlerMonitorIframeForHash,this.logger,this.performanceClient,r)(s,this.config.system.iframeHashTimeout,this.config.system.pollIntervalMilliseconds,this.performanceClient,this.logger,r,a),l=pn(ua,hn.DeserializeResponse,this.logger,this.performanceClient,this.correlationId)(c,a,this.logger);if(l.accountId){if(this.logger.verbose("Account id found in hash, calling WAM for token"),!this.nativeMessageHandler)throw ei(Go);const e=new la(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,this.apiId,this.performanceClient,this.nativeMessageHandler,l.accountId,this.browserStorage,r),{userRequestState:n}=Hn.parseRequestState(this.browserCrypto,t.state);return mn(e.acquireToken.bind(e),hn.NativeInteractionClientAcquireToken,this.logger,this.performanceClient,r)({...t,state:n,prompt:t.prompt||R.NONE})}return mn(i.handleCodeResponse.bind(i),hn.HandleCodeResponse,this.logger,this.performanceClient,r)(l,t)}}class Aa extends ea{async acquireToken(e){this.performanceClient.addQueueMeasurement(hn.SilentRefreshClientAcquireToken,e.correlationId);const t=await mn(this.initializeBaseRequest.bind(this),hn.InitializeBaseRequest,this.logger,this.performanceClient,e.correlationId)(e),r={...e,...t};e.redirectUri&&(r.redirectUri=this.getRedirectUri(e.redirectUri));const n=this.initializeServerTelemetryManager(Ri.acquireTokenSilent_silentFlow),o=await this.createRefreshTokenClient(n,r.authority,r.azureCloudOptions,r.account);return mn(o.acquireTokenByRefreshToken.bind(o),hn.RefreshTokenClientAcquireTokenByRefreshToken,this.logger,this.performanceClient,e.correlationId)(r).catch((e=>{throw e.setCorrelationId(this.correlationId),n.cacheFailedRequest(e),e}))}logout(){return Promise.reject(ei(wo))}async createRefreshTokenClient(e,t,r,n){const o=await mn(this.getClientConfiguration.bind(this),hn.StandardInteractionClientGetClientConfiguration,this.logger,this.performanceClient,this.correlationId)(e,t,r,n);return new $n(o,this.performanceClient)}}class ka{constructor(e,t,r,n){this.isBrowserEnvironment="undefined"!=typeof window,this.config=e,this.storage=t,this.logger=r,this.cryptoObj=n}loadExternalTokens(e,t,r){if(this.logger.info("TokenCache - loadExternalTokens called"),!t.id_token)throw ei(Uo);const n=kt(t.id_token,Es);let o,i,s;if(e.account)s=Mr.createFromAccountInfo(e.account),o=new Un(s,this.loadIdToken(t.id_token,s.homeAccountId,e.account.environment,e.account.tenantId),this.loadAccessToken(e,t,s.homeAccountId,e.account.environment,e.account.tenantId,r),this.loadRefreshToken(e,t,s.homeAccountId,e.account.environment));else{if(!e.authority)throw ei(Uo);{const a=Cn.generateAuthority(e.authority,e.azureCloudOptions),c={protocolMode:this.config.auth.protocolMode,knownAuthorities:this.config.auth.knownAuthorities,cloudDiscoveryMetadata:this.config.auth.cloudDiscoveryMetadata,authorityMetadata:this.config.auth.authorityMetadata,skipAuthorityMetadataCache:this.config.auth.skipAuthorityMetadataCache};if(i=new Cn(a,this.config.system.networkClient,this.storage,c,this.logger,e.correlationId||zi()),r.clientInfo)this.logger.trace("TokenCache - homeAccountId from options"),s=this.loadAccount(n,i,r.clientInfo),o=new Un(s,this.loadIdToken(t.id_token,s.homeAccountId,i.hostnameAndPort,i.tenant),this.loadAccessToken(e,t,s.homeAccountId,i.hostnameAndPort,i.tenant,r),this.loadRefreshToken(e,t,s.homeAccountId,i.hostnameAndPort));else{if(!t.client_info)throw ei(Uo);this.logger.trace("TokenCache - homeAccountId from response"),s=this.loadAccount(n,i,t.client_info),o=new Un(s,this.loadIdToken(t.id_token,s.homeAccountId,i.hostnameAndPort,i.tenant),this.loadAccessToken(e,t,s.homeAccountId,i.hostnameAndPort,i.tenant,r),this.loadRefreshToken(e,t,s.homeAccountId,i.hostnameAndPort))}}}return this.generateAuthenticationResult(e,n,o,s,i)}loadAccount(e,t,r,n){if(this.isBrowserEnvironment){let o;if(this.logger.verbose("TokenCache - loading account"),n?o=n:void 0!==t.authorityType&&r&&(o=Mr.generateHomeAccountId(r,t.authorityType,this.logger,this.cryptoObj,e)),!o)throw ei(Uo);const i=e.tid,s=Kn(this.storage,t,o,e,Es,r,t.hostnameAndPort,i,void 0,void 0,this.logger);return this.storage.setAccount(s),s}throw ei(Uo)}loadIdToken(e,t,r,n){const o=_t(t,r,e,this.config.auth.clientId,n);if(this.isBrowserEnvironment)return this.logger.verbose("TokenCache - loading id token"),this.storage.setIdTokenCredential(o),o;throw ei(Uo)}loadAccessToken(e,t,r,n,o,i){if(!t.access_token)return this.logger.verbose("TokenCache - No access token provided for caching"),null;if(!t.expires_in)throw ei(Uo);if(!i.extendedExpiresOn)throw ei(Uo);const s=new vr(e.scopes).printScopes(),a=i.expiresOn||t.expires_in+(new Date).getTime()/1e3,c=i.extendedExpiresOn,l=Pt(r,n,t.access_token,this.config.auth.clientId,o,s,a,c,Es);if(this.isBrowserEnvironment)return this.logger.verbose("TokenCache - loading access token"),this.storage.setAccessTokenCredential(l),l;throw ei(Uo)}loadRefreshToken(e,t,r,n){if(!t.refresh_token)return this.logger.verbose("TokenCache - No refresh token provided for caching"),null;const o=Mt(r,n,t.refresh_token,this.config.auth.clientId);if(this.isBrowserEnvironment)return this.logger.verbose("TokenCache - loading refresh token"),this.storage.setRefreshTokenCredential(o),o;throw ei(Uo)}generateAuthenticationResult(e,r,n,o,i){let s,a=t.EMPTY_STRING,c=[],l=null;n?.accessToken&&(a=n.accessToken.secret,c=vr.fromString(n.accessToken.target).asArray(),l=new Date(1e3*Number(n.accessToken.expiresOn)),s=new Date(1e3*Number(n.accessToken.extendedExpiresOn)));const h=r.oid||r.sub||t.EMPTY_STRING,d=r.tid||t.EMPTY_STRING;return{authority:i?i.canonicalAuthority:t.EMPTY_STRING,uniqueId:h,tenantId:d,scopes:c,account:o.getAccountInfo(),idToken:n.idToken?.secret||"",idTokenClaims:r||{},accessToken:a,fromCache:!0,expiresOn:l,correlationId:e.correlationId||t.EMPTY_STRING,requestId:t.EMPTY_STRING,extExpiresOn:s,familyId:t.EMPTY_STRING,tokenType:n?.accessToken?.tokenType||t.EMPTY_STRING,state:t.EMPTY_STRING,cloudGraphHostName:o.cloudGraphHostName||t.EMPTY_STRING,msGraphHost:o.msGraphHost||t.EMPTY_STRING,code:void 0,fromNativeBroker:!1}}}class Sa extends zn{constructor(e){super(e),this.includeRedirectUri=!1}}class Ea extends ea{constructor(e,t,r,n,o,i,s,a,c,l){super(e,t,r,n,o,i,a,c,l),this.apiId=s}async acquireToken(t){if(!t.code)throw ei(Bo);const r=await mn(this.initializeAuthorizationRequest.bind(this),hn.StandardInteractionClientInitializeAuthorizationRequest,this.logger,this.performanceClient,t.correlationId)(t,e.InteractionType.Silent),n=this.initializeServerTelemetryManager(this.apiId);try{const e={...r,code:t.code},o=await mn(this.getClientConfiguration.bind(this),hn.StandardInteractionClientGetClientConfiguration,this.logger,this.performanceClient,t.correlationId)(n,r.authority,r.azureCloudOptions,r.account),i=new Sa(o);this.logger.verbose("Auth code client created");const s=new da(i,this.browserStorage,e,this.logger,this.performanceClient);return await mn(s.handleCodeResponseFromServer.bind(s),hn.HandleCodeResponseFromServer,this.logger,this.performanceClient,t.correlationId)({code:t.code,msgraph_host:t.msGraphHost,cloud_graph_host_name:t.cloudGraphHostName,cloud_instance_host_name:t.cloudInstanceHostName},r,!1)}catch(e){throw e instanceof Te&&(e.setCorrelationId(this.correlationId),n.cacheFailedRequest(e)),e}}logout(){return Promise.reject(ei(wo))}}class Ra{constructor(e){this.atsAsyncMeasurement=void 0,this.operatingContext=e,this.isBrowserEnvironment=this.operatingContext.isBrowserEnvironment(),this.config=e.getConfig(),this.initialized=!1,this.logger=this.operatingContext.getLogger(),this.networkClient=this.config.system.networkClient,this.navigationClient=this.config.system.navigationClient,this.redirectResponse=new Map,this.hybridAuthCodeResponses=new Map,this.performanceClient=this.config.telemetry.client,this.browserCrypto=this.isBrowserEnvironment?new Os(this.logger,this.performanceClient):yt,this.eventHandler=new Ws(this.logger,this.browserCrypto),this.browserStorage=this.isBrowserEnvironment?new Gs(this.config.auth.clientId,this.config.cache,this.browserCrypto,this.logger,function(e){const t=e.cloudDiscoveryMetadata;let r;if(t)try{r=JSON.parse(t)}catch(e){throw Cr(nr)}return{canonicalAuthority:e.authority?yn(e.authority):void 0,knownAuthorities:e.knownAuthorities,cloudDiscoveryMetadata:r}}(this.config.auth)):Qs(this.config.auth.clientId,this.logger);const t={cacheLocation:li.MemoryStorage,temporaryCacheLocation:li.MemoryStorage,storeAuthStateInCookie:!1,secureCookies:!1,cacheMigrationEnabled:!1,claimsBasedCachingEnabled:!1};this.nativeInternalStorage=new Gs(this.config.auth.clientId,t,this.browserCrypto,this.logger),this.tokenCache=new ka(this.config,this.browserStorage,this.logger,this.browserCrypto),this.activeSilentTokenRequests=new Map,this.trackPageVisibility=this.trackPageVisibility.bind(this),this.trackPageVisibilityWithMeasurement=this.trackPageVisibilityWithMeasurement.bind(this)}static async createController(e){const t=new Ra(e);return await t.initialize(),t}trackPageVisibility(){this.atsAsyncMeasurement&&(this.logger.info("Perf: Visibility change detected"),this.atsAsyncMeasurement.increment({visibilityChangeCount:1}))}async initialize(){if(this.logger.trace("initialize called"),this.initialized)return void this.logger.info("initialize has already been called, exiting early.");const e=this.config.system.allowNativeBroker,t=this.performanceClient.startMeasurement(hn.InitializeClientApplication);if(this.eventHandler.emitEvent(js.INITIALIZE_START),e)try{this.nativeExtensionProvider=await ha.createProvider(this.logger,this.config.system.nativeBrokerHandshakeTimeout,this.performanceClient)}catch(e){this.logger.verbose(e)}this.config.cache.claimsBasedCachingEnabled||(this.logger.verbose("Claims-based caching is disabled. Clearing the previous cache with claims"),await mn(this.browserStorage.clearTokensAndKeysWithClaims.bind(this.browserStorage),hn.ClearTokensAndKeysWithClaims,this.logger,this.performanceClient)(this.performanceClient)),this.initialized=!0,this.eventHandler.emitEvent(js.INITIALIZE_END),t.end({allowNativeBroker:e,success:!0})}async handleRedirectPromise(t){this.logger.verbose("handleRedirectPromise called"),ts(this.initialized);const r=this.getAllAccounts();if(this.isBrowserEnvironment){const n=t||"";let o=this.redirectResponse.get(n);if(void 0===o){const i=this.browserStorage.getCachedNativeRequest(),s=i&&ha.isNativeAvailable(this.config,this.logger,this.nativeExtensionProvider)&&this.nativeExtensionProvider&&!t,a=s?i?.correlationId:this.browserStorage.getTemporaryCache(Ii,!0)||"",c=this.performanceClient.startMeasurement("acquireTokenRedirect",a);let l;if(this.eventHandler.emitEvent(js.HANDLE_REDIRECT_START,e.InteractionType.Redirect),this.logger.verbose("handleRedirectPromise has been called for the first time, storing the promise"),s&&this.nativeExtensionProvider){this.logger.trace("handleRedirectPromise - acquiring token from native platform");const e=new la(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,Ri.handleRedirectPromise,this.performanceClient,this.nativeExtensionProvider,i.accountId,this.nativeInternalStorage,i.correlationId);l=mn(e.handleRedirectPromise.bind(e),hn.HandleNativeRedirectPromiseMeasurement,this.logger,this.performanceClient,c.event.correlationId)(this.performanceClient,c.event.correlationId)}else{this.logger.trace("handleRedirectPromise - acquiring token from web flow");const e=this.createRedirectClient(a);l=mn(e.handleRedirectPromise.bind(e),hn.HandleRedirectPromiseMeasurement,this.logger,this.performanceClient,c.event.correlationId)(t,this.performanceClient,c.event.correlationId)}o=l.then((t=>{if(t){r.length<this.getAllAccounts().length?(this.eventHandler.emitEvent(js.LOGIN_SUCCESS,e.InteractionType.Redirect,t),this.logger.verbose("handleRedirectResponse returned result, login success")):(this.eventHandler.emitEvent(js.ACQUIRE_TOKEN_SUCCESS,e.InteractionType.Redirect,t),this.logger.verbose("handleRedirectResponse returned result, acquire token success")),c.end({success:!0})}return this.eventHandler.emitEvent(js.HANDLE_REDIRECT_END,e.InteractionType.Redirect),c.end({success:!1}),t})).catch((t=>{const n=t;throw r.length>0?this.eventHandler.emitEvent(js.ACQUIRE_TOKEN_FAILURE,e.InteractionType.Redirect,null,n):this.eventHandler.emitEvent(js.LOGIN_FAILURE,e.InteractionType.Redirect,null,n),this.eventHandler.emitEvent(js.HANDLE_REDIRECT_END,e.InteractionType.Redirect),n instanceof Te?c.end({success:!1,errorCode:n.errorCode,subErrorCode:n.subError}):c.end({success:!1}),t})),this.redirectResponse.set(n,o)}else this.logger.verbose("handleRedirectPromise has been called previously, returning the result from the first call");return o}return this.logger.verbose("handleRedirectPromise returns null, not browser environment"),null}async acquireTokenRedirect(t){const r=this.getRequestCorrelationId(t);this.logger.verbose("acquireTokenRedirect called",r),this.preflightBrowserEnvironmentCheck(e.InteractionType.Redirect);const n=this.getAllAccounts().length>0;let o;if(n?this.eventHandler.emitEvent(js.ACQUIRE_TOKEN_START,e.InteractionType.Redirect,t):this.eventHandler.emitEvent(js.LOGIN_START,e.InteractionType.Redirect,t),this.nativeExtensionProvider&&this.canUseNative(t)){o=new la(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,Ri.acquireTokenRedirect,this.performanceClient,this.nativeExtensionProvider,this.getNativeAccountId(t),this.nativeInternalStorage,r).acquireTokenRedirect(t).catch((e=>{if(e instanceof na&&oa(e)){this.nativeExtensionProvider=void 0;return this.createRedirectClient(r).acquireToken(t)}if(e instanceof On){this.logger.verbose("acquireTokenRedirect - Resolving interaction required error thrown by native broker by falling back to web flow");return this.createRedirectClient(r).acquireToken(t)}throw this.getBrowserStorage().setInteractionInProgress(!1),e}))}else{o=this.createRedirectClient(r).acquireToken(t)}return o.catch((t=>{throw n?this.eventHandler.emitEvent(js.ACQUIRE_TOKEN_FAILURE,e.InteractionType.Redirect,null,t):this.eventHandler.emitEvent(js.LOGIN_FAILURE,e.InteractionType.Redirect,null,t),t}))}acquireTokenPopup(t){const r=this.getRequestCorrelationId(t),n=this.performanceClient.startMeasurement(hn.AcquireTokenPopup,r);try{this.logger.verbose("acquireTokenPopup called",r),this.preflightBrowserEnvironmentCheck(e.InteractionType.Popup)}catch(e){return Promise.reject(e)}const o=this.getAllAccounts();let i;if(o.length>0?this.eventHandler.emitEvent(js.ACQUIRE_TOKEN_START,e.InteractionType.Popup,t):this.eventHandler.emitEvent(js.LOGIN_START,e.InteractionType.Popup,t),this.canUseNative(t))i=this.acquireTokenNative({...t,correlationId:r},Ri.acquireTokenPopup).then((e=>(this.getBrowserStorage().setInteractionInProgress(!1),n.end({success:!0,isNativeBroker:!0,requestId:e.requestId}),e))).catch((e=>{if(e instanceof na&&oa(e)){this.nativeExtensionProvider=void 0;return this.createPopupClient(r).acquireToken(t)}if(e instanceof On){this.logger.verbose("acquireTokenPopup - Resolving interaction required error thrown by native broker by falling back to web flow");return this.createPopupClient(r).acquireToken(t)}throw this.getBrowserStorage().setInteractionInProgress(!1),e}));else{i=this.createPopupClient(r).acquireToken(t)}return i.then((t=>(o.length<this.getAllAccounts().length?this.eventHandler.emitEvent(js.LOGIN_SUCCESS,e.InteractionType.Popup,t):this.eventHandler.emitEvent(js.ACQUIRE_TOKEN_SUCCESS,e.InteractionType.Popup,t),n.add({accessTokenSize:t.accessToken.length,idTokenSize:t.idToken.length}),n.end({success:!0,requestId:t.requestId}),t))).catch((t=>(o.length>0?this.eventHandler.emitEvent(js.ACQUIRE_TOKEN_FAILURE,e.InteractionType.Popup,null,t):this.eventHandler.emitEvent(js.LOGIN_FAILURE,e.InteractionType.Popup,null,t),n.end({errorCode:t.errorCode,subErrorCode:t.subError,success:!1}),Promise.reject(t))))}trackPageVisibilityWithMeasurement(){const e=this.ssoSilentMeasurement||this.acquireTokenByCodeAsyncMeasurement;e&&(this.logger.info("Perf: Visibility change detected in ",e.event.name),e.increment({visibilityChangeCount:1}))}async ssoSilent(t){const r=this.getRequestCorrelationId(t),n={...t,prompt:t.prompt,correlationId:r};let o;if(this.preflightBrowserEnvironmentCheck(e.InteractionType.Silent),this.ssoSilentMeasurement=this.performanceClient.startMeasurement(hn.SsoSilent,r),this.ssoSilentMeasurement?.increment({visibilityChangeCount:0}),document.addEventListener("visibilitychange",this.trackPageVisibilityWithMeasurement),this.logger.verbose("ssoSilent called",r),this.eventHandler.emitEvent(js.SSO_SILENT_START,e.InteractionType.Silent,n),this.canUseNative(n))o=this.acquireTokenNative(n,Ri.ssoSilent).catch((e=>{if(e instanceof na&&oa(e)){this.nativeExtensionProvider=void 0;return this.createSilentIframeClient(n.correlationId).acquireToken(n)}throw e}));else{o=this.createSilentIframeClient(n.correlationId).acquireToken(n)}return o.then((t=>(this.eventHandler.emitEvent(js.SSO_SILENT_SUCCESS,e.InteractionType.Silent,t),this.ssoSilentMeasurement?.add({accessTokenSize:t.accessToken.length,idTokenSize:t.idToken.length}),this.ssoSilentMeasurement?.end({success:!0,isNativeBroker:t.fromNativeBroker,requestId:t.requestId}),t))).catch((t=>{throw this.eventHandler.emitEvent(js.SSO_SILENT_FAILURE,e.InteractionType.Silent,null,t),this.ssoSilentMeasurement?.end({errorCode:t.errorCode,subErrorCode:t.subError,success:!1}),t})).finally((()=>{document.removeEventListener("visibilitychange",this.trackPageVisibilityWithMeasurement)}))}async acquireTokenByCode(t){const r=this.getRequestCorrelationId(t);this.preflightBrowserEnvironmentCheck(e.InteractionType.Silent),this.logger.trace("acquireTokenByCode called",r),this.eventHandler.emitEvent(js.ACQUIRE_TOKEN_BY_CODE_START,e.InteractionType.Silent,t);const n=this.performanceClient.startMeasurement(hn.AcquireTokenByCode,r);try{if(t.code&&t.nativeAccountId)throw ei(xo);if(t.code){const o=t.code;let i=this.hybridAuthCodeResponses.get(o);return i?(this.logger.verbose("Existing acquireTokenByCode request found",r),n.discard()):(this.logger.verbose("Initiating new acquireTokenByCode request",r),i=this.acquireTokenByCodeAsync({...t,correlationId:r}).then((t=>(this.eventHandler.emitEvent(js.ACQUIRE_TOKEN_BY_CODE_SUCCESS,e.InteractionType.Silent,t),this.hybridAuthCodeResponses.delete(o),n.add({accessTokenSize:t.accessToken.length,idTokenSize:t.idToken.length}),n.end({success:!0,isNativeBroker:t.fromNativeBroker,requestId:t.requestId}),t))).catch((t=>{throw this.hybridAuthCodeResponses.delete(o),this.eventHandler.emitEvent(js.ACQUIRE_TOKEN_BY_CODE_FAILURE,e.InteractionType.Silent,null,t),n.end({errorCode:t.errorCode,subErrorCode:t.subError,success:!1}),t})),this.hybridAuthCodeResponses.set(o,i)),await i}if(t.nativeAccountId){if(this.canUseNative(t,t.nativeAccountId))return await this.acquireTokenNative({...t,correlationId:r},Ri.acquireTokenByCode,t.nativeAccountId).catch((e=>{throw e instanceof na&&oa(e)&&(this.nativeExtensionProvider=void 0),e}));throw ei(Ko)}throw ei(Do)}catch(t){throw this.eventHandler.emitEvent(js.ACQUIRE_TOKEN_BY_CODE_FAILURE,e.InteractionType.Silent,null,t),n.end({errorCode:t instanceof Te&&t.errorCode||void 0,subErrorCode:t instanceof Te&&t.subError||void 0,success:!1}),t}}async acquireTokenByCodeAsync(e){this.logger.trace("acquireTokenByCodeAsync called",e.correlationId),this.acquireTokenByCodeAsyncMeasurement=this.performanceClient.startMeasurement(hn.AcquireTokenByCodeAsync,e.correlationId),this.acquireTokenByCodeAsyncMeasurement?.increment({visibilityChangeCount:0}),document.addEventListener("visibilitychange",this.trackPageVisibilityWithMeasurement);const t=this.createSilentAuthCodeClient(e.correlationId);return await t.acquireToken(e).then((e=>(this.acquireTokenByCodeAsyncMeasurement?.end({success:!0,fromCache:e.fromCache,isNativeBroker:e.fromNativeBroker,requestId:e.requestId}),e))).catch((e=>{throw this.acquireTokenByCodeAsyncMeasurement?.end({errorCode:e.errorCode,subErrorCode:e.subError,success:!1}),e})).finally((()=>{document.removeEventListener("visibilitychange",this.trackPageVisibilityWithMeasurement)}))}async acquireTokenFromCache(e,t,r){switch(this.performanceClient.addQueueMeasurement(hn.AcquireTokenFromCache,t.correlationId),r){case Oi.Default:case Oi.AccessToken:case Oi.AccessTokenAndRefreshToken:return mn(e.acquireToken.bind(e),hn.SilentCacheClientAcquireToken,this.logger,this.performanceClient,t.correlationId)(t);default:throw Ct(tt)}}async acquireTokenByRefreshToken(e,t){switch(this.performanceClient.addQueueMeasurement(hn.AcquireTokenByRefreshToken,e.correlationId),t){case Oi.Default:case Oi.AccessTokenAndRefreshToken:case Oi.RefreshToken:case Oi.RefreshTokenAndNetwork:const t=this.createSilentRefreshClient(e.correlationId);return mn(t.acquireToken.bind(t),hn.SilentRefreshClientAcquireToken,this.logger,this.performanceClient,e.correlationId)(e);default:throw Ct(tt)}}async acquireTokenBySilentIframe(e){this.performanceClient.addQueueMeasurement(hn.AcquireTokenBySilentIframe,e.correlationId);const t=this.createSilentIframeClient(e.correlationId);return mn(t.acquireToken.bind(t),hn.SilentIframeClientAcquireToken,this.logger,this.performanceClient,e.correlationId)(e)}async logout(e){const t=this.getRequestCorrelationId(e);return this.logger.warning("logout API is deprecated and will be removed in msal-browser v3.0.0. Use logoutRedirect instead.",t),this.logoutRedirect({correlationId:t,...e})}async logoutRedirect(t){const r=this.getRequestCorrelationId(t);this.preflightBrowserEnvironmentCheck(e.InteractionType.Redirect);return this.createRedirectClient(r).logout(t)}logoutPopup(t){try{const r=this.getRequestCorrelationId(t);this.preflightBrowserEnvironmentCheck(e.InteractionType.Popup);return this.createPopupClient(r).logout(t)}catch(e){return Promise.reject(e)}}async clearCache(e){const t=this.getRequestCorrelationId(e);return this.createSilentCacheClient(t).logout(e)}getAllAccounts(e){return this.logger.verbose("getAllAccounts called"),this.isBrowserEnvironment?this.browserStorage.getAllAccounts(e):[]}getAccount(e){if(this.logger.trace("getAccount called"),0===Object.keys(e).length)return this.logger.warning("getAccount: No accountFilter provided"),null;const t=this.browserStorage.getAccountInfoFilteredBy(e);return t?(this.logger.verbose("getAccount: Account matching provided filter found, returning"),t):(this.logger.verbose("getAccount: No matching account found, returning null"),null)}getAccountByUsername(e){if(this.logger.trace("getAccountByUsername called"),!e)return this.logger.warning("getAccountByUsername: No username provided"),null;const t=this.browserStorage.getAccountInfoFilteredBy({username:e});return t?(this.logger.verbose("getAccountByUsername: Account matching username found, returning"),this.logger.verbosePii(`getAccountByUsername: Returning signed-in accounts matching username: ${e}`),t):(this.logger.verbose("getAccountByUsername: No matching account found, returning null"),null)}getAccountByHomeId(e){if(this.logger.trace("getAccountByHomeId called"),!e)return this.logger.warning("getAccountByHomeId: No homeAccountId provided"),null;const t=this.browserStorage.getAccountInfoFilteredBy({homeAccountId:e});return t?(this.logger.verbose("getAccountByHomeId: Account matching homeAccountId found, returning"),this.logger.verbosePii(`getAccountByHomeId: Returning signed-in accounts matching homeAccountId: ${e}`),t):(this.logger.verbose("getAccountByHomeId: No matching account found, returning null"),null)}getAccountByLocalId(e){if(this.logger.trace("getAccountByLocalId called"),!e)return this.logger.warning("getAccountByLocalId: No localAccountId provided"),null;const t=this.browserStorage.getAccountInfoFilteredBy({localAccountId:e});return t?(this.logger.verbose("getAccountByLocalId: Account matching localAccountId found, returning"),this.logger.verbosePii(`getAccountByLocalId: Returning signed-in accounts matching localAccountId: ${e}`),t):(this.logger.verbose("getAccountByLocalId: No matching account found, returning null"),null)}setActiveAccount(e){this.browserStorage.setActiveAccount(e)}getActiveAccount(){return this.browserStorage.getActiveAccount()}async hydrateCache(e,t){this.logger.verbose("hydrateCache called");const r=Mr.createFromAccountInfo(e.account,e.cloudGraphHostName,e.msGraphHost);return this.browserStorage.setAccount(r),e.fromNativeBroker?(this.logger.verbose("Response was from native broker, storing in-memory"),this.nativeInternalStorage.hydrateCache(e,t)):this.browserStorage.hydrateCache(e,t)}preflightBrowserEnvironmentCheck(t,r=!1){if(this.logger.verbose("preflightBrowserEnvironmentCheck started"),es(this.isBrowserEnvironment),Xi(t,this.config.system.allowRedirectInIframe),Ji(),Zi(),ts(this.initialized),t===e.InteractionType.Redirect&&this.config.cache.cacheLocation===li.MemoryStorage&&!this.config.cache.storeAuthStateInCookie)throw Ks(Hs);t!==e.InteractionType.Redirect&&t!==e.InteractionType.Popup||this.preflightInteractiveRequest(!r)}preflightInteractiveRequest(e){this.logger.verbose("preflightInteractiveRequest called, validating app environment"),Ji(),e&&this.getBrowserStorage().setInteractionInProgress(!0)}async acquireTokenNative(e,t,r){if(this.logger.trace("acquireTokenNative called"),!this.nativeExtensionProvider)throw ei(Go);return new la(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,t,this.performanceClient,this.nativeExtensionProvider,r||this.getNativeAccountId(e),this.nativeInternalStorage,e.correlationId).acquireToken(e)}canUseNative(e,t){if(this.logger.trace("canUseNative called"),!ha.isNativeAvailable(this.config,this.logger,this.nativeExtensionProvider,e.authenticationScheme))return this.logger.trace("canUseNative: isNativeAvailable returned false, returning false"),!1;if(e.prompt)switch(e.prompt){case R.NONE:case R.CONSENT:case R.LOGIN:this.logger.trace("canUseNative: prompt is compatible with native flow");break;default:return this.logger.trace(`canUseNative: prompt = ${e.prompt} is not compatible with native flow, returning false`),!1}return!(!t&&!this.getNativeAccountId(e))||(this.logger.trace("canUseNative: nativeAccountId is not available, returning false"),!1)}getNativeAccountId(e){const t=e.account||this.getAccount({loginHint:e.loginHint,sid:e.sid})||this.getActiveAccount();return t&&t.nativeAccountId||""}createPopupClient(e){return new ga(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,this.performanceClient,this.nativeInternalStorage,this.nativeExtensionProvider,e)}createRedirectClient(e){return new ma(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,this.performanceClient,this.nativeInternalStorage,this.nativeExtensionProvider,e)}createSilentIframeClient(e){return new wa(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,Ri.ssoSilent,this.performanceClient,this.nativeInternalStorage,this.nativeExtensionProvider,e)}createSilentCacheClient(e){return new sa(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,this.performanceClient,this.nativeExtensionProvider,e)}createSilentRefreshClient(e){return new Aa(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,this.performanceClient,this.nativeExtensionProvider,e)}createSilentAuthCodeClient(e){return new Ea(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,Ri.acquireTokenByCode,this.performanceClient,this.nativeExtensionProvider,e)}addEventCallback(e){return this.eventHandler.addEventCallback(e)}removeEventCallback(e){this.eventHandler.removeEventCallback(e)}addPerformanceCallback(e){return this.performanceClient.addPerformanceCallback(e)}removePerformanceCallback(e){return this.performanceClient.removePerformanceCallback(e)}enableAccountStorageEvents(){this.eventHandler.enableAccountStorageEvents()}disableAccountStorageEvents(){this.eventHandler.disableAccountStorageEvents()}getTokenCache(){return this.tokenCache}getLogger(){return this.logger}setLogger(e){this.logger=e}initializeWrapperLibrary(e,t){this.browserStorage.setWrapperMetadata(e,t)}setNavigationClient(e){this.navigationClient=e}getConfiguration(){return this.config}getPerformanceClient(){return this.performanceClient}getBrowserStorage(){return this.browserStorage}isBrowserEnv(){return this.isBrowserEnvironment}getEventHandler(){return this.eventHandler}getRequestCorrelationId(e){return e?.correlationId?e.correlationId:this.isBrowserEnvironment?zi():t.EMPTY_STRING}async loginRedirect(e){const t=this.getRequestCorrelationId(e);return this.logger.verbose("loginRedirect called",t),this.acquireTokenRedirect({correlationId:t,...e||Pi})}loginPopup(e){const t=this.getRequestCorrelationId(e);return this.logger.verbose("loginPopup called",t),this.acquireTokenPopup({correlationId:t,...e||Pi})}async acquireTokenSilent(r){const n=this.getRequestCorrelationId(r),o=this.performanceClient.startMeasurement(hn.AcquireTokenSilent,n);o.add({cacheLookupPolicy:r.cacheLookupPolicy}),this.preflightBrowserEnvironmentCheck(e.InteractionType.Silent),this.logger.verbose("acquireTokenSilent called",n);const i=r.account||this.getActiveAccount();if(!i)throw ei(Ao);const s={clientId:this.config.auth.clientId,authority:r.authority||t.EMPTY_STRING,scopes:r.scopes,homeAccountIdentifier:i.homeAccountId,claims:r.claims,authenticationScheme:r.authenticationScheme,resourceRequestMethod:r.resourceRequestMethod,resourceRequestUri:r.resourceRequestUri,shrClaims:r.shrClaims,sshKid:r.sshKid,shrOptions:r.shrOptions},a=JSON.stringify(s),c=this.activeSilentTokenRequests.get(a);if(void 0===c){this.logger.verbose("acquireTokenSilent called for the first time, storing active request",n);const e=mn(this.acquireTokenSilentAsync.bind(this),hn.AcquireTokenSilentAsync,this.logger,this.performanceClient,n)({...r,correlationId:n},i).then((e=>(this.activeSilentTokenRequests.delete(a),o.add({accessTokenSize:e.accessToken.length,idTokenSize:e.idToken.length}),o.end({success:!0,fromCache:e.fromCache,isNativeBroker:e.fromNativeBroker,cacheLookupPolicy:r.cacheLookupPolicy,requestId:e.requestId}),e))).catch((e=>{throw this.activeSilentTokenRequests.delete(a),o.end({errorCode:e.errorCode,subErrorCode:e.subError,success:!1}),e}));return this.activeSilentTokenRequests.set(a,e),{...await e,state:r.state}}return this.logger.verbose("acquireTokenSilent has been called previously, returning the result from the first call",n),o.discard(),{...await c,state:r.state}}async acquireTokenSilentAsync(t,r){let n;if(this.performanceClient.addQueueMeasurement(hn.AcquireTokenSilentAsync,t.correlationId),this.eventHandler.emitEvent(js.ACQUIRE_TOKEN_START,e.InteractionType.Silent,t),this.atsAsyncMeasurement=this.performanceClient.startMeasurement(hn.AcquireTokenSilentAsync,t.correlationId),this.atsAsyncMeasurement?.increment({visibilityChangeCount:0}),document.addEventListener("visibilitychange",this.trackPageVisibility),ha.isNativeAvailable(this.config,this.logger,this.nativeExtensionProvider,t.authenticationScheme)&&r.nativeAccountId){this.logger.verbose("acquireTokenSilent - attempting to acquire token from native platform");const e={...t,account:r};n=this.acquireTokenNative(e,Ri.acquireTokenSilent_silentFlow).catch((async e=>{if(e instanceof na&&oa(e)){this.logger.verbose("acquireTokenSilent - native platform unavailable, falling back to web flow"),this.nativeExtensionProvider=void 0;return this.createSilentIframeClient(t.correlationId).acquireToken(t)}throw e}))}else{this.logger.verbose("acquireTokenSilent - attempting to acquire token from web flow");const o=this.createSilentCacheClient(t.correlationId),i=await mn(o.initializeSilentRequest.bind(o),hn.InitializeSilentRequest,this.logger,this.performanceClient,t.correlationId)(t,r),s=t.cacheLookupPolicy||Oi.Default;n=mn(this.acquireTokenFromCache.bind(this),hn.AcquireTokenFromCache,this.logger,this.performanceClient,i.correlationId)(o,i,s).catch((r=>{if(t.cacheLookupPolicy===Oi.AccessToken)throw r;return Ji(),this.eventHandler.emitEvent(js.ACQUIRE_TOKEN_NETWORK_START,e.InteractionType.Silent,i),mn(this.acquireTokenByRefreshToken.bind(this),hn.AcquireTokenByRefreshToken,this.logger,this.performanceClient,i.correlationId)(i,s).catch((e=>{const t=function(e,t,r){const n=!(e instanceof On&&e.subError!==Rn),o=e.errorCode===ti.INVALID_GRANT_ERROR||e.errorCode===tt,i=n&&o||e.errorCode===Tn||e.errorCode===An,s=qi.includes(r);return i&&s}(e,0,s);if(t)return this.logger.verbose("Refresh token expired/invalid or CacheLookupPolicy is set to Skip, attempting acquire token by iframe.",i.correlationId),mn(this.acquireTokenBySilentIframe.bind(this),hn.AcquireTokenBySilentIframe,this.logger,this.performanceClient,i.correlationId)(i);throw e}))}))}return n.then((t=>(this.eventHandler.emitEvent(js.ACQUIRE_TOKEN_SUCCESS,e.InteractionType.Silent,t),this.atsAsyncMeasurement?.end({success:!0,fromCache:t.fromCache,isNativeBroker:t.fromNativeBroker,requestId:t.requestId}),t))).catch((t=>{throw this.eventHandler.emitEvent(js.ACQUIRE_TOKEN_FAILURE,e.InteractionType.Silent,null,t),this.atsAsyncMeasurement?.end({errorCode:t.errorCode,subErrorCode:t.subError,success:!1}),t})).finally((()=>{document.removeEventListener("visibilitychange",this.trackPageVisibility)}))}}var ba=Object.freeze({__proto__:null,StandardController:Ra});class _a{static async createPublicClientApplication(e){const t=await async function(e){const t=new Is(e);return await t.initialize(),(await Promise.resolve().then((function(){return ba}))).StandardController.createController(t)}(e);return new _a(e,t)}constructor(e,t){if(t)this.controller=t;else{const t=new Is(e);this.controller=new Ra(t)}}async initialize(){return this.controller.initialize()}async acquireTokenPopup(e){return this.controller.acquireTokenPopup(e)}acquireTokenRedirect(e){return this.controller.acquireTokenRedirect(e)}acquireTokenSilent(e){return this.controller.acquireTokenSilent(e)}acquireTokenByCode(e){return this.controller.acquireTokenByCode(e)}addEventCallback(e){return this.controller.addEventCallback(e)}removeEventCallback(e){return this.controller.removeEventCallback(e)}addPerformanceCallback(e){return this.controller.addPerformanceCallback(e)}removePerformanceCallback(e){return this.controller.removePerformanceCallback(e)}enableAccountStorageEvents(){this.controller.enableAccountStorageEvents()}disableAccountStorageEvents(){this.controller.disableAccountStorageEvents()}getAccount(e){return this.controller.getAccount(e)}getAccountByHomeId(e){return this.controller.getAccountByHomeId(e)}getAccountByLocalId(e){return this.controller.getAccountByLocalId(e)}getAccountByUsername(e){return this.controller.getAccountByUsername(e)}getAllAccounts(e){return this.controller.getAllAccounts(e)}handleRedirectPromise(e){return this.controller.handleRedirectPromise(e)}loginPopup(e){return this.controller.loginPopup(e)}loginRedirect(e){return this.controller.loginRedirect(e)}logout(e){return this.controller.logout(e)}logoutRedirect(e){return this.controller.logoutRedirect(e)}logoutPopup(e){return this.controller.logoutPopup(e)}ssoSilent(e){return this.controller.ssoSilent(e)}getTokenCache(){return this.controller.getTokenCache()}getLogger(){return this.controller.getLogger()}setLogger(e){this.controller.setLogger(e)}setActiveAccount(e){this.controller.setActiveAccount(e)}getActiveAccount(){return this.controller.getActiveAccount()}initializeWrapperLibrary(e,t){return this.controller.initializeWrapperLibrary(e,t)}setNavigationClient(e){this.controller.setNavigationClient(e)}getConfiguration(){return this.controller.getConfiguration()}async hydrateCache(e,t){return this.controller.hydrateCache(e,t)}clearCache(e){return this.controller.clearCache(e)}}class Pa{constructor(e){this.initialized=!1,this.operatingContext=e,this.isBrowserEnvironment=this.operatingContext.isBrowserEnvironment(),this.config=e.getConfig(),this.logger=e.getLogger(),this.performanceClient=this.config.telemetry.client,this.browserCrypto=this.isBrowserEnvironment?new Os(this.logger,this.performanceClient):yt,this.browserStorage=this.isBrowserEnvironment?new Gs(this.config.auth.clientId,this.config.cache,this.browserCrypto,this.logger):Qs(this.config.auth.clientId,this.logger),this.eventHandler=new Ws(this.logger,this.browserCrypto)}getBrowserStorage(){return this.browserStorage}getEventHandler(){return this.eventHandler}getAccount(e){return null}getAccountByHomeId(e){return null}getAccountByLocalId(e){return null}getAccountByUsername(e){return null}getAllAccounts(){return[]}initialize(){return this.initialized=!0,Promise.resolve()}acquireTokenPopup(e){return ts(this.initialized),es(this.isBrowserEnvironment),{}}acquireTokenRedirect(e){return ts(this.initialized),es(this.isBrowserEnvironment),Promise.resolve()}acquireTokenSilent(e){return ts(this.initialized),es(this.isBrowserEnvironment),{}}acquireTokenByCode(e){return ts(this.initialized),es(this.isBrowserEnvironment),{}}acquireTokenNative(e,t,r){return ts(this.initialized),es(this.isBrowserEnvironment),{}}acquireTokenByRefreshToken(e,t){return ts(this.initialized),es(this.isBrowserEnvironment),{}}addEventCallback(e){return this.eventHandler.addEventCallback(e)}removeEventCallback(e){this.eventHandler.removeEventCallback(e)}addPerformanceCallback(e){return ts(this.initialized),es(this.isBrowserEnvironment),""}removePerformanceCallback(e){return ts(this.initialized),es(this.isBrowserEnvironment),!0}enableAccountStorageEvents(){ts(this.initialized),es(this.isBrowserEnvironment)}disableAccountStorageEvents(){ts(this.initialized),es(this.isBrowserEnvironment)}handleRedirectPromise(e){return ts(this.initialized),Promise.resolve(null)}loginPopup(e){return ts(this.initialized),es(this.isBrowserEnvironment),{}}loginRedirect(e){return ts(this.initialized),es(this.isBrowserEnvironment),{}}logout(e){return ts(this.initialized),es(this.isBrowserEnvironment),{}}logoutRedirect(e){return ts(this.initialized),es(this.isBrowserEnvironment),{}}logoutPopup(e){return ts(this.initialized),es(this.isBrowserEnvironment),{}}ssoSilent(e){return ts(this.initialized),es(this.isBrowserEnvironment),{}}getTokenCache(){return ts(this.initialized),es(this.isBrowserEnvironment),{}}getLogger(){return this.logger}setLogger(e){ts(this.initialized),es(this.isBrowserEnvironment)}setActiveAccount(e){ts(this.initialized),es(this.isBrowserEnvironment)}getActiveAccount(){return ts(this.initialized),es(this.isBrowserEnvironment),null}initializeWrapperLibrary(e,t){this.browserStorage.setWrapperMetadata(e,t)}setNavigationClient(e){ts(this.initialized),es(this.isBrowserEnvironment)}getConfiguration(){return this.config}isBrowserEnv(){return ts(this.initialized),es(this.isBrowserEnvironment),!0}getBrowserCrypto(){return ts(this.initialized),es(this.isBrowserEnvironment),{}}getPerformanceClient(){return ts(this.initialized),es(this.isBrowserEnvironment),{}}getRedirectResponse(){return ts(this.initialized),es(this.isBrowserEnvironment),{}}preflightBrowserEnvironmentCheck(e,t){ts(this.initialized),es(this.isBrowserEnvironment)}async clearCache(e){ts(this.initialized),es(this.isBrowserEnvironment)}async hydrateCache(e,t){ts(this.initialized),es(this.isBrowserEnvironment)}}class Ma extends ls{getModuleName(){return Ma.MODULE_NAME}getId(){return Ma.ID}async initialize(){return!0}}Ma.MODULE_NAME="",Ma.ID="UnknownOperatingContext";class Na{static async createPublicClientApplication(e){const t=await Ts(e);let r;return r=null!==t?new Na(e,t):new Na(e),r}constructor(e,t){if(this.configuration=e,t)this.controller=t;else{const t=new Ma(e);this.controller=new Pa(t)}}async initialize(){if(this.controller instanceof Pa){const e=await Ts(this.configuration);return null!==e&&(this.controller=e),this.controller.initialize()}return Promise.resolve()}async acquireTokenPopup(e){return this.controller.acquireTokenPopup(e)}acquireTokenRedirect(e){return this.controller.acquireTokenRedirect(e)}acquireTokenSilent(e){return this.controller.acquireTokenSilent(e)}acquireTokenByCode(e){return this.controller.acquireTokenByCode(e)}addEventCallback(e){return this.controller.addEventCallback(e)}removeEventCallback(e){return this.controller.removeEventCallback(e)}addPerformanceCallback(e){return this.controller.addPerformanceCallback(e)}removePerformanceCallback(e){return this.controller.removePerformanceCallback(e)}enableAccountStorageEvents(){this.controller.enableAccountStorageEvents()}disableAccountStorageEvents(){this.controller.disableAccountStorageEvents()}getAccount(e){return this.controller.getAccount(e)}getAccountByHomeId(e){return this.controller.getAccountByHomeId(e)}getAccountByLocalId(e){return this.controller.getAccountByLocalId(e)}getAccountByUsername(e){return this.controller.getAccountByUsername(e)}getAllAccounts(e){return this.controller.getAllAccounts(e)}handleRedirectPromise(e){return this.controller.handleRedirectPromise(e)}loginPopup(e){return this.controller.loginPopup(e)}loginRedirect(e){return this.controller.loginRedirect(e)}logout(e){return this.controller.logout(e)}logoutRedirect(e){return this.controller.logoutRedirect(e)}logoutPopup(e){return this.controller.logoutPopup(e)}ssoSilent(e){return this.controller.ssoSilent(e)}getTokenCache(){return this.controller.getTokenCache()}getLogger(){return this.controller.getLogger()}setLogger(e){this.controller.setLogger(e)}setActiveAccount(e){this.controller.setActiveAccount(e)}getActiveAccount(){return this.controller.getActiveAccount()}initializeWrapperLibrary(e,t){return this.controller.initializeWrapperLibrary(e,t)}setNavigationClient(e){this.controller.setNavigationClient(e)}getConfiguration(){return this.controller.getConfiguration()}async hydrateCache(e,t){return this.controller.hydrateCache(e,t)}clearCache(e){return this.controller.clearCache(e)}}const Oa={initialize:()=>Promise.reject(Ks(Us)),acquireTokenPopup:()=>Promise.reject(Ks(Us)),acquireTokenRedirect:()=>Promise.reject(Ks(Us)),acquireTokenSilent:()=>Promise.reject(Ks(Us)),acquireTokenByCode:()=>Promise.reject(Ks(Us)),getAllAccounts:()=>[],getAccountByHomeId:()=>null,getAccountByUsername:()=>null,getAccountByLocalId:()=>null,handleRedirectPromise:()=>Promise.reject(Ks(Us)),loginPopup:()=>Promise.reject(Ks(Us)),loginRedirect:()=>Promise.reject(Ks(Us)),logout:()=>Promise.reject(Ks(Us)),logoutRedirect:()=>Promise.reject(Ks(Us)),logoutPopup:()=>Promise.reject(Ks(Us)),ssoSilent:()=>Promise.reject(Ks(Us)),addEventCallback:()=>null,removeEventCallback:()=>{},addPerformanceCallback:()=>"",removePerformanceCallback:()=>!1,enableAccountStorageEvents:()=>{},disableAccountStorageEvents:()=>{},getTokenCache:()=>{throw Ks(Us)},getLogger:()=>{throw Ks(Us)},setLogger:()=>{},setActiveAccount:()=>{},getActiveAccount:()=>null,initializeWrapperLibrary:()=>{},setNavigationClient:()=>{},getConfiguration:()=>{throw Ks(Us)},hydrateCache:()=>Promise.reject(Ks(Us)),clearCache:()=>Promise.reject(Ks(Us))};function qa(){let e;try{e=window[li.SessionStorage];const t=e?.getItem("msal.browser.performance.enabled");if(1===Number(t))return Promise.resolve().then((function(){return Ba}))}catch(e){}}function La(){return"undefined"!=typeof window&&void 0!==window.performance&&"function"==typeof window.performance.now}function Ua(e){if(e&&La())return Math.round(window.performance.now()-e)}class Ha{constructor(e,t){this.correlationId=t,this.measureName=Ha.makeMeasureName(e,t),this.startMark=Ha.makeStartMark(e,t),this.endMark=Ha.makeEndMark(e,t)}static makeMeasureName(e,t){return`msal.measure.${e}.${t}`}static makeStartMark(e,t){return`msal.start.${e}.${t}`}static makeEndMark(e,t){return`msal.end.${e}.${t}`}static supportsBrowserPerformance(){return"undefined"!=typeof window&&void 0!==window.performance&&"function"==typeof window.performance.mark&&"function"==typeof window.performance.measure&&"function"==typeof window.performance.clearMarks&&"function"==typeof window.performance.clearMeasures&&"function"==typeof window.performance.getEntriesByName}static flushMeasurements(e,t){if(Ha.supportsBrowserPerformance())try{t.forEach((t=>{const r=Ha.makeMeasureName(t.name,e);window.performance.getEntriesByName(r,"measure").length>0&&(window.performance.clearMeasures(r),window.performance.clearMarks(Ha.makeStartMark(r,e)),window.performance.clearMarks(Ha.makeEndMark(r,e)))}))}catch(e){}}startMeasurement(){if(Ha.supportsBrowserPerformance())try{window.performance.mark(this.startMark)}catch(e){}}endMeasurement(){if(Ha.supportsBrowserPerformance())try{window.performance.mark(this.endMark),window.performance.measure(this.measureName,this.startMark,this.endMark)}catch(e){}}flushMeasurement(){if(Ha.supportsBrowserPerformance())try{const e=window.performance.getEntriesByName(this.measureName,"measure");if(e.length>0){const t=e[0].duration;return window.performance.clearMeasures(this.measureName),window.performance.clearMarks(this.startMark),window.performance.clearMarks(this.endMark),t}}catch(e){}return null}}var Ba=Object.freeze({__proto__:null,BrowserPerformanceMeasurement:Ha});class Da{constructor(e,t,r,n){this.clientId=e,this.clientCapabilities=t,this.crypto=r,this.logger=n}toNaaTokenRequest(e){let t;t=void 0===e.extraQueryParameters?new Map:new Map(Object.entries(e.extraQueryParameters));const r=(new ln).addClientCapabilitiesToClaims(e.claims,this.clientCapabilities);return{platformBrokerId:e.account?.homeAccountId,clientId:this.clientId,authority:e.authority,scope:e.scopes.join(" "),correlationId:void 0!==e.correlationId?e.correlationId:this.crypto.createNewGuid(),claims:yr.isEmptyObj(r)?void 0:r,state:e.state,authenticationScheme:e.authenticationScheme||j.BEARER,extraParameters:t}}fromNaaTokenResponse(e,t,r){if(!t.token.id_token||!t.token.access_token)throw Ct(Ee);const n=new Date(1e3*(r+(t.token.expires_in||0))),o=kt(t.token.id_token,this.crypto.base64Decode),i=this.fromNaaAccountInfo(t.account,o),s=t.token.scope||e.scope;return{authority:t.token.authority||i.environment,uniqueId:i.localAccountId,tenantId:i.tenantId,scopes:s.split(" "),account:i,idToken:t.token.id_token,idTokenClaims:o,accessToken:t.token.access_token,fromCache:!0,expiresOn:n,tokenType:e.authenticationScheme||j.BEARER,correlationId:e.correlationId,extExpiresOn:n,state:e.state}}fromNaaAccountInfo(e,t){const r=t||e.idTokenClaims,n=e.localAccountId||r?.oid||r?.sub||"",o=e.tenantId||r?.tid||"",i=e.homeAccountId||`${n}.${o}`,s=e.username||r?.preferred_username||"",a=e.name||r?.name;return{homeAccountId:i,environment:e.environment,tenantId:o,username:s,localAccountId:n,name:a,idToken:e.idToken,idTokenClaims:r}}fromBridgeError(e){if(!function(e){return void 0!==e.status}(e))return new Te("unknown_error","An unknown error occurred");switch(e.status){case ds:return new ft(lt);case us:return new ft(ct);case fs:return new ft(Ve);case ms:return new ft(ut);case Cs:return new ft(e.code||ut,e.description);case gs:case ps:return new Jr(e.code,e.description);case hs:return new On(e.code,e.description);default:return new Te(e.code,e.description)}}}const xa={code:"unsupported_method",desc:"The PKCE code challenge and verifier could not be generated."};class Fa extends Te{constructor(e,t){super(e,t),Object.setPrototypeOf(this,Fa.prototype),this.name="NestedAppAuthError"}static createUnsupportedError(){return new Fa(xa.code,xa.desc)}}class Ka{constructor(e){this.operatingContext=e;const t=this.operatingContext.getBridgeProxy();if(void 0===t)throw new Error("unexpected: bridgeProxy is undefined");this.bridgeProxy=t,this.config=e.getConfig(),this.logger=this.operatingContext.getLogger(),this.performanceClient=this.config.telemetry.client,this.browserCrypto=e.isBrowserEnvironment()?new Os(this.logger,this.performanceClient):yt,this.eventHandler=new Ws(this.logger,this.browserCrypto),this.nestedAppAuthAdapter=new Da(this.config.auth.clientId,this.config.auth.clientCapabilities,this.browserCrypto,this.logger)}getBrowserStorage(){throw Fa.createUnsupportedError()}getEventHandler(){return this.eventHandler}static async createController(e){const t=new Ka(e);return Promise.resolve(t)}initialize(){return Promise.resolve()}async acquireTokenInteractive(t){this.eventHandler.emitEvent(js.ACQUIRE_TOKEN_START,e.InteractionType.Popup,t);const r=this.performanceClient.startMeasurement(hn.AcquireTokenPopup,t.correlationId);r?.add({nestedAppAuthRequest:!0});try{const n=this.nestedAppAuthAdapter.toNaaTokenRequest(t),o=Et(),i=await this.bridgeProxy.getTokenInteractive(n),s=this.nestedAppAuthAdapter.fromNaaTokenResponse(n,i,o);return this.operatingContext.setActiveAccount(s.account),this.eventHandler.emitEvent(js.ACQUIRE_TOKEN_SUCCESS,e.InteractionType.Popup,s),r.add({accessTokenSize:s.accessToken.length,idTokenSize:s.idToken.length}),r.end({success:!0,requestId:s.requestId}),s}catch(t){const n=this.nestedAppAuthAdapter.fromBridgeError(t);throw this.eventHandler.emitEvent(js.ACQUIRE_TOKEN_FAILURE,e.InteractionType.Popup,null,t),r.end({errorCode:n.errorCode,subErrorCode:n.subError,success:!1}),n}}async acquireTokenSilentInternal(t){this.eventHandler.emitEvent(js.ACQUIRE_TOKEN_START,e.InteractionType.Silent,t);const r=this.performanceClient.startMeasurement(hn.SsoSilent,t.correlationId);r?.increment({visibilityChangeCount:0}),r?.add({nestedAppAuthRequest:!0});try{const n=this.nestedAppAuthAdapter.toNaaTokenRequest(t),o=Et(),i=await this.bridgeProxy.getTokenSilent(n),s=this.nestedAppAuthAdapter.fromNaaTokenResponse(n,i,o);return this.operatingContext.setActiveAccount(s.account),this.eventHandler.emitEvent(js.ACQUIRE_TOKEN_SUCCESS,e.InteractionType.Silent,s),r?.add({accessTokenSize:s.accessToken.length,idTokenSize:s.idToken.length}),r?.end({success:!0,requestId:s.requestId}),s}catch(t){const n=this.nestedAppAuthAdapter.fromBridgeError(t);throw this.eventHandler.emitEvent(js.ACQUIRE_TOKEN_FAILURE,e.InteractionType.Silent,null,t),r?.end({errorCode:n.errorCode,subErrorCode:n.subError,success:!1}),n}}async acquireTokenPopup(e){return this.acquireTokenInteractive(e)}acquireTokenRedirect(e){throw Fa.createUnsupportedError()}async acquireTokenSilent(e){return this.acquireTokenSilentInternal(e)}acquireTokenByCode(e){throw Fa.createUnsupportedError()}acquireTokenNative(e,t,r){throw Fa.createUnsupportedError()}acquireTokenByRefreshToken(e,t){throw Fa.createUnsupportedError()}addEventCallback(e){return this.eventHandler.addEventCallback(e)}removeEventCallback(e){this.eventHandler.removeEventCallback(e)}addPerformanceCallback(e){throw Fa.createUnsupportedError()}removePerformanceCallback(e){throw Fa.createUnsupportedError()}enableAccountStorageEvents(){throw Fa.createUnsupportedError()}disableAccountStorageEvents(){throw Fa.createUnsupportedError()}getAccount(e){throw Fa.createUnsupportedError()}getAccountByHomeId(e){const t=this.operatingContext.getActiveAccount();return void 0!==t&&t.homeAccountId===e?this.nestedAppAuthAdapter.fromNaaAccountInfo(t):null}getAccountByLocalId(e){const t=this.operatingContext.getActiveAccount();return void 0!==t&&t.localAccountId===e?this.nestedAppAuthAdapter.fromNaaAccountInfo(t):null}getAccountByUsername(e){const t=this.operatingContext.getActiveAccount();return void 0!==t&&t.username===e?this.nestedAppAuthAdapter.fromNaaAccountInfo(t):null}getAllAccounts(){const e=this.operatingContext.getActiveAccount();return void 0!==e?[this.nestedAppAuthAdapter.fromNaaAccountInfo(e)]:[]}handleRedirectPromise(e){throw Fa.createUnsupportedError()}loginPopup(e){if(void 0!==e)return this.acquireTokenInteractive(e);throw Fa.createUnsupportedError()}loginRedirect(e){throw Fa.createUnsupportedError()}logout(e){throw Fa.createUnsupportedError()}logoutRedirect(e){throw Fa.createUnsupportedError()}logoutPopup(e){throw Fa.createUnsupportedError()}ssoSilent(e){return this.acquireTokenSilentInternal(e)}getTokenCache(){throw Fa.createUnsupportedError()}getLogger(){return this.logger}setLogger(e){this.logger=e}setActiveAccount(e){this.logger.warning("nestedAppAuth does not support setActiveAccount")}getActiveAccount(){const e=this.operatingContext.getActiveAccount();return void 0!==e?this.nestedAppAuthAdapter.fromNaaAccountInfo(e):null}initializeWrapperLibrary(e,t){}setNavigationClient(e){this.logger.warning("setNavigationClient is not supported in nested app auth")}getConfiguration(){return this.config}isBrowserEnv(){return this.operatingContext.isBrowserEnvironment()}getBrowserCrypto(){return this.browserCrypto}getPerformanceClient(){throw Fa.createUnsupportedError()}getRedirectResponse(){throw Fa.createUnsupportedError()}preflightBrowserEnvironmentCheck(e,t){throw Fa.createUnsupportedError()}async clearCache(e){throw Fa.createUnsupportedError()}async hydrateCache(e,t){throw Fa.createUnsupportedError()}}var za=Object.freeze({__proto__:null,NestedAppAuthController:Ka});e.AccountEntity=Mr,e.ApiId=Ri,e.AuthError=Te,e.AuthErrorCodes=ye,e.AuthErrorMessage=Ie,e.AuthenticationHeaderParser=class{constructor(e){this.headers=e}getShrNonce(){const e=this.headers[u];if(e){const t=this.parseChallenges(e);if(t.nextnonce)return t.nextnonce;throw Cr(lr)}const t=this.headers[d];if(t){const e=this.parseChallenges(t);if(e.nonce)return e.nonce;throw Cr(lr)}throw Cr(cr)}parseChallenges(e){const r=e.indexOf(" "),n=e.substr(r+1).split(","),o={};return n.forEach((e=>{const[r,n]=e.split("=");o[r]=unescape(n.replace(/['"]+/g,t.EMPTY_STRING))})),o}},e.AuthenticationScheme=j,e.AzureCloudInstance=At,e.BrowserAuthError=Zo,e.BrowserAuthErrorCodes=Yo,e.BrowserAuthErrorMessage=Xo,e.BrowserCacheLocation=li,e.BrowserConfigurationAuthError=Fs,e.BrowserConfigurationAuthErrorCodes=Bs,e.BrowserConfigurationAuthErrorMessage=xs,e.BrowserPerformanceClient=class extends ro{constructor(e,r){super(e.auth.clientId,e.auth.authority||`${t.DEFAULT_AUTHORITY}`,new It(e.system?.loggerOptions||{},as,cs),as,cs,e.telemetry?.application||{appName:"",appVersion:""},r)}generateId(){return zi()}getPageVisibility(){return document.visibilityState?.toString()||null}deleteIncompleteSubMeasurements(e){qa()?.then((t=>{const r=this.eventsByCorrelationId.get(e.event.correlationId),n=r&&r.eventId===e.event.eventId,o=[];n&&r?.incompleteSubMeasurements&&r.incompleteSubMeasurements.forEach((e=>{o.push({...e})})),t.BrowserPerformanceMeasurement.flushMeasurements(e.event.correlationId,o)}))}startMeasurement(e,t){const r=this.getPageVisibility(),n=super.startMeasurement(e,t),o=La()?window.performance.now():void 0,i=qa()?.then((t=>new t.BrowserPerformanceMeasurement(e,n.event.correlationId)));return i?.then((e=>e.startMeasurement())),{...n,end:e=>{const t=n.end({...e,startPageVisibility:r,endPageVisibility:this.getPageVisibility(),durationMs:Ua(o)});return i?.then((e=>e.endMeasurement())),this.deleteIncompleteSubMeasurements(n),t},discard:()=>{n.discard(),i?.then((e=>e.flushMeasurement())),this.deleteIncompleteSubMeasurements(n)}}}setPreQueueTime(e,t){if(!La())return void this.logger.trace(`BrowserPerformanceClient: window performance API not available, unable to set telemetry queue time for ${e}`);if(!t)return void this.logger.trace(`BrowserPerformanceClient: correlationId for ${e} not provided, unable to set telemetry queue time`);const r=this.preQueueTimeByCorrelationId.get(t);r&&(this.logger.trace(`BrowserPerformanceClient: Incomplete pre-queue ${r.name} found`,t),this.addQueueMeasurement(r.name,t,void 0,!0)),this.preQueueTimeByCorrelationId.set(t,{name:e,time:window.performance.now()})}addQueueMeasurement(e,t,r,n){if(!La())return void this.logger.trace(`BrowserPerformanceClient: window performance API not available, unable to add queue measurement for ${e}`);if(!t)return void this.logger.trace(`BrowserPerformanceClient: correlationId for ${e} not provided, unable to add queue measurement`);const o=super.getPreQueueTime(e,t);if(!o)return;const i=window.performance.now(),s=r||super.calculateQueuedTime(o,i);return super.addQueueMeasurement(e,t,s,n)}},e.BrowserPerformanceMeasurement=Ha,e.BrowserStorage=zs,e.BrowserUtils=ns,e.CacheLookupPolicy=Oi,e.ClientAuthError=ft,e.ClientAuthErrorCodes=gt,e.ClientAuthErrorMessage=mt,e.ClientConfigurationError=fr,e.ClientConfigurationErrorCodes=gr,e.ClientConfigurationErrorMessage=mr,e.DEFAULT_IFRAME_TIMEOUT_MS=ss,e.EventMessageUtils=class{static getInteractionStatusFromEvent(t,r){switch(t.eventType){case js.LOGIN_START:return _i.Login;case js.SSO_SILENT_START:return _i.SsoSilent;case js.ACQUIRE_TOKEN_START:if(t.interactionType===e.InteractionType.Redirect||t.interactionType===e.InteractionType.Popup)return _i.AcquireToken;break;case js.HANDLE_REDIRECT_START:return _i.HandleRedirect;case js.LOGOUT_START:return _i.Logout;case js.SSO_SILENT_SUCCESS:case js.SSO_SILENT_FAILURE:if(r&&r!==_i.SsoSilent)break;return _i.None;case js.LOGOUT_END:if(r&&r!==_i.Logout)break;return _i.None;case js.HANDLE_REDIRECT_END:if(r&&r!==_i.HandleRedirect)break;return _i.None;case js.LOGIN_SUCCESS:case js.LOGIN_FAILURE:case js.ACQUIRE_TOKEN_SUCCESS:case js.ACQUIRE_TOKEN_FAILURE:case js.RESTORE_FROM_BFCACHE:if(t.interactionType===e.InteractionType.Redirect||t.interactionType===e.InteractionType.Popup){if(r&&r!==_i.Login&&r!==_i.AcquireToken)break;return _i.None}}return null}},e.EventType=js,e.InteractionRequiredAuthError=On,e.InteractionRequiredAuthErrorCodes=bn,e.InteractionRequiredAuthErrorMessage=Nn,e.InteractionStatus=_i,e.JsonWebTokenTypes=me,e.Logger=It,e.MemoryStorage=bs,e.NavigationClient=os,e.OIDC_DEFAULT_SCOPES=s,e.PerformanceEvents=hn,e.PromptValue=R,e.ProtocolMode=Pr,e.PublicClientApplication=_a,e.PublicClientNext=Na,e.ServerError=Jr,e.ServerResponseType=_,e.SignedHttpRequest=class{constructor(e,t){const r=t&&t.loggerOptions||{};this.logger=new It(r,as,cs),this.cryptoOps=new Os(this.logger),this.popTokenGenerator=new Dn(this.cryptoOps),this.shrParameters=e}async generatePublicKeyThumbprint(){const{kid:e}=await this.popTokenGenerator.generateKid(this.shrParameters);return e}async signRequest(e,t,r){return this.popTokenGenerator.signPayload(e,t,this.shrParameters,r)}async removeKeys(e){return this.cryptoOps.removeTokenBindingKey(e)}},e.StringUtils=yr,e.UrlString=qr,e.WrapperSKU={React:"@azure/msal-react",Angular:"@azure/msal-angular"},e.stubbedPublicClientApplication=Oa,e.version=cs}));
