/*! @azure/msal-browser v3.10.0 2024-02-17 */
'use strict';
import { BaseOperatingContext } from './BaseOperatingContext.mjs';
import { BridgeProxy } from '../naa/BridgeProxy.mjs';

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
class TeamsAppOperatingContext extends BaseOperatingContext {
    constructor() {
        super(...arguments);
        this.bridgeProxy = undefined;
        this.activeAccount = undefined;
    }
    /**
     * Return the module name.  Intended for use with import() to enable dynamic import
     * of the implementation associated with this operating context
     * @returns
     */
    getModuleName() {
        return TeamsAppOperatingContext.MODULE_NAME;
    }
    /**
     * Returns the unique identifier for this operating context
     * @returns string
     */
    getId() {
        return TeamsAppOperatingContext.ID;
    }
    getBridgeProxy() {
        return this.bridgeProxy;
    }
    getActiveAccount() {
        return this.activeAccount;
    }
    setActiveAccount(account) {
        this.activeAccount = account;
    }
    /**
     * Checks whether the operating context is available.
     * Confirms that the code is running a browser rather.  This is required.
     * @returns Promise<boolean> indicating whether this operating context is currently available.
     */
    async initialize() {
        /*
         * TODO: Add implementation to check for presence of inject Nested App Auth Bridge JavaScript interface
         *
         */
        try {
            if (typeof window !== "undefined") {
                const bridgeProxy = await BridgeProxy.create();
                /*
                 * Because we want single sign on we need to attempt to
                 * grab the active account as part of initialization
                 * this.activeAccount = await bridgeProxy.getActiveAccount();
                 */
                try {
                    if (bridgeProxy.getHostCapabilities()?.queryAccount) {
                        this.activeAccount =
                            await bridgeProxy.getActiveAccount();
                    }
                }
                catch (e) {
                    this.activeAccount = undefined;
                }
                this.bridgeProxy = bridgeProxy;
                this.available = bridgeProxy !== undefined;
            }
            else {
                this.available = false;
            }
        }
        catch (e) {
            this.available = false;
        }
        finally {
            return this.available;
        }
    }
}
/*
 * TODO: Once we have determine the bundling code return here to specify the name of the bundle
 * containing the implementation for this operating context
 */
TeamsAppOperatingContext.MODULE_NAME = "";
/**
 * Unique identifier for the operating context
 */
TeamsAppOperatingContext.ID = "TeamsAppOperatingContext";

export { TeamsAppOperatingContext };
//# sourceMappingURL=TeamsAppOperatingContext.mjs.map
