import { TokenRequest } from "../TokenRequest";
import { AccountInfo as NaaAccountInfo } from "../AccountInfo";
import { RedirectRequest } from "../../request/RedirectRequest";
import { PopupRequest } from "../../request/PopupRequest";
import { AccountInfo as MsalAccountInfo, AuthError, ClientAuthError, ClientConfigurationError, InteractionRequiredAuthError, ServerError, ICrypto, Logger, TokenClaims } from "@azure/msal-common";
import { AuthenticationResult } from "../../response/AuthenticationResult";
import { AuthResult } from "../AuthResult";
export declare class NestedAppAuthAdapter {
    protected crypto: ICrypto;
    protected logger: Logger;
    protected clientId: string;
    protected clientCapabilities: string[];
    constructor(clientId: string, clientCapabilities: string[], crypto: ICrypto, logger: Logger);
    toNaaTokenRequest(request: PopupRequest | RedirectRequest): TokenRequest;
    fromNaaTokenResponse(request: TokenRequest, response: AuthResult, reqTimestamp: number): AuthenticationResult;
    fromNaaAccountInfo(fromAccount: NaaAccountInfo, idTokenClaims?: TokenClaims): MsalAccountInfo;
    /**
     *
     * @param error BridgeError
     * @returns AuthError, ClientAuthError, ClientConfigurationError, ServerError, InteractionRequiredError
     */
    fromBridgeError(error: unknown): AuthError | ClientAuthError | ClientConfigurationError | ServerError | InteractionRequiredAuthError;
}
//# sourceMappingURL=NestedAppAuthAdapter.d.ts.map