import { CommonAuthorizationUrlRequest, CommonSilentFlowRequest, PerformanceCallbackFunction, AccountInfo, Logger, ICrypto, IPerformanceClient, AccountFilter } from "@azure/msal-common";
import { ITokenCache } from "../cache/ITokenCache";
import { BrowserConfiguration } from "../config/Configuration";
import { INavigationClient } from "../navigation/INavigationClient";
import { AuthorizationCodeRequest } from "../request/AuthorizationCodeRequest";
import { EndSessionPopupRequest } from "../request/EndSessionPopupRequest";
import { EndSessionRequest } from "../request/EndSessionRequest";
import { PopupRequest } from "../request/PopupRequest";
import { RedirectRequest } from "../request/RedirectRequest";
import { SilentRequest } from "../request/SilentRequest";
import { SsoSilentRequest } from "../request/SsoSilentRequest";
import { ApiId, WrapperSKU, InteractionType } from "../utils/BrowserConstants";
import { IController } from "./IController";
import { TeamsAppOperatingContext } from "../operatingcontext/TeamsAppOperatingContext";
import { IBridgeProxy } from "../naa/IBridgeProxy";
import { NestedAppAuthAdapter } from "../naa/mapping/NestedAppAuthAdapter";
import { EventHandler } from "../event/EventHandler";
import { EventCallbackFunction } from "../event/EventMessage";
import { AuthenticationResult } from "../response/AuthenticationResult";
import { BrowserCacheManager } from "../cache/BrowserCacheManager";
import { ClearCacheRequest } from "../request/ClearCacheRequest";
export declare class NestedAppAuthController implements IController {
    protected readonly operatingContext: TeamsAppOperatingContext;
    protected readonly bridgeProxy: IBridgeProxy;
    protected readonly browserCrypto: ICrypto;
    protected readonly config: BrowserConfiguration;
    protected logger: Logger;
    protected readonly performanceClient: IPerformanceClient;
    protected readonly eventHandler: EventHandler;
    protected readonly nestedAppAuthAdapter: NestedAppAuthAdapter;
    constructor(operatingContext: TeamsAppOperatingContext);
    getBrowserStorage(): BrowserCacheManager;
    getEventHandler(): EventHandler;
    static createController(operatingContext: TeamsAppOperatingContext): Promise<IController>;
    initialize(): Promise<void>;
    private acquireTokenInteractive;
    private acquireTokenSilentInternal;
    acquireTokenPopup(request: PopupRequest): Promise<AuthenticationResult>;
    acquireTokenRedirect(request: RedirectRequest): Promise<void>;
    acquireTokenSilent(silentRequest: SilentRequest): Promise<AuthenticationResult>;
    acquireTokenByCode(request: AuthorizationCodeRequest): Promise<AuthenticationResult>;
    acquireTokenNative(request: SilentRequest | Partial<Omit<CommonAuthorizationUrlRequest, "requestedClaimsHash" | "responseMode" | "codeChallenge" | "codeChallengeMethod" | "nativeBroker">> | PopupRequest, apiId: ApiId, // eslint-disable-line @typescript-eslint/no-unused-vars
    accountId?: string | undefined): Promise<AuthenticationResult>;
    acquireTokenByRefreshToken(commonRequest: CommonSilentFlowRequest, // eslint-disable-line @typescript-eslint/no-unused-vars
    silentRequest: SilentRequest): Promise<AuthenticationResult>;
    /**
     * Adds event callbacks to array
     * @param callback
     */
    addEventCallback(callback: EventCallbackFunction): string | null;
    /**
     * Removes callback with provided id from callback array
     * @param callbackId
     */
    removeEventCallback(callbackId: string): void;
    addPerformanceCallback(callback: PerformanceCallbackFunction): string;
    removePerformanceCallback(callbackId: string): boolean;
    enableAccountStorageEvents(): void;
    disableAccountStorageEvents(): void;
    getAccount(accountFilter: AccountFilter): AccountInfo | null;
    getAccountByHomeId(homeAccountId: string): AccountInfo | null;
    getAccountByLocalId(localId: string): AccountInfo | null;
    getAccountByUsername(userName: string): AccountInfo | null;
    getAllAccounts(): AccountInfo[];
    handleRedirectPromise(hash?: string | undefined): Promise<AuthenticationResult | null>;
    loginPopup(request?: PopupRequest | undefined): Promise<AuthenticationResult>;
    loginRedirect(request?: RedirectRequest | undefined): Promise<void>;
    logout(logoutRequest?: EndSessionRequest | undefined): Promise<void>;
    logoutRedirect(logoutRequest?: EndSessionRequest | undefined): Promise<void>;
    logoutPopup(logoutRequest?: EndSessionPopupRequest | undefined): Promise<void>;
    ssoSilent(request: Partial<Omit<CommonAuthorizationUrlRequest, "requestedClaimsHash" | "responseMode" | "codeChallenge" | "codeChallengeMethod" | "nativeBroker">>): Promise<AuthenticationResult>;
    getTokenCache(): ITokenCache;
    /**
     * Returns the logger instance
     */
    getLogger(): Logger;
    /**
     * Replaces the default logger set in configurations with new Logger with new configurations
     * @param logger Logger instance
     */
    setLogger(logger: Logger): void;
    setActiveAccount(account: AccountInfo | null): void;
    getActiveAccount(): AccountInfo | null;
    initializeWrapperLibrary(sku: WrapperSKU, version: string): void;
    setNavigationClient(navigationClient: INavigationClient): void;
    getConfiguration(): BrowserConfiguration;
    isBrowserEnv(): boolean;
    getBrowserCrypto(): ICrypto;
    getPerformanceClient(): IPerformanceClient;
    getRedirectResponse(): Map<string, Promise<AuthenticationResult | null>>;
    preflightBrowserEnvironmentCheck(interactionType: InteractionType, // eslint-disable-line @typescript-eslint/no-unused-vars
    setInteractionInProgress?: boolean | undefined): void;
    clearCache(logoutRequest?: ClearCacheRequest): Promise<void>;
    hydrateCache(result: AuthenticationResult, request: SilentRequest | SsoSilentRequest | RedirectRequest | PopupRequest): Promise<void>;
}
//# sourceMappingURL=NestedAppAuthController.d.ts.map