/*! @azure/msal-browser v3.10.0 2024-02-17 */
'use strict';
import { TeamsAppOperatingContext } from '../operatingcontext/TeamsAppOperatingContext.mjs';
import { StandardOperatingContext } from '../operatingcontext/StandardOperatingContext.mjs';

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
async function createV3Controller(config) {
    const standard = new StandardOperatingContext(config);
    await standard.initialize();
    const controller = await import('./StandardController.mjs');
    return controller.StandardController.createController(standard);
}
async function createController(config) {
    const standard = new StandardOperatingContext(config);
    const teamsApp = new TeamsAppOperatingContext(config);
    const operatingContexts = [standard.initialize(), teamsApp.initialize()];
    await Promise.all(operatingContexts);
    if (teamsApp.isAvailable() &&
        teamsApp.getConfig().auth.supportsNestedAppAuth) {
        const controller = await import('./NestedAppAuthController.mjs');
        return controller.NestedAppAuthController.createController(teamsApp);
    }
    else if (standard.isAvailable()) {
        const controller = await import('./StandardController.mjs');
        return controller.StandardController.createController(standard);
    }
    else {
        // Since neither of the actual operating contexts are available keep the UnknownOperatingContextController
        return null;
    }
}

export { createController, createV3Controller };
//# sourceMappingURL=ControllerFactory.mjs.map
