// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
export { createEmptyPipeline, } from "./pipeline";
export { createPipelineFromOptions, } from "./createPipelineFromOptions";
export { createDefaultHttpClient } from "./defaultHttpClient";
export { createHttpHeaders } from "./httpHeaders";
export { createPipelineRequest } from "./pipelineRequest";
export { RestError, isRestError } from "./restError";
export { decompressResponsePolicy, decompressResponsePolicyName, } from "./policies/decompressResponsePolicy";
export { exponentialRetryPolicy, exponentialRetryPolicyName, } from "./policies/exponentialRetryPolicy";
export { setClientRequestIdPolicy, setClientRequestIdPolicyName, } from "./policies/setClientRequestIdPolicy";
export { logPolicy, logPolicyName } from "./policies/logPolicy";
export { multipartPolicy, multipartPolicyName } from "./policies/multipartPolicy";
export { proxyPolicy, proxyPolicyName, getDefaultProxySettings } from "./policies/proxyPolicy";
export { redirectPolicy, redirectPolicyName, } from "./policies/redirectPolicy";
export { systemErrorRetryPolicy, systemErrorRetryPolicyName, } from "./policies/systemErrorRetryPolicy";
export { throttlingRetryPolicy, throttlingRetryPolicyName, } from "./policies/throttlingRetryPolicy";
export { retryPolicy } from "./policies/retryPolicy";
export { tracingPolicy, tracingPolicyName, } from "./policies/tracingPolicy";
export { defaultRetryPolicy } from "./policies/defaultRetryPolicy";
export { userAgentPolicy, userAgentPolicyName, } from "./policies/userAgentPolicy";
export { tlsPolicy, tlsPolicyName } from "./policies/tlsPolicy";
export { formDataPolicy, formDataPolicyName } from "./policies/formDataPolicy";
export { bearerTokenAuthenticationPolicy, bearerTokenAuthenticationPolicyName, } from "./policies/bearerTokenAuthenticationPolicy";
export { ndJsonPolicy, ndJsonPolicyName } from "./policies/ndJsonPolicy";
export { auxiliaryAuthenticationHeaderPolicy, auxiliaryAuthenticationHeaderPolicyName, } from "./policies/auxiliaryAuthenticationHeaderPolicy";
export { createFile, createFileFromStream, } from "./util/file";
//# sourceMappingURL=index.js.map